/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.landcover.gpf.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.esa.snap.core.dataop.resamp.ResamplingFactory;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.landcover.dataio.LandCoverFactory;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.AppContext;

public class AddLandCoverOpUI
extends BaseOperatorUI {
    private final JList<String> landCoverNamesList = new JList();
    private final JTextField externalFile = new JTextField("");
    private final JButton externalFileBrowseButton = new JButton("...");
    private final JComboBox resamplingMethodCombo = new JComboBox<String>(ResamplingFactory.resamplingNames);

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JComponent panel = this.createPanel();
        String[] Names = LandCoverFactory.getNameList();
        List<String> sortedNames = Arrays.asList(Names);
        Collections.sort(sortedNames);
        Names = sortedNames.toArray(new String[sortedNames.size()]);
        this.landCoverNamesList.setListData((String[])Names);
        this.initParameters();
        this.externalFileBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = Dialogs.requestFileForOpen((String)"External File", (boolean)false, null, (String)"snap.external.landcoverDir");
                AddLandCoverOpUI.this.externalFile.setText(file.getAbsolutePath());
                AddLandCoverOpUI.this.landCoverNamesList.clearSelection();
            }
        });
        return new JScrollPane(panel);
    }

    public void initParameters() {
        String[] selectedLandCoverNames = (String[])this.paramMap.get("landCoverNames");
        if (selectedLandCoverNames != null) {
            int[] sel = AddLandCoverOpUI.getListIndices(selectedLandCoverNames, LandCoverFactory.getNameList());
            this.landCoverNamesList.setSelectedIndices(sel);
            int[] nArray = this.landCoverNamesList.getSelectedIndices();
        }
        this.resamplingMethodCombo.setSelectedItem(this.paramMap.get("resamplingMethod"));
        File file = (File)this.paramMap.get("externalFile");
        if (file != null) {
            this.externalFile.setText(file.getAbsolutePath());
        }
    }

    private static int[] getListIndices(String[] selectedList, String[] fullList) {
        int[] selectionIndices = new int[selectedList.length];
        int j = 0;
        block0: for (String n : selectedList) {
            for (int i = 0; i < fullList.length; ++i) {
                if (!fullList[i].equals(n)) continue;
                selectionIndices[j++] = i;
                continue block0;
            }
        }
        return selectionIndices;
    }

    private static String[] getListStrings(int[] selectedList, String[] fullList) {
        ArrayList<String> stringList = new ArrayList<String>(selectedList.length);
        for (int i : selectedList) {
            stringList.add(fullList[i]);
        }
        return stringList.toArray(new String[stringList.size()]);
    }

    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        if (!this.hasSourceProducts()) {
            return;
        }
        String[] names = AddLandCoverOpUI.getListStrings(this.landCoverNamesList.getSelectedIndices(), LandCoverFactory.getNameList());
        if (names.length > 0) {
            this.paramMap.put("landCoverNames", names);
        }
        this.paramMap.put("resamplingMethod", this.resamplingMethodCombo.getSelectedItem());
        if (!this.externalFile.getText().isEmpty()) {
            this.paramMap.put("externalFile", new File(this.externalFile.getText()));
        }
    }

    private JComponent createPanel() {
        JPanel contentPane = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Land Cover Model:", this.landCoverNamesList);
        ++gbc.gridy;
        this.externalFile.setColumns(50);
        DialogUtils.addInnerPanel((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)new JLabel("External File"), (JComponent)this.externalFile, (JComponent)this.externalFileBrowseButton);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Resampling Method:", (JComponent)this.resamplingMethodCombo);
        ++gbc.gridy;
        gbc.gridx = 1;
        contentPane.add((Component)new JLabel("Integer data types will use nearest neighbour"), gbc);
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }
}

