/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.operators.tooladapter;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.OperatorSpiRegistry;
import org.esa.snap.core.gpf.descriptor.OperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.ToolAdapterOperatorDescriptor;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterListener;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterOpSpi;

public enum ToolAdapterRegistry {
    INSTANCE;

    private final Map<String, ToolAdapterOpSpi> registeredAdapters = new HashMap<String, ToolAdapterOpSpi>();
    private final Set<ToolAdapterListener> listeners = new HashSet<ToolAdapterListener>();

    public Map<String, ToolAdapterOpSpi> getOperatorMap() {
        return this.registeredAdapters;
    }

    public void registerOperator(ToolAdapterOpSpi operatorSpi) {
        OperatorDescriptor operatorDescriptor = operatorSpi.getOperatorDescriptor();
        String operatorAlias = operatorDescriptor.getAlias() != null ? operatorDescriptor.getAlias() : operatorDescriptor.getName();
        OperatorSpiRegistry operatorSpiRegistry = GPF.getDefaultInstance().getOperatorSpiRegistry();
        OperatorSpi gpfOp = operatorSpiRegistry.getOperatorSpi(operatorAlias);
        if (gpfOp != null) {
            operatorSpiRegistry.removeOperatorSpi(gpfOp);
        }
        operatorSpiRegistry.addOperatorSpi(operatorAlias, (OperatorSpi)operatorSpi);
        this.registeredAdapters.put(operatorAlias, operatorSpi);
        this.notifyAdapterAdded((ToolAdapterOperatorDescriptor)operatorSpi.getOperatorDescriptor());
    }

    public void removeOperator(ToolAdapterOperatorDescriptor operatorDescriptor) {
        OperatorSpiRegistry operatorSpiRegistry;
        OperatorSpi spi;
        String operatorDescriptorName = operatorDescriptor.getName();
        if (this.registeredAdapters.containsKey(operatorDescriptorName)) {
            this.registeredAdapters.remove(operatorDescriptorName);
        }
        if ((spi = (operatorSpiRegistry = GPF.getDefaultInstance().getOperatorSpiRegistry()).getOperatorSpi(operatorDescriptor.getAlias())) == null) {
            spi = operatorSpiRegistry.getOperatorSpi(operatorDescriptorName);
        }
        if (spi != null) {
            operatorSpiRegistry.removeOperatorSpi(spi);
            this.notifyAdapterRemoved(operatorDescriptor);
        }
    }

    public ToolAdapterOperatorDescriptor findByAlias(String alias) {
        OperatorDescriptor operatorDescriptor;
        List filtered;
        ToolAdapterOperatorDescriptor result = null;
        if (alias != null && (filtered = this.registeredAdapters.values().stream().filter(d -> alias.equals(d.getOperatorAlias()) || alias.equals(d.getOperatorDescriptor().getName())).collect(Collectors.toList())).size() > 0 && (operatorDescriptor = ((ToolAdapterOpSpi)((Object)filtered.get(0))).getOperatorDescriptor()) instanceof ToolAdapterOperatorDescriptor) {
            result = (ToolAdapterOperatorDescriptor)operatorDescriptor;
        }
        return result;
    }

    void clear() {
        this.registeredAdapters.clear();
    }

    public void addListener(ToolAdapterListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(ToolAdapterListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyAdapterAdded(ToolAdapterOperatorDescriptor adapterOperatorDescriptor) {
        if (adapterOperatorDescriptor == null) {
            return;
        }
        for (ToolAdapterListener listener : this.listeners) {
            listener.adapterAdded(adapterOperatorDescriptor);
        }
    }

    private void notifyAdapterRemoved(ToolAdapterOperatorDescriptor adapterOperatorDescriptor) {
        if (adapterOperatorDescriptor == null) {
            return;
        }
        for (ToolAdapterListener listener : this.listeners) {
            listener.adapterRemoved(adapterOperatorDescriptor);
        }
    }
}

