/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.operators.tooladapter;

import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpiRegistry;
import org.esa.snap.core.gpf.operators.tooladapter.ToolAdapterIO;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.runtime.Activator;

public class ToolAdapterActivator
implements Activator {
    public void start() {
        Set operatorSpis;
        OperatorSpiRegistry spiRegistry = GPF.getDefaultInstance().getOperatorSpiRegistry();
        Path jarPaths = SystemUtils.getApplicationDataDir().toPath().resolve("modules");
        Map<String, File> jarAdapters = this.getJarAdapters(jarPaths.toFile());
        if (spiRegistry != null && (operatorSpis = spiRegistry.getOperatorSpis()) != null) {
            operatorSpis.addAll(ToolAdapterIO.searchAndRegisterAdapters());
        }
    }

    public void stop() {
    }

    private Map<String, File> getJarAdapters(File fromPath) {
        HashMap<String, File> output = new HashMap<String, File>();
        if (fromPath != null && fromPath.exists()) {
            String descriptionKeyName = "OpenIDE-Module-Short-Description";
            Attributes.Name typeKey = new Attributes.Name("OpenIDE-Module-Type");
            File[] files = fromPath.listFiles((dir, name) -> name.endsWith("jar"));
            if (files != null) {
                try {
                    for (File file : files) {
                        JarFile jarFile = new JarFile(file);
                        Manifest manifest = jarFile.getManifest();
                        Attributes manifestEntries = manifest.getMainAttributes();
                        if (!manifestEntries.containsKey(typeKey) || !"STA".equals(manifestEntries.getValue(typeKey.toString()))) continue;
                        output.put(manifestEntries.getValue(descriptionKeyName), file);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return output;
    }
}

