/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.descriptor;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.esa.snap.core.gpf.descriptor.ToolParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.template.TemplateContext;
import org.esa.snap.core.gpf.descriptor.template.TemplateEngine;
import org.esa.snap.core.gpf.descriptor.template.TemplateException;
import org.esa.snap.core.gpf.descriptor.template.TemplateFile;
import org.esa.snap.core.gpf.descriptor.template.TemplateType;
import org.esa.snap.core.util.SystemUtils;

@XStreamAlias(value="templateparameter")
public class TemplateParameterDescriptor
extends ToolParameterDescriptor {
    @XStreamAlias(value="parameters")
    private List<ToolParameterDescriptor> parameterDescriptors = new ArrayList<ToolParameterDescriptor>();
    private TemplateFile template;
    private File outputFile;
    @XStreamOmitField
    private TemplateEngine engine;

    public TemplateParameterDescriptor() {
        this.setParameterType("TemplateParamater");
        this.parameterDescriptors = new ArrayList<ToolParameterDescriptor>();
    }

    public TemplateParameterDescriptor(String name, Class<?> type) {
        super(name, type);
        this.setParameterType("RegularParameter");
        this.parameterDescriptors = new ArrayList<ToolParameterDescriptor>();
    }

    public TemplateParameterDescriptor(ToolParameterDescriptor object) {
        super(object);
        this.setParameterType("TemplateParamater");
        this.parameterDescriptors = new ArrayList<ToolParameterDescriptor>();
        this.template = new TemplateFile(TemplateType.VELOCITY);
    }

    public TemplateParameterDescriptor(TemplateParameterDescriptor object) {
        super(object, object.getParameterType());
        this.parameterDescriptors = new ArrayList<ToolParameterDescriptor>();
        this.parameterDescriptors.addAll(object.getParameterDescriptors().stream().map(ToolParameterDescriptor::new).collect(Collectors.toList()));
        this.engine = object.engine;
        if (object.template != null) {
            try {
                this.template = object.template.copy();
                if (this.engine != null) {
                    this.template.associateWith(this.engine);
                }
            }
            catch (IOException | TemplateException ex) {
                this.template = new TemplateFile();
                try {
                    this.template.setContents("Error: " + ex.getMessage(), false);
                    if (this.engine != null) {
                        this.template.associateWith(this.engine);
                    }
                }
                catch (TemplateException e) {
                    SystemUtils.LOG.warning(e.getMessage());
                }
            }
        }
    }

    public void addParameterDescriptor(ToolParameterDescriptor descriptor) {
        this.parameterDescriptors.add(descriptor);
    }

    public void removeParameterDescriptor(ToolParameterDescriptor descriptor) {
        this.parameterDescriptors.remove((Object)descriptor);
    }

    public List<ToolParameterDescriptor> getParameterDescriptors() {
        if (this.parameterDescriptors == null) {
            this.parameterDescriptors = new ArrayList<ToolParameterDescriptor>();
        }
        return this.parameterDescriptors;
    }

    public void setTemplateEngine(TemplateEngine engine) throws TemplateException {
        this.engine = engine;
        if (this.template != null) {
            this.template.associateWith(this.engine);
        }
    }

    public TemplateContext getLastContext() {
        return this.engine != null ? this.engine.getContext() : null;
    }

    public void setTemplate(TemplateFile template) throws TemplateException {
        this.template = template;
        this.template.associateWith(this.engine);
    }

    public TemplateFile getTemplate() {
        if (this.template == null) {
            if (this.engine != null) {
                this.template = new TemplateFile(this.engine.getType());
                try {
                    this.template.associateWith(this.engine);
                }
                catch (TemplateException e) {
                    e.printStackTrace();
                }
            } else {
                this.template = new TemplateFile(TemplateType.VELOCITY);
            }
        }
        return this.template;
    }

    public String executeTemplate(Map<String, Object> params) throws TemplateException {
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        for (ToolParameterDescriptor param : this.getParameterDescriptors()) {
            if (params.containsKey(param.getName())) continue;
            params.put(param.getName(), param.getDefaultValue());
        }
        return this.engine.execute(this.template, params);
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }
}

