/*
 * Decompiled with CFR 0.152.
 */
package be.abeel.util;

import be.abeel.concurrency.DaemonThread;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUCache<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 3108325620729125294L;
    private Logger log = Logger.getLogger(LRUCache.class.getCanonicalName());
    private int maxEntries = 100;
    private long reset = System.currentTimeMillis();

    public LRUCache(int maxEntries, final long survival) {
        super(maxEntries, 0.75f, true);
        this.maxEntries = maxEntries;
        DaemonThread dt = new DaemonThread(new Runnable(){
            private long ttl;
            {
                this.ttl = survival;
            }

            public void run() {
                while (true) {
                    if (System.currentTimeMillis() - LRUCache.this.reset > this.ttl) {
                        LRUCache.this.clear();
                    }
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        LRUCache.this.log.log(Level.INFO, "LRU cleaner interrupted", e);
                        continue;
                    }
                    break;
                }
            }
        });
        dt.start();
    }

    public LRUCache(int maxEntries) {
        super(maxEntries, 0.75f, true);
        this.maxEntries = maxEntries;
    }

    @Override
    public V get(Object key) {
        this.reset = System.currentTimeMillis();
        return super.get(key);
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        if (this.size() > this.maxEntries) {
            return true;
        }
        if (this.getAvailableMemoryFraction() < 0.1) {
            this.log.info("Memory low.  Free cache entry");
            return true;
        }
        return false;
    }

    private double getAvailableMemoryFraction() {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        return (double)(freeMemory + (maxMemory - allocatedMemory)) / (double)maxMemory;
    }
}

