/*
 * Decompiled with CFR 0.152.
 */
package be.abeel.util;

import be.abeel.util.DefaultTreeMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrequencyMap
extends DefaultTreeMap<Integer, Integer> {
    private static final long serialVersionUID = -2086288572103735727L;

    public int min() {
        return (Integer)this.firstKey();
    }

    public int max() {
        return (Integer)this.lastKey();
    }

    public double std() {
        double avg = this.average();
        double sum = 0.0;
        double count = this.totalCount();
        int manualCount = 0;
        for (Map.Entry e : this.entrySet()) {
            double diff = (double)((Integer)e.getKey()).intValue() - avg;
            sum += diff * diff * (double)((Integer)e.getValue()).intValue();
            manualCount += ((Integer)e.getValue()).intValue();
        }
        return Math.sqrt(sum / count);
    }

    public int median() {
        int tc = this.totalCount();
        int runningCount = 0;
        for (Map.Entry e : this.entrySet()) {
            if ((runningCount += ((Integer)e.getValue()).intValue()) <= tc / 2) continue;
            return (Integer)e.getKey();
        }
        return (Integer)this.lastKey();
    }

    public double sum() {
        double sum = 0.0;
        for (Map.Entry e : this.entrySet()) {
            sum += (double)((Integer)e.getKey() * (Integer)e.getValue());
        }
        return sum;
    }

    public double average() {
        double sum = 0.0;
        int count = 0;
        for (Map.Entry e : this.entrySet()) {
            sum += (double)((Integer)e.getKey() * (Integer)e.getValue());
            count += ((Integer)e.getValue()).intValue();
        }
        return sum / (double)count;
    }

    public int mode() {
        int maxV = 0;
        int maxK = 0;
        for (Map.Entry e : this.entrySet()) {
            if ((Integer)e.getValue() <= maxV) continue;
            maxV = (Integer)e.getValue();
            maxK = (Integer)e.getKey();
        }
        return maxK;
    }

    public int totalCount() {
        int totalCount = 0;
        Iterator i$ = this.keySet().iterator();
        while (i$.hasNext()) {
            int k = (Integer)i$.next();
            totalCount += ((Integer)this.get(k)).intValue();
        }
        return totalCount;
    }

    public FrequencyMap() {
        super(0);
    }

    public void count(int value, int increment) {
        if (!this.containsKey(value)) {
            this.put(value, 0);
        }
        this.put(value, (Integer)this.get(value) + increment);
    }

    public void count(int value) {
        this.count(value, 1);
    }

    public FrequencyMap removeBelow(int min) {
        int k;
        HashSet<Integer> toRemove = new HashSet<Integer>();
        Iterator<Object> i$ = this.keySet().iterator();
        while (i$.hasNext()) {
            k = (Integer)i$.next();
            if ((Integer)this.get(k) >= min) continue;
            toRemove.add(k);
        }
        i$ = toRemove.iterator();
        while (i$.hasNext()) {
            k = (Integer)i$.next();
            this.remove(k);
        }
        return this;
    }

    public FrequencyMap shift(int shift) {
        HashSet keys = new HashSet();
        keys.addAll(this.keySet());
        Iterator i$ = keys.iterator();
        while (i$.hasNext()) {
            int k = (Integer)i$.next();
            int val = (Integer)this.get(k);
            this.put(k + shift, val);
            this.put(k, 0);
        }
        return this;
    }

    public FrequencyMap bin(int size) {
        HashSet keys = new HashSet();
        keys.addAll(this.keySet());
        Iterator i$ = keys.iterator();
        while (i$.hasNext()) {
            int k = (Integer)i$.next();
            int val = (Integer)this.get(k);
            if (k % size == 0) continue;
            this.put(k / size * size, (Integer)this.get(k / size * size) + val);
            this.put(k, 0);
        }
        return this;
    }

    public FrequencyMap removeAbove(int max) {
        int k;
        HashSet<Integer> toRemove = new HashSet<Integer>();
        Iterator<Object> i$ = this.keySet().iterator();
        while (i$.hasNext()) {
            k = (Integer)i$.next();
            if ((Integer)this.get(k) <= max) continue;
            toRemove.add(k);
        }
        i$ = toRemove.iterator();
        while (i$.hasNext()) {
            k = (Integer)i$.next();
            this.remove(k);
        }
        return this;
    }

    public FrequencyMap truncate(int lower, int upper) {
        int k;
        HashSet<Integer> toRemove = new HashSet<Integer>();
        Iterator<Object> i$ = this.keySet().iterator();
        while (i$.hasNext()) {
            k = (Integer)i$.next();
            if (k >= lower && k <= upper) continue;
            toRemove.add(k);
        }
        i$ = toRemove.iterator();
        while (i$.hasNext()) {
            k = (Integer)i$.next();
            this.remove(k);
        }
        return this;
    }

    public FrequencyMap copy() {
        FrequencyMap out = new FrequencyMap();
        Iterator i$ = this.keySet().iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            out.put(i, this.get(i));
        }
        return out;
    }
}

