/*
 * Decompiled with CFR 0.152.
 */
package be.abeel.gui;

import be.abeel.gui.GridBagPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class MultiFileBean
extends GridBagPanel {
    private static final long serialVersionUID = -1341965704591306937L;
    private DefaultListModel listModel;
    private JFileChooser chooser = new JFileChooser("Choose datafiles");

    public File[] getFiles() {
        File[] out = new File[this.listModel.getSize()];
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            out[i] = (File)this.listModel.getElementAt(i);
        }
        return out;
    }

    public void addFilter(FileFilter f) {
        this.chooser.addChoosableFileFilter(f);
    }

    public MultiFileBean() {
        this.chooser.setMultiSelectionEnabled(true);
        final MultiFileBean _self = this;
        this.setBorder(BorderFactory.createTitledBorder("Input data parameters"));
        this.setLayout(new GridBagLayout());
        final JList list = new JList(new DefaultListModel());
        list.setSelectionMode(2);
        this.listModel = (DefaultListModel)list.getModel();
        JButton fileButton = new JButton("Add files...");
        fileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                int returnVal = MultiFileBean.this.chooser.showOpenDialog(SwingUtilities.getWindowAncestor(_self));
                if (returnVal == 0) {
                    File[] tmp;
                    for (File f : tmp = MultiFileBean.this.chooser.getSelectedFiles()) {
                        MultiFileBean.this.listModel.addElement(f);
                    }
                }
            }
        });
        JButton removeButton = new JButton("Remove selected...");
        removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                Object[] tmp;
                for (Object o : tmp = list.getSelectedValues()) {
                    MultiFileBean.this.listModel.removeElement(o);
                }
            }
        });
        JButton clearButton = new JButton("Clear all");
        clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                MultiFileBean.this.listModel.clear();
            }
        });
        JLabel dataLabel = new JLabel("Datafile(s)");
        dataLabel.setVerticalAlignment(1);
        this.add((Component)dataLabel, this.gc);
        ++this.gc.gridx;
        this.gc.gridheight = 3;
        JScrollPane listPane = new JScrollPane(list);
        listPane.setPreferredSize(new Dimension(600, 100));
        this.add((Component)listPane, this.gc);
        this.gc.gridheight = 1;
        ++this.gc.gridx;
        this.add((Component)fileButton, this.gc);
        ++this.gc.gridy;
        this.add((Component)removeButton, this.gc);
        ++this.gc.gridy;
        this.add((Component)clearButton, this.gc);
    }
}

