/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure.support;

import com.bc.ceres.swing.figure.AbstractHandle;
import com.bc.ceres.swing.figure.FigureStyle;
import com.bc.ceres.swing.figure.PointFigure;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;

public class PointHandle
extends AbstractHandle {
    public PointHandle(PointFigure figure, FigureStyle handleStyle) {
        this(figure, handleStyle, PointHandle.createHandleShape(handleStyle));
    }

    public PointHandle(PointFigure figure, FigureStyle handleStyle, Shape shape) {
        super(figure, handleStyle, handleStyle);
        this.updateLocation();
        this.setShape(shape);
    }

    @Override
    public PointFigure getFigure() {
        return (PointFigure)super.getFigure();
    }

    @Override
    public void updateLocation() {
        this.setLocation(this.getFigure().getLocation());
    }

    @Override
    public void move(double dx, double dy) {
        this.setLocation(this.getX() + dx, this.getY() + dy);
        this.getFigure().setLocation(this.getLocation());
    }

    private static Shape createHandleShape(FigureStyle handleStyle) {
        double size = 12.0;
        Object sizeObj = handleStyle.getValue("size");
        if (sizeObj instanceof Number) {
            size = ((Number)sizeObj).doubleValue();
        }
        return new Ellipse2D.Double(-0.5 * size, -0.5 * size, size, size);
    }
}

