/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.runtime;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.esa.snap.runtime.Engine;

public class Launcher {
    public static final String PROPERTY_MAIN_CLASS_NAME = "snap.mainClass";

    public static void main(String[] args) {
        try {
            Launcher launcher = new Launcher();
            launcher.run(args);
        }
        catch (Throwable e) {
            System.err.println("Error: " + e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public void run(String[] args) {
        String mainClassName = System.getProperty(PROPERTY_MAIN_CLASS_NAME);
        if (mainClassName == null) {
            throw new RuntimeException(String.format("Missing system property '%s'", PROPERTY_MAIN_CLASS_NAME));
        }
        Engine.start().runClientCode(() -> {
            try {
                Class<?> mainClass = Engine.getInstance().getClientClassLoader().loadClass(mainClassName);
                Method mainMethod = mainClass.getMethod("main", String[].class);
                mainMethod.invoke(null, new Object[]{args});
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }).stop();
    }
}

