/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.product;

import com.bc.ceres.swing.TableLayout;
import com.jidesoft.swing.CheckBoxList;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.ui.ModalDialog;

class ProductChooser
extends ModalDialog {
    private final CheckBoxList productsList;
    private final JCheckBox selectAll;
    private final JCheckBox selectNone;

    ProductChooser(Window parent, String title, int buttonMask, String helpID, Product[] products) {
        super(parent, title, buttonMask, helpID);
        TableLayout layout = new TableLayout(1);
        layout.setTableFill(TableLayout.Fill.BOTH);
        layout.setRowWeightY(0, Double.valueOf(1.0));
        layout.setRowWeightY(1, Double.valueOf(0.0));
        layout.setTableWeightX(Double.valueOf(1.0));
        JPanel panel = new JPanel((LayoutManager)layout);
        ProductListModel listModel = new ProductListModel();
        this.selectAll = new JCheckBox("Select all");
        this.selectNone = new JCheckBox("Select none", true);
        this.selectNone.setEnabled(false);
        this.productsList = new CheckBoxList((ListModel)listModel);
        this.productsList.setCellRenderer((ListCellRenderer)new ProductListCellRenderer());
        this.productsList.getCheckBoxListSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int length = ProductChooser.this.productsList.getCheckBoxListSelectedIndices().length;
                if (length == 0) {
                    ProductChooser.this.selectNone.setSelected(true);
                    ProductChooser.this.selectAll.setSelected(false);
                } else if (length == ProductChooser.this.productsList.getModel().getSize()) {
                    ProductChooser.this.selectAll.setSelected(true);
                    ProductChooser.this.selectNone.setSelected(false);
                } else {
                    ProductChooser.this.selectAll.setSelected(false);
                    ProductChooser.this.selectNone.setSelected(false);
                }
                ProductChooser.this.selectAll.setEnabled(!ProductChooser.this.selectAll.isSelected());
                ProductChooser.this.selectNone.setEnabled(!ProductChooser.this.selectNone.isSelected());
            }
        });
        for (Product product : products) {
            listModel.addElement(product);
        }
        panel.add(new JScrollPane((Component)this.productsList));
        panel.add(this.createButtonsPanel());
        this.setContent(panel);
    }

    List<Product> getSelectedProducts() {
        ArrayList<Product> selectedProducts = new ArrayList<Product>();
        for (int i = 0; i < this.productsList.getModel().getSize(); ++i) {
            if (!this.productsList.getCheckBoxListSelectionModel().isSelectedIndex(i)) continue;
            selectedProducts.add((Product)this.productsList.getModel().getElementAt(i));
        }
        return selectedProducts;
    }

    private JPanel createButtonsPanel() {
        JPanel buttonsPanel = new JPanel(new FlowLayout(0));
        this.selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductChooser.this.selectNone.setSelected(false);
                ProductChooser.this.selectAll.setEnabled(false);
                ProductChooser.this.selectNone.setEnabled(true);
                ProductChooser.this.productsList.getCheckBoxListSelectionModel().setSelectionInterval(0, ProductChooser.this.productsList.getModel().getSize() - 1);
            }
        });
        this.selectNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductChooser.this.selectAll.setSelected(false);
                ProductChooser.this.selectAll.setEnabled(true);
                ProductChooser.this.selectNone.setEnabled(false);
                ProductChooser.this.productsList.getCheckBoxListSelectionModel().clearSelection();
            }
        });
        this.selectAll.setMnemonic('a');
        this.selectNone.setMnemonic('n');
        buttonsPanel.add(this.selectAll);
        buttonsPanel.add(this.selectNone);
        return buttonsPanel;
    }

    private static class ProductListModel
    extends DefaultListModel<Product> {
        private ProductListModel() {
        }

        @Override
        public void addElement(Product product) {
            boolean alreadyContained = false;
            for (int i = 0; i < this.getSize(); ++i) {
                String currentProductName = ((Product)this.get(i)).getName();
                String newProductName = product.getName();
                alreadyContained |= currentProductName.equals(newProductName);
            }
            if (!alreadyContained) {
                super.addElement(product);
            }
        }
    }

    private static class ProductListCellRenderer
    implements ListCellRenderer<Product> {
        private DefaultListCellRenderer delegate = new DefaultListCellRenderer();

        private ProductListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Product value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)this.delegate.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            label.setText(value.getDisplayName());
            return label;
        }
    }
}

