/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.ral.nujan.hdf;

import edu.ucar.ral.nujan.hdf.HBuffer;
import edu.ucar.ral.nujan.hdf.HdfException;
import edu.ucar.ral.nujan.hdf.HdfFileWriter;
import edu.ucar.ral.nujan.hdf.HdfGroup;
import edu.ucar.ral.nujan.hdf.MsgBase;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;

class MsgModTime
extends MsgBase {
    final int version = 1;
    int utcModTimeSec;

    MsgModTime(long utcModTimeMilliSec, HdfGroup hdfGroup, HdfFileWriter hdfFile) {
        super(18, hdfGroup, hdfFile);
        this.utcModTimeSec = (int)(utcModTimeMilliSec / 1000L);
    }

    @Override
    public String toString() {
        String res = super.toString();
        res = res + "  utcModTimeSec: " + this.utcModTimeSec;
        Date dt = new Date(this.utcModTimeSec * 1000);
        SimpleDateFormat utcFmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        utcFmt.setTimeZone(new SimpleTimeZone(0, "UTC"));
        res = res + "  " + utcFmt.format(dt);
        return res;
    }

    @Override
    void formatMsgCore(int formatPass, HBuffer fmtBuf) throws HdfException {
        fmtBuf.putBufByte("MsgModTime: version", 1);
        fmtBuf.putBufByte("MsgModTime: reserved", 0);
        fmtBuf.putBufShort("MsgModTime: reserved", 0);
        fmtBuf.putBufInt("MsgModTime: utcModTimeSec", this.utcModTimeSec);
    }
}

