/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.ral.nujan.hdf;

import edu.ucar.ral.nujan.hdf.HdfException;
import edu.ucar.ral.nujan.hdf.HdfGroup;
import edu.ucar.ral.nujan.hdf.HdfModInt;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.regex.Pattern;

public class HdfUtil {
    static long alignLong(long bound, long val) {
        if (val % bound != 0L) {
            val += bound - val % bound;
        }
        return val;
    }

    static int[] getDimLen(Object obj, boolean isVlen) throws HdfException {
        HdfModInt eleType = new HdfModInt(0);
        ArrayList<Integer> dimList = new ArrayList<Integer>();
        HdfModInt totNumEle = new HdfModInt(0);
        HdfModInt elementLen = new HdfModInt(0);
        int curDim = 0;
        HdfUtil.getDimLenSub(obj, isVlen, curDim, eleType, totNumEle, elementLen, dimList);
        int[] res = new int[3 + dimList.size()];
        res[0] = eleType.getValue();
        res[1] = totNumEle.getValue();
        res[2] = elementLen.getValue();
        for (int ii = 0; ii < dimList.size(); ++ii) {
            res[3 + ii] = dimList.get(ii);
        }
        return res;
    }

    static void getDimLenSub(Object obj, boolean isVlen, int curDim, HdfModInt eleType, HdfModInt totNumEle, HdfModInt elementLen, ArrayList<Integer> dimList) throws HdfException {
        Object[] vals;
        int dtype = -1;
        int dimLen = -1;
        int deltaNum = 0;
        if (obj instanceof byte[]) {
            vals = (byte[])obj;
            dtype = 2;
            elementLen.setValue(1);
            dimLen = vals.length;
            deltaNum = vals.length;
        } else if (obj instanceof Byte) {
            dtype = 2;
            elementLen.setValue(1);
            dimLen = -1;
            deltaNum = 1;
        } else if (obj instanceof short[]) {
            vals = (short[])obj;
            elementLen.setValue(2);
            dtype = 3;
            dimLen = vals.length;
            deltaNum = vals.length;
        } else if (obj instanceof Short) {
            dtype = 3;
            elementLen.setValue(2);
            dimLen = -1;
            deltaNum = 1;
        } else if (obj instanceof int[]) {
            vals = (int[])obj;
            dtype = 4;
            elementLen.setValue(4);
            dimLen = vals.length;
            deltaNum = vals.length;
        } else if (obj instanceof Integer) {
            dtype = 4;
            elementLen.setValue(4);
            dimLen = -1;
            deltaNum = 1;
        } else if (obj instanceof long[]) {
            vals = (long[])obj;
            dtype = 5;
            elementLen.setValue(8);
            dimLen = vals.length;
            deltaNum = vals.length;
        } else if (obj instanceof Long) {
            dtype = 5;
            elementLen.setValue(8);
            dimLen = -1;
            deltaNum = 1;
        } else if (obj instanceof float[]) {
            vals = (float[])obj;
            dtype = 6;
            elementLen.setValue(4);
            dimLen = vals.length;
            deltaNum = vals.length;
        } else if (obj instanceof Float) {
            dtype = 6;
            elementLen.setValue(4);
            dimLen = -1;
            deltaNum = 1;
        } else if (obj instanceof double[]) {
            vals = (double[])obj;
            dtype = 7;
            elementLen.setValue(8);
            dimLen = vals.length;
            deltaNum = vals.length;
        } else if (obj instanceof Double) {
            dtype = 7;
            elementLen.setValue(4);
            dimLen = -1;
            deltaNum = 1;
        } else if (obj instanceof char[]) {
            vals = (char[])obj;
            dtype = 9;
            elementLen.setValue(Math.max(elementLen.getValue(), vals.length));
            dimLen = vals.length;
            deltaNum = vals.length;
        } else if (obj instanceof Character) {
            dtype = 9;
            elementLen.setValue(1);
            dimLen = -1;
            deltaNum = 1;
        } else if (obj instanceof String[]) {
            vals = (String[])obj;
            dtype = 10;
            for (byte val : vals) {
                elementLen.setValue(Math.max(elementLen.getValue(), val.length()));
            }
            dimLen = vals.length;
            deltaNum = vals.length;
        } else if (obj instanceof String) {
            String val = (String)obj;
            dtype = 10;
            elementLen.setValue(Math.max(elementLen.getValue(), val.length()));
            dimLen = -1;
            deltaNum = 1;
        } else if (obj instanceof HdfGroup[]) {
            vals = (HdfGroup[])obj;
            dtype = 11;
            elementLen.setValue(8);
            dimLen = vals.length;
            deltaNum = vals.length;
        } else if (obj instanceof HdfGroup) {
            dtype = 11;
            elementLen.setValue(8);
            dimLen = -1;
            deltaNum = 1;
        } else if (obj instanceof Object[]) {
            vals = (Object[])obj;
            dimLen = vals.length;
        }
        if (dtype > 0) {
            if (eleType.getValue() <= 0) {
                eleType.setValue(dtype);
            } else if (dtype != eleType.getValue()) {
                HdfUtil.throwerr("internal type mismatch", new Object[0]);
            }
        }
        if (curDim > dimList.size()) {
            HdfUtil.throwerr("invalid curDim", new Object[0]);
        } else if (curDim == dimList.size()) {
            if (dimLen > 0) {
                dimList.add(new Integer(dimLen));
            }
        } else if (dimLen != dimList.get(curDim) && !isVlen) {
            HdfUtil.throwerr("dimension mismatch", new Object[0]);
        }
        totNumEle.setValue(totNumEle.getValue() + deltaNum);
        if (obj instanceof Object[]) {
            Object[] objs;
            for (Object subObj : objs = (Object[])obj) {
                HdfUtil.getDimLenSub(subObj, isVlen, curDim + 1, eleType, totNumEle, elementLen, dimList);
            }
        }
    }

    static void checkTypeMatch(String msg, int specType, int dataType, boolean useLinear, int[] varDims, int[] startIxs, int[] chunkDims, int[] dataDims) throws HdfException {
        if (specType == 9 || specType == 10) {
            if (dataType != 9 && dataType != 10) {
                HdfUtil.throwerr("type mismatch for: " + msg + "\n" + "  declared type: " + HdfGroup.dtypeNames[specType] + "\n" + "  data type:     " + HdfGroup.dtypeNames[dataType] + "\n", new Object[0]);
            }
        } else if (specType == 1 || specType == 2) {
            if (dataType != 2) {
                HdfUtil.throwerr("type mismatch for: " + msg + "\n" + "  declared type: " + HdfGroup.dtypeNames[specType] + "\n" + "  data type:     " + HdfGroup.dtypeNames[dataType] + "\n", new Object[0]);
            }
        } else if (specType == 13 || specType == 11) {
            if (dataType != 11) {
                HdfUtil.throwerr("type mismatch for: " + msg + "\n" + "  declared type: " + HdfGroup.dtypeNames[specType] + "\n" + "  data type:     " + HdfGroup.dtypeNames[dataType] + "\n", new Object[0]);
            }
        } else if (dataType != specType) {
            HdfUtil.throwerr("type mismatch for: " + msg + "\n" + "  declared type: " + HdfGroup.dtypeNames[specType] + "\n" + "  data type:     " + HdfGroup.dtypeNames[dataType] + "\n", new Object[0]);
        }
        if (varDims.length == 0) {
            if (dataDims.length != 0) {
                HdfUtil.throwerr("type mismatch for: " + msg + "\n" + "  declared rank: (null)\n" + "  data rank:     " + dataDims.length + "\n", new Object[0]);
            }
        } else if (useLinear) {
            if (dataDims.length != 1) {
                HdfUtil.throwerr("useLinear but dataDims rank != 1", new Object[0]);
            }
            int dlen = dataDims[0];
            long fullChunkVolume = 0L;
            long remVolume = 0L;
            if (varDims.length > 0) {
                fullChunkVolume = 1L;
                remVolume = 1L;
                for (int ii = 0; ii < varDims.length; ++ii) {
                    int remLen = chunkDims[ii];
                    if (startIxs[ii] + chunkDims[ii] >= varDims[ii]) {
                        remLen = varDims[ii] - startIxs[ii];
                    }
                    fullChunkVolume *= (long)chunkDims[ii];
                    remVolume *= (long)remLen;
                }
            }
            if ((long)dlen != fullChunkVolume && (long)dlen != remVolume) {
                HdfUtil.throwerr("bad chunk size with useLinear.\n  declared variable lens: " + HdfUtil.formatInts(varDims) + "\n" + "  declared chunk lens:    " + HdfUtil.formatInts(chunkDims) + "\n" + "  remVolume:              " + remVolume + "\n" + "  current startIxs:       " + HdfUtil.formatInts(startIxs) + "\n" + "  data object dim lens:   " + HdfUtil.formatInts(dataDims) + "\n", new Object[0]);
            }
        } else {
            if (dataDims.length != chunkDims.length) {
                HdfUtil.throwerr("Dimension mismatch for: " + msg + "\n" + "  declared variable lens: " + HdfUtil.formatInts(varDims) + "\n" + "  declared chunk lens:    " + HdfUtil.formatInts(chunkDims) + "\n" + "  current startIxs:       " + HdfUtil.formatInts(startIxs) + "\n" + "  data object dim lens:   " + HdfUtil.formatInts(dataDims) + "\n", new Object[0]);
            }
            for (int ii = 0; ii < chunkDims.length; ++ii) {
                int remLen;
                boolean allOk = false;
                if (dataDims[ii] == chunkDims[ii]) {
                    allOk = true;
                } else if (startIxs[ii] + chunkDims[ii] >= varDims[ii] && dataDims[ii] == (remLen = varDims[ii] - startIxs[ii])) {
                    allOk = true;
                }
                if (allOk) continue;
                HdfUtil.throwerr("Dimension mismatch for: " + msg + "\n" + "  data dimension length mismatch for dimension " + ii + "\n" + "  declared variable lens: " + HdfUtil.formatInts(varDims) + "\n" + "  declared chunk lens:    " + HdfUtil.formatInts(chunkDims) + "\n" + "  current startIxs:       " + HdfUtil.formatInts(startIxs) + "\n" + "  data object dim lens:   " + HdfUtil.formatInts(dataDims) + "\n", new Object[0]);
            }
        }
    }

    static void checkName(String name, String loc) throws HdfException {
        if (name == null || name.length() == 0) {
            HdfUtil.throwerr("Name for %s is empty", loc);
        }
        if (!Pattern.matches("^[_a-zA-Z][-_: a-zA-Z0-9]*$", name)) {
            HdfUtil.throwerr("Invalid name for %s.  Name: \"%s\"", loc, name);
        }
    }

    static int getMaxStgLen(Object obj) throws HdfException {
        int maxStgLen = 0;
        if (obj instanceof String) {
            maxStgLen = ((String)obj).length();
        } else if (obj instanceof char[]) {
            maxStgLen = Math.max(maxStgLen, ((char[])obj).length);
        } else if (obj instanceof Object[]) {
            Object[] objVec = (Object[])obj;
            for (int ii = 0; ii < objVec.length; ++ii) {
                maxStgLen = Math.max(maxStgLen, HdfUtil.getMaxStgLen(objVec[ii]));
            }
        }
        return maxStgLen;
    }

    static byte[] encodeString(String stg, boolean addNullTerm, HdfGroup group) throws HdfException {
        Charset charset = Charset.forName("US-ASCII");
        byte[] bytes = stg.getBytes(charset);
        if (addNullTerm) {
            bytes = Arrays.copyOf(bytes, bytes.length + 1);
            bytes[bytes.length - 1] = 0;
        }
        return bytes;
    }

    public static long parseUtcTime(String stg) throws HdfException {
        long utcTime = 0L;
        if (stg.equals("0")) {
            utcTime = 0L;
        } else {
            SimpleDateFormat utcSdf = null;
            if (stg.length() == 10) {
                utcSdf = new SimpleDateFormat("yyyy-MM-dd");
            } else if (stg.length() == 19) {
                utcSdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            } else {
                HdfUtil.throwerr("invalid -utcModTime: \"" + stg + "\"", new Object[0]);
            }
            utcSdf.setTimeZone(new SimpleTimeZone(0, "UTC"));
            Date dt = null;
            try {
                dt = utcSdf.parse(stg);
            }
            catch (ParseException exc) {
                HdfUtil.throwerr("invalid -utcModTime: \"" + stg + "\"", new Object[0]);
            }
            utcTime = dt.getTime();
        }
        return utcTime;
    }

    public static String formatUtcTime(long tval) {
        SimpleDateFormat utcSdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        utcSdf.setTimeZone(new SimpleTimeZone(0, "UTC"));
        String stg = utcSdf.format(tval);
        return stg;
    }

    static byte[] truncPadNull(byte[] bytes, int fieldLen) throws HdfException {
        byte[] res = Arrays.copyOf(bytes, fieldLen);
        return res;
    }

    static String formatBytes(byte[] bytes, int istart, int iend) {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("hex:");
        for (int ii = istart; ii < iend; ++ii) {
            sbuf.append(" ");
            String stg = Integer.toHexString(bytes[ii] & 0xFF);
            if (stg.length() == 1) {
                sbuf.append("0");
            }
            sbuf.append(stg);
        }
        return sbuf.toString();
    }

    static String formatDtypeDim(int dtype, int[] dims) {
        String res = HdfGroup.dtypeNames[dtype];
        if (dims == null) {
            res = res + " (dims==null)";
        } else if (dims.length == 0) {
            res = res + " scalar";
        } else {
            res = res + " [";
            for (int ii = 0; ii < dims.length; ++ii) {
                if (ii > 0) {
                    res = res + ",";
                }
                res = res + "" + dims[ii];
            }
            res = res + "]";
        }
        return res;
    }

    public static String formatObject(Object obj) {
        StringBuilder sbuf = new StringBuilder();
        if (obj == null) {
            sbuf.append("  (null)");
        } else {
            sbuf.append("  cls: " + obj.getClass().getName() + "\n");
            HdfUtil.formatObjectSub(obj, 2, sbuf);
        }
        return sbuf.toString();
    }

    static void formatObjectSub(Object obj, int indent, StringBuilder sbuf) {
        if (obj == null) {
            sbuf.append(String.format("%s(null)\n", HdfUtil.mkIndent(indent)));
        } else if (obj instanceof String) {
            sbuf.append(String.format("%s(String) \"%s\"\n", HdfUtil.mkIndent(indent), obj));
        } else if (obj instanceof byte[]) {
            sbuf.append(HdfUtil.mkIndent(indent) + "(bytes)");
            byte[] vals = (byte[])obj;
            for (int ii = 0; ii < vals.length; ++ii) {
                sbuf.append("  " + vals[ii]);
            }
            sbuf.append("\n");
        } else if (obj instanceof short[]) {
            sbuf.append(HdfUtil.mkIndent(indent) + "(shorts)");
            short[] vals = (short[])obj;
            for (int ii = 0; ii < vals.length; ++ii) {
                sbuf.append("  " + vals[ii]);
            }
            sbuf.append("\n");
        } else if (obj instanceof int[]) {
            sbuf.append(HdfUtil.mkIndent(indent) + "(ints)");
            int[] vals = (int[])obj;
            for (int ii = 0; ii < vals.length; ++ii) {
                sbuf.append("  " + vals[ii]);
            }
            sbuf.append("\n");
        } else if (obj instanceof long[]) {
            sbuf.append(HdfUtil.mkIndent(indent) + "(longs)");
            long[] vals = (long[])obj;
            for (int ii = 0; ii < vals.length; ++ii) {
                sbuf.append("  " + vals[ii]);
            }
            sbuf.append("\n");
        } else if (obj instanceof float[]) {
            sbuf.append(HdfUtil.mkIndent(indent) + "(floats)");
            float[] vals = (float[])obj;
            for (int ii = 0; ii < vals.length; ++ii) {
                sbuf.append("  " + vals[ii]);
            }
            sbuf.append("\n");
        } else if (obj instanceof double[]) {
            sbuf.append(HdfUtil.mkIndent(indent) + "(doubles)");
            double[] vals = (double[])obj;
            for (int ii = 0; ii < vals.length; ++ii) {
                sbuf.append("  " + vals[ii]);
            }
            sbuf.append("\n");
        } else if (obj instanceof char[]) {
            sbuf.append(HdfUtil.mkIndent(indent) + "(chars)");
            char[] vals = (char[])obj;
            for (int ii = 0; ii < vals.length; ++ii) {
                sbuf.append("  " + vals[ii]);
            }
            sbuf.append("\n");
        } else if (obj instanceof Object[]) {
            Object[] vals = (Object[])obj;
            for (int ii = 0; ii < vals.length; ++ii) {
                sbuf.append(String.format("%s%d  cls: %s:\n", HdfUtil.mkIndent(indent), ii, vals[ii].getClass().getName()));
                HdfUtil.formatObjectSub(vals[ii], indent + 1, sbuf);
            }
        } else {
            sbuf.append(String.format("%s(%s) %s\n", HdfUtil.mkIndent(indent), obj.getClass().getName(), obj));
        }
    }

    public static String formatInts(int[] vals) {
        String res = "";
        if (vals == null) {
            res = "(null)";
        } else {
            res = "[";
            for (int ii = 0; ii < vals.length; ++ii) {
                if (ii > 0) {
                    res = res + " ";
                }
                res = res + vals[ii];
            }
            res = res + "]";
        }
        return res;
    }

    static String mkIndent(int indent) {
        String res = "";
        for (int ii = 0; ii < indent; ++ii) {
            res = res + "  ";
        }
        return res;
    }

    static void throwerr(String msg, Object ... args) throws HdfException {
        throw new HdfException(String.format(msg, args));
    }

    static void prtf(String msg, Object ... args) {
        System.out.printf(msg + "\n", args);
    }
}

