/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.ral.nujan.hdf;

import edu.ucar.ral.nujan.hdf.BaseBlk;
import edu.ucar.ral.nujan.hdf.CheckSumHack;
import edu.ucar.ral.nujan.hdf.GlobalHeap;
import edu.ucar.ral.nujan.hdf.HBuffer;
import edu.ucar.ral.nujan.hdf.HdfChunk;
import edu.ucar.ral.nujan.hdf.HdfException;
import edu.ucar.ral.nujan.hdf.HdfGroup;
import edu.ucar.ral.nujan.hdf.HdfUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.SimpleTimeZone;

public class HdfFileWriter
extends BaseBlk {
    static String softwareVersion = "0.9.2";
    public static final int OPT_ALLOW_OVERWRITE = 1;
    static final int OFFSET_SIZE = 8;
    static final int UNDEFINED_ADDR = -1;
    static final int ST_DEFINING = 1;
    static final int ST_WRITEDATA = 2;
    static final int ST_CLOSED = 3;
    static final String[] statusNames = new String[]{"UNKNOWN", "DEFINING", "WRITEDATA", "CLOSED"};
    HdfGroup extensionGroup;
    HdfGroup rootGroup;
    GlobalHeap mainGlobalHeap = null;
    String filePath;
    int optFlag;
    int fileStatus;
    long utcModTimeMilliSec;
    long utcModTimeSec;
    int maxNumBtreeKid = 100;
    int indent = 0;
    int debugLevel = 0;
    int bugs = 0;
    String logDir;
    String statTag;
    private HBuffer mainBuf;
    FileOutputStream outStream;
    FileChannel outChannel;
    ArrayList<BaseBlk> workList = null;
    final int signa = 137;
    final int signb = 72;
    final int signc = 68;
    final int signd = 70;
    final int signe = 13;
    final int signf = 10;
    final int signg = 26;
    final int signh = 10;
    final int consistencyFlag = 0;
    final long baseAddress = 0L;
    long eofAddr;
    PrintWriter statOut;
    long statTimea;
    long statTimeOverall;

    public HdfFileWriter(String filePath, int optFlag) throws HdfException {
        this(filePath, optFlag, 0, 0L, null, null);
    }

    public HdfFileWriter(String filePath, int optFlag, String logDir, String statTag) throws HdfException {
        this(filePath, optFlag, 0, 0L, logDir, statTag);
    }

    public HdfFileWriter(String filePath, int optFlag, int debugLevel, long utcModTime, String logDir, String statTag) throws HdfException {
        super("HdfFileWriter", null);
        this.hdfFile = this;
        this.filePath = filePath;
        this.optFlag = optFlag;
        this.debugLevel = debugLevel;
        this.bugs = debugLevel;
        this.logDir = logDir;
        this.statTag = statTag;
        if (this.bugs >= 1) {
            HdfFileWriter.prtf("HdfFileWriter.const: filePath: \"%s\"\n  softwareVersion: %s", filePath, HdfFileWriter.getSoftwareVersion());
        }
        this.initStat();
        this.statTimeOverall = this.statTimea = this.printStat(0L, "wtr.const.entry", "filePath: " + filePath);
        this.fileStatus = 1;
        this.utcModTimeMilliSec = utcModTime;
        if (this.utcModTimeMilliSec == 0L) {
            this.utcModTimeMilliSec = System.currentTimeMillis();
        }
        this.utcModTimeSec = this.utcModTimeMilliSec / 1000L;
        this.indent = 0;
        this.extensionGroup = new HdfGroup(this);
        String rootName = "";
        this.rootGroup = new HdfGroup(rootName, null, this);
        try {
            if ((optFlag & 1) == 0 && new File(filePath).exists()) {
                HdfFileWriter.throwerr("file \"%s\" already exists", filePath);
            }
            this.outStream = new FileOutputStream(filePath);
        }
        catch (IOException exc) {
            exc.printStackTrace();
            HdfFileWriter.throwerr("caught: %s", exc);
        }
        this.outChannel = this.outStream.getChannel();
    }

    @Override
    public String toString() {
        String res = "  filePath: \"" + this.filePath + "\"" + "  status: " + statusNames[this.fileStatus] + "  softwareVersion: " + HdfFileWriter.getSoftwareVersion();
        return res;
    }

    public static String getSoftwareVersion() {
        return softwareVersion;
    }

    public HdfGroup getRootGroup() {
        return this.rootGroup;
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public void setDebugLevel(int debugLevel) {
        this.debugLevel = debugLevel;
        this.bugs = debugLevel;
    }

    public void endDefine() throws HdfException {
        if (this.bugs >= 1) {
            HdfFileWriter.prtf("HdfFileWriter.endDefine: filePath: \"" + this.filePath + "\"\n", new Object[0]);
        }
        this.statTimea = this.printStat(this.statTimea, "wtr.endDefine.entry", "filePath: " + this.filePath);
        if (this.fileStatus != 1) {
            HdfFileWriter.throwerr("already called endDefine", new Object[0]);
        }
        this.fileStatus = 2;
        this.mainGlobalHeap = new GlobalHeap(this);
        this.mainBuf = new HBuffer(null, 0, this);
        if (this.bugs >= 2) {
            HdfFileWriter.prtf("\nHdfFileWriter.endDefine: start pass 1: mainBuf pos: %d", this.mainBuf.getPos());
        }
        this.formatBufAll(1);
        this.bugs = this.debugLevel;
        if (this.bugs >= 2) {
            HdfFileWriter.prtf("HdfFileWriter.endDefine: after pass 1: mainBuf pos: %d", this.mainBuf.getPos());
        }
        this.eofAddr = this.mainBuf.getPos();
        this.statTimea = this.printStat(this.statTimea, "wtr.endDefine.exit", "filePath: " + this.filePath);
    }

    public void close() throws HdfException {
        if (this.bugs >= 1) {
            HdfFileWriter.prtf("HdfFileWriter.close: filePath: \"" + this.filePath + "\"\n", new Object[0]);
        }
        this.statTimea = this.printStat(this.statTimea, "wtr.close.entry", "filePath: " + this.filePath);
        if (this.fileStatus == 1) {
            HdfFileWriter.throwerr("must call endDefine before calling close", new Object[0]);
        } else if (this.fileStatus == 3) {
            HdfFileWriter.throwerr("file is already closed", new Object[0]);
        } else if (this.fileStatus != 2) {
            HdfFileWriter.throwerr("invalid fileStatus", new Object[0]);
        }
        this.fileStatus = 3;
        ArrayList<HdfGroup> grpList = new ArrayList<HdfGroup>();
        this.findAllGroups(this.rootGroup, grpList);
        String errMsg = "";
        for (HdfGroup grp : grpList) {
            if (!grp.isVariable || grp.msgDataSpace.totNumEle == 0L) continue;
            for (HdfChunk chunk : grp.hdfChunks) {
                if (chunk.chunkDataAddr != 0L) continue;
                errMsg = errMsg + "  " + grp.getPath() + "  chunk indices: " + HdfUtil.formatInts(chunk.chunkStartIxs) + "\n";
            }
        }
        if (errMsg.length() > 0) {
            HdfFileWriter.throwerr("close: the following dataset chunks still need to written:\n%s", errMsg);
        }
        if (this.bugs >= 2) {
            HdfFileWriter.prtf("\nHdfFileWriter.close: start pass 2: mainBuf pos: %d", this.mainBuf.getPos());
        }
        this.mainGlobalHeap.clear();
        this.mainBuf.clear();
        this.formatBufAll(2);
        if (this.bugs >= 2) {
            HdfFileWriter.prtf("HdfFileWriter.close: after pass 2: mainBuf pos: %d", this.mainBuf.getPos());
        }
        try {
            this.outChannel.position(0L);
            this.mainBuf.writeChannel(this.outChannel);
            this.outChannel.close();
            this.outStream.close();
        }
        catch (IOException exc) {
            exc.printStackTrace();
            HdfFileWriter.throwerr("caught: %s", exc);
        }
        this.statTimea = this.printStat(this.statTimea, "wtr.close.exit.a", "filePath: " + this.filePath);
        this.statTimeOverall = this.printStat(this.statTimeOverall, "wtr.close.exit.overall", "filePath: " + this.filePath);
        this.closeStat();
    }

    void findAllGroups(HdfGroup grp, ArrayList<HdfGroup> groupList) {
        groupList.add(grp);
        if (grp.subGroupList != null) {
            for (HdfGroup subGrp : grp.subGroupList) {
                this.findAllGroups(subGrp, groupList);
            }
        }
        if (grp.subVariableList != null) {
            for (HdfGroup subGrp : grp.subVariableList) {
                this.findAllGroups(subGrp, groupList);
            }
        }
    }

    void formatBufAll(int formatPass) throws HdfException {
        if (this.bugs >= 2) {
            HdfFileWriter.prtf("\nHdfFileWriter.formatBufAll: entry. formatPass: %d  mainBuf pos: 0x%x", formatPass, this.mainBuf.getPos());
        }
        HBuffer fmtBuf = this.mainBuf;
        this.workList = new ArrayList();
        this.addWork("HdfFileWriter", this);
        while (this.workList.size() > 0) {
            BaseBlk blk = this.workList.remove(0);
            if (this.bugs >= 5) {
                HdfFileWriter.prtf("\nHdfFileWriter.formatBufAll pop: %s  pos 0x%x  new list len: %d", blk.blkName, blk.blkPosition, this.workList.size());
            }
            blk.formatBuf(formatPass, fmtBuf);
        }
        if (this.bugs >= 2) {
            HdfFileWriter.prtf("\nHdfFileWriter.formatBufAll: format globalHeap.  fmtBuf pos: 0x%x", fmtBuf.getPos());
        }
        this.mainGlobalHeap.formatBuf(formatPass, fmtBuf);
        if (this.bugs >= 2) {
            HdfFileWriter.prtf("\nHdfFileWriter.formatBufAll: exit. formatPass: %d  fmtBuf pos: 0x%x", formatPass, fmtBuf.getPos());
        }
    }

    @Override
    void formatBuf(int formatPass, HBuffer fmtBuf) throws HdfException {
        this.setFormatEntry(formatPass, true, fmtBuf);
        long startPos = fmtBuf.getPos();
        fmtBuf.putBufByte("HdfFileWriter: signa", 137);
        fmtBuf.putBufByte("HdfFileWriter: signb", 72);
        fmtBuf.putBufByte("HdfFileWriter: signc", 68);
        fmtBuf.putBufByte("HdfFileWriter: signd", 70);
        fmtBuf.putBufByte("HdfFileWriter: signe", 13);
        fmtBuf.putBufByte("HdfFileWriter: signf", 10);
        fmtBuf.putBufByte("HdfFileWriter: signg", 26);
        fmtBuf.putBufByte("HdfFileWriter: signh", 10);
        int superBlockVersion = 2;
        fmtBuf.putBufByte("HdfFileWriter: superBlockVersion", superBlockVersion);
        fmtBuf.putBufByte("HdfFileWriter: OFFSET_SIZE", 8);
        fmtBuf.putBufByte("HdfFileWriter: LENGTH_SIZE", 8);
        fmtBuf.putBufByte("HdfFileWriter: consistencyFlag", 0);
        fmtBuf.putBufLong("HdfFileWriter: baseAddress", 0L);
        long extenAddr = -1L;
        if (this.extensionGroup != null) {
            extenAddr = this.extensionGroup.blkPosition;
        }
        fmtBuf.putBufLong("HdfFileWriter: superblockExtensionAddress", extenAddr);
        fmtBuf.putBufLong("HdfFileWriter: eofAddr", this.eofAddr);
        fmtBuf.putBufLong("HdfFileWriter: rootGroupAddr", this.rootGroup.blkPosition);
        long endPos = fmtBuf.getPos();
        byte[] chkBytes = fmtBuf.getBufBytes(startPos, endPos);
        int checkSumHack = new CheckSumHack().calcHackSum(chkBytes);
        fmtBuf.putBufInt("HdfFileWriter: checkSumHack", checkSumHack);
        if (this.extensionGroup != null) {
            this.addWork("HdfFileWriter", this.extensionGroup);
        }
        this.addWork("HdfFileWriter", this.rootGroup);
        this.noteFormatExit(fmtBuf);
    }

    void addWork(String msg, BaseBlk blk) throws HdfException {
        boolean foundIt = false;
        for (BaseBlk wblk : this.workList) {
            if (wblk != blk) continue;
            foundIt = true;
            break;
        }
        if (!foundIt) {
            this.workList.add(blk);
        }
        if (this.bugs >= 5) {
            if (foundIt) {
                this.prtIndent("addWork: %s ignored duplicate addWork.  blk: %s", msg, blk);
            } else {
                this.prtIndent("addWork: %s added: %s  pos 0x%x  new list len: %d", msg, blk.blkName, blk.blkPosition, this.workList.size());
            }
        }
    }

    String formatName(String name, int bufPos) {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append(this.mkIndent());
        sbuf.append(String.format("hex %04x", bufPos));
        sbuf.append("  ");
        sbuf.append(String.format("%-30s", name));
        sbuf.append("  ");
        return sbuf.toString();
    }

    String mkIndent() {
        String res = "";
        for (int ii = 0; ii < this.indent; ++ii) {
            res = res + "  ";
        }
        return res;
    }

    void initStat() throws HdfException {
        if (this.logDir != null) {
            String sepChar;
            String dirName;
            String tstatTag = this.statTag.replaceAll("[ /,.:;()<>\\]\\[]", "_");
            Date curDate = new Date();
            SimpleTimeZone utcZone = new SimpleTimeZone(0, "UTC");
            SimpleDateFormat utcSdf = new SimpleDateFormat("yyyy.MM.dd.HH");
            utcSdf.setTimeZone(utcZone);
            File dirFile = new File(this.logDir);
            dirFile.mkdirs();
            if (!dirFile.isDirectory()) {
                HdfFileWriter.throwerr("cannot init stats logDir: \"" + this.logDir + "\"", new Object[0]);
            }
            if (!(dirName = this.logDir).endsWith(sepChar = System.getProperty("file.separator"))) {
                dirName = dirName + sepChar;
            }
            dirName = dirName + utcSdf.format(curDate);
            dirFile = new File(dirName);
            dirFile.mkdirs();
            if (!dirFile.isDirectory()) {
                HdfFileWriter.throwerr("cannot init stats dir: \"" + dirName + "\"", new Object[0]);
            }
            String logName = dirName + sepChar + "nujan." + tstatTag + "." + System.currentTimeMillis() + "." + Thread.currentThread().getId() + ".log";
            try {
                this.statOut = new PrintWriter(logName);
            }
            catch (IOException exc) {
                exc.printStackTrace();
                HdfFileWriter.throwerr("cannot open logName: \"" + logName + "\"", new Object[0]);
            }
        }
    }

    void closeStat() {
        if (this.logDir != null) {
            this.statOut.close();
        }
    }

    long printStat(long prevTime, String tag, String extraMsg) {
        long curTime = System.currentTimeMillis();
        if (this.logDir != null) {
            Date curDate = new Date(curTime);
            SimpleTimeZone utcZone = new SimpleTimeZone(0, "UTC");
            SimpleDateFormat utcSdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            utcSdf.setTimeZone(utcZone);
            String deltaMsg = "NA";
            if (prevTime != 0L) {
                deltaMsg = String.format("%.4f", 0.001 * (double)(curTime - prevTime));
            }
            Runtime rt = Runtime.getRuntime();
            rt.gc();
            long freeMem = rt.freeMemory();
            String msg = utcSdf.format(curDate) + " " + tag + "  delta: " + deltaMsg + "  freeMem: " + freeMem;
            if (extraMsg != null) {
                msg = msg + "  " + extraMsg;
            }
            this.statOut.println(msg);
            this.statOut.flush();
        }
        return curTime;
    }
}

