/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.envisat;

import org.esa.snap.core.util.Debug;
import org.esa.snap.dataio.envisat.ItemInfo;

public abstract class DataItemInfo
extends ItemInfo {
    private final int _dataType;
    private final String _physicalUnit;

    protected DataItemInfo(String itemName, int dataType, String physicalUnit, String description) {
        super(itemName, description);
        Debug.assertTrue((dataType != 0 ? 1 : 0) != 0, (String)"undefined field data type");
        this._dataType = dataType;
        this._physicalUnit = physicalUnit;
    }

    public final int getDataType() {
        return this._dataType;
    }

    public final String getPhysicalUnit() {
        return this._physicalUnit;
    }

    public static int getDataTypeElemSize(int itemDataType) {
        switch (itemDataType) {
            case 10: 
            case 20: 
            case 41: {
                return 1;
            }
            case 11: 
            case 21: {
                return 2;
            }
            case 12: 
            case 22: 
            case 30: {
                return 4;
            }
            case 31: {
                return 8;
            }
            case 51: {
                return 12;
            }
        }
        return 0;
    }
}

