/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning.reader;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.esa.snap.binning.reader.AbstractGridAccessor;
import org.esa.snap.binning.reader.BinnedProductReaderPlugin;
import org.esa.snap.binning.reader.FullGridAccessor;
import org.esa.snap.binning.reader.SparseGridAccessor;
import org.esa.snap.binning.reader.VariableReader;
import org.esa.snap.binning.support.SEAGrid;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.dataio.netcdf.util.MetadataUtils;
import org.esa.snap.dataio.netcdf.util.NetcdfFileOpener;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class BinnedProductReader
extends AbstractProductReader {
    private NetcdfFile netcdfFile;
    private AbstractGridAccessor gridAccessor;
    private Product product;
    private SEAGrid planetaryGrid;
    private int sceneRasterWidth;
    private int sceneRasterHeight;
    private Map<Band, VariableReader> bandMap;
    private double pixelSizeX;

    public BinnedProductReader(BinnedProductReaderPlugin readerPlugIn) {
        super((ProductReaderPlugIn)readerPlugIn);
    }

    protected Product readProductNodesImpl() throws IOException {
        String path = this.getInput().toString();
        this.netcdfFile = NetcdfFileOpener.open((Object)path);
        if (this.netcdfFile == null) {
            throw new IOException("Could not open NetCDF file " + path);
        }
        this.gridAccessor = BinnedProductReader.isSparseGridded(this.netcdfFile) ? new SparseGridAccessor(this.netcdfFile) : new FullGridAccessor(this.netcdfFile);
        this.bandMap = new HashMap<Band, VariableReader>();
        try {
            this.initProductWidthAndHeight();
            this.initProduct();
            this.initGeoCoding();
            this.readMetadata();
            this.initBands();
            this.initPlanetaryGrid();
            this.gridAccessor.setPlanetaryGrid(this.planetaryGrid);
            this.gridAccessor.setPixelSizeX(this.pixelSizeX);
        }
        catch (IOException e) {
            this.dispose();
            throw e;
        }
        return this.product;
    }

    private static boolean isSparseGridded(NetcdfFile netcdfFile) {
        Variable bl_bin_num = netcdfFile.findVariable("bl_bin_num");
        Variable bi_begin = netcdfFile.findVariable("bi_begin");
        Variable bi_extent = netcdfFile.findVariable("bi_extent");
        return bl_bin_num != null && bi_begin != null && bi_extent != null;
    }

    private void initBands() throws IOException {
        int largestDimensionSize = this.getLargestDimensionSize();
        for (Variable variable : this.netcdfFile.getVariables()) {
            List variableDimensions = variable.getDimensions();
            int numDimensions = variableDimensions.size();
            if (numDimensions == 0) continue;
            if (numDimensions == 1) {
                if (((Dimension)variableDimensions.get(0)).getLength() != largestDimensionSize) continue;
                this.addBand(variable.getFullName());
                continue;
            }
            int binDimIndex = -1;
            int auxDimIndex = -1;
            for (int i = 0; i < numDimensions; ++i) {
                if (((Dimension)variableDimensions.get(i)).getLength() == largestDimensionSize) {
                    if (binDimIndex != -1) {
                        throw new IllegalArgumentException("2 Dimensions have num bins. Unsupported.");
                    }
                    binDimIndex = i;
                    continue;
                }
                if (((Dimension)variableDimensions.get(i)).getLength() <= 1) continue;
                if (auxDimIndex != -1) {
                    throw new IllegalArgumentException("2 Auxiliary dimension. Unsupported.");
                }
                auxDimIndex = i;
            }
            if (binDimIndex == -1) continue;
            int[] origin = new int[numDimensions];
            Arrays.fill(origin, 0);
            int[] shape = new int[numDimensions];
            Arrays.fill(shape, 1);
            shape[binDimIndex] = largestDimensionSize;
            if (auxDimIndex != -1) {
                int i = 0;
                while (i < ((Dimension)variableDimensions.get(auxDimIndex)).getLength()) {
                    String suffix = "_" + i;
                    int[] auxOrigin = (int[])origin.clone();
                    auxOrigin[auxDimIndex] = i++;
                    int[] auxShape = (int[])shape.clone();
                    auxShape[auxDimIndex] = 1;
                    this.addBand(variable.getFullName(), suffix, auxOrigin, auxShape, binDimIndex);
                }
                continue;
            }
            this.addBand(variable.getFullName(), "", origin, shape, binDimIndex);
        }
        if (this.product.getNumBands() == 0) {
            throw new IOException("No bands found.");
        }
    }

    private void readMetadata() {
        MetadataUtils.readNetcdfMetadata((NetcdfFile)this.netcdfFile, (MetadataElement)this.product.getMetadataRoot(), (int)this.sceneRasterHeight);
    }

    private void initProduct() {
        File productFile = new File(this.getInput().toString());
        String productName = FileUtils.getFilenameWithoutExtension((File)productFile);
        String productType = "BINNED";
        Attribute titleAttribute = this.netcdfFile.findGlobalAttribute("title");
        if (titleAttribute != null) {
            productType = titleAttribute.getStringValue();
        }
        this.product = new Product(productName, productType, this.sceneRasterWidth, this.sceneRasterHeight, (ProductReader)this);
        this.product.setFileLocation(productFile);
        this.product.setAutoGrouping("adg:aph:atot:bbp:bl_Rrs:chlor_a:Rrs:water");
        this.product.setStartTime(BinnedProductReader.extractStartTime(this.netcdfFile));
        this.product.setEndTime(BinnedProductReader.extractEndTime(this.netcdfFile));
        this.product.setPreferredTileSize(this.sceneRasterWidth, 64);
    }

    private void initPlanetaryGrid() {
        this.planetaryGrid = new SEAGrid(this.sceneRasterHeight);
    }

    private int getLargestDimensionSize() {
        int largestDimensionSize = 0;
        for (Dimension dimension : this.netcdfFile.getDimensions()) {
            if (dimension.getLength() <= largestDimensionSize) continue;
            largestDimensionSize = dimension.getLength();
        }
        return largestDimensionSize;
    }

    private void initProductWidthAndHeight() {
        Dimension bin_index;
        this.sceneRasterHeight = 0;
        for (Variable variable : this.netcdfFile.getVariables()) {
            Attribute gridMappingAttr = variable.findAttribute("grid_mapping_name");
            if (gridMappingAttr == null || !"1D binned sinusoidal".equalsIgnoreCase(gridMappingAttr.getStringValue())) continue;
            Attribute numberOfLatitudeRows = variable.findAttribute("number_of_latitude_rows");
            this.sceneRasterHeight = numberOfLatitudeRows.getNumericValue().intValue();
            break;
        }
        if (this.sceneRasterHeight == 0 && (bin_index = this.netcdfFile.findDimension("bin_index")) != null) {
            this.sceneRasterHeight = bin_index.getLength();
        }
        if (this.sceneRasterHeight == 0) {
            this.sceneRasterHeight = 2160;
        }
        this.sceneRasterWidth = 2 * this.sceneRasterHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        if (BinnedProductReader.isSubSampled(sourceStepX, sourceStepY)) {
            throw new IOException("Sub-sampling is not supported by this product reader.");
        }
        if (sourceWidth != destWidth || sourceHeight != destHeight) {
            throw new IllegalStateException("sourceWidth != destWidth || sourceHeight != destHeight");
        }
        VariableReader variableReader = this.bandMap.get(destBand);
        pm.beginTask("Reading band '" + destBand.getName() + "'...", sourceHeight);
        try {
            Object[] destRasterData;
            float fillValue = this.getFillValue(variableReader.getBinVariable());
            if (destBuffer.getType() == 30) {
                destRasterData = (float[])destBuffer.getElems();
                Arrays.fill(destRasterData, fillValue);
            } else if (destBuffer.getType() == 12) {
                destRasterData = (int[])destBuffer.getElems();
                Arrays.fill((int[])destRasterData, (int)fillValue);
            } else {
                throw new IOException("Format problem. Band datatype should be float32 or int32.");
            }
            for (int y = sourceOffsetY; y < sourceOffsetY + sourceHeight; ++y) {
                int lineIndex = this.sceneRasterHeight - y - 1;
                int startBinIndex = this.gridAccessor.getStartBinIndex(sourceOffsetX, lineIndex);
                int endBinIndex = this.gridAccessor.getEndBinIndex(sourceOffsetX, sourceWidth, lineIndex);
                Array lineValues = this.gridAccessor.getLineValues(destBand, variableReader, lineIndex);
                for (int i = startBinIndex; i < endBinIndex; ++i) {
                    float value = lineValues.getFloat(i);
                    if (value == fillValue) continue;
                    int binIndexInGrid = this.gridAccessor.getBinIndexInGrid(i, lineIndex);
                    int[] xValuesForBin = this.getXValuesForBin(binIndexInGrid, lineIndex);
                    int destStart = Math.max(xValuesForBin[0], sourceOffsetX);
                    int destEnd = Math.min(xValuesForBin[1], sourceOffsetX + sourceWidth);
                    for (int x = destStart; x < destEnd; ++x) {
                        int destRasterIndex = sourceWidth * (y - sourceOffsetY) + (x - sourceOffsetX);
                        destBuffer.setElemFloatAt(destRasterIndex, value);
                    }
                }
            }
            pm.worked(1);
        }
        finally {
            pm.done();
        }
    }

    private float getFillValue(Variable binVariable) {
        Number fillValueN = BinnedProductReader.getAttributeNumericValue(binVariable, "_FillValue");
        return fillValueN != null ? fillValueN.floatValue() : 0.0f;
    }

    static boolean isSubSampled(int sourceStepX, int sourceStepY) {
        return sourceStepX != 1 || sourceStepY != 1;
    }

    private int[] getXValuesForBin(int binIndexInGrid, int row) {
        int numberOfBinsInRow = this.planetaryGrid.getNumCols(row);
        int firstBinIndex = (int)this.planetaryGrid.getFirstBinIndex(row);
        if (firstBinIndex > binIndexInGrid) {
            numberOfBinsInRow = this.planetaryGrid.getNumCols(row - 1);
            firstBinIndex = (int)this.planetaryGrid.getFirstBinIndex(row - 1) + 1;
        }
        double binIndexInRow = binIndexInGrid - firstBinIndex;
        double longitudeExtent = 360.0 / (double)numberOfBinsInRow;
        double smallestLongitude = binIndexInRow * longitudeExtent;
        double largestLongitude = (binIndexInRow + 1.0) * longitudeExtent;
        int startX = (int)Math.round(smallestLongitude / this.pixelSizeX);
        int endX = (int)Math.round(largestLongitude / this.pixelSizeX);
        return new int[]{startX, endX};
    }

    public void close() throws IOException {
        super.close();
        if (this.gridAccessor != null) {
            this.gridAccessor.dispose();
            this.gridAccessor = null;
        }
        if (this.netcdfFile != null) {
            this.netcdfFile.close();
            this.netcdfFile = null;
        }
        this.bandMap.clear();
        this.product = null;
        this.planetaryGrid = null;
    }

    private void initGeoCoding() throws IOException {
        float pixelX = 0.0f;
        float pixelY = 0.0f;
        float easting = -180.0f;
        float northing = 90.0f;
        this.pixelSizeX = 360.0 / (double)this.sceneRasterWidth;
        double pixelSizeY = 180.0 / (double)this.sceneRasterHeight;
        try {
            this.product.setSceneGeoCoding((GeoCoding)new CrsGeoCoding((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, this.sceneRasterWidth, this.sceneRasterHeight, (double)easting, (double)northing, this.pixelSizeX, pixelSizeY, (double)pixelX, (double)pixelY));
        }
        catch (FactoryException e) {
            throw new IOException(e);
        }
        catch (TransformException e) {
            throw new IOException(e);
        }
    }

    private void dispose() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addBand(String varName) {
        VariableMetadata variableMetadata = this.getVariableMetadata(varName);
        if (variableMetadata != null) {
            Band band = new Band(variableMetadata.name, variableMetadata.dataType, this.sceneRasterWidth, this.sceneRasterHeight);
            band.setDescription(variableMetadata.description);
            band.setUnit(variableMetadata.variable.getUnitsString());
            band.setNoDataValue(variableMetadata.fillValue);
            band.setNoDataValueUsed(variableMetadata.fillValue != Double.NaN);
            band.setSpectralWavelength((float)BinnedProductReader.getWavelengthFromBandName(varName));
            this.product.addBand(band);
            VariableReader variableReader = new VariableReader(variableMetadata.variable);
            this.bandMap.put(band, variableReader);
        }
    }

    private void addBand(String varName, String suffix, int[] origin, int[] shape, int binDimIndex) {
        VariableMetadata variableMetadata = this.getVariableMetadata(varName);
        if (variableMetadata != null) {
            String bandName = variableMetadata.name + suffix;
            Band band = new Band(bandName, variableMetadata.dataType, this.sceneRasterWidth, this.sceneRasterHeight);
            band.setDescription(variableMetadata.description);
            band.setUnit(variableMetadata.variable.getUnitsString());
            band.setNoDataValue(variableMetadata.fillValue);
            band.setNoDataValueUsed(variableMetadata.fillValue != Double.NaN);
            band.setSpectralWavelength((float)BinnedProductReader.getWavelengthFromBandName(varName));
            this.product.addBand(band);
            VariableReader variableReader = new VariableReader(variableMetadata.variable, origin, shape, binDimIndex);
            this.bandMap.put(band, variableReader);
        }
    }

    static int getWavelengthFromBandName(String bandName) {
        String[] bandNameParts;
        for (String bandNamePart : bandNameParts = bandName.split("_")) {
            if (!StringUtils.isNumeric((String)bandNamePart, Integer.class)) continue;
            return Integer.parseInt(bandNamePart);
        }
        return 0;
    }

    private VariableMetadata getVariableMetadata(String varName) {
        Number numericValue;
        Variable variable = this.netcdfFile.getRootGroup().findVariable(varName);
        if (variable == null) {
            return null;
        }
        String description = variable.getDescription();
        if (description == null) {
            description = BinnedProductReader.getAttributeStringValue(variable, "comment");
        }
        double fillValue = (numericValue = BinnedProductReader.getAttributeNumericValue(variable, "_FillValue")) != null ? numericValue.doubleValue() : Double.NaN;
        DataType dataType = variable.getDataType();
        int productDataType = 12;
        DataType dType = DataType.getType(Double.class);
        DataType fType = DataType.getType(Float.class);
        if (fType.equals((Object)dataType)) {
            productDataType = 30;
        } else if (dType.equals((Object)dataType)) {
            productDataType = 31;
        }
        return new VariableMetadata(variable, varName, description, fillValue, productDataType);
    }

    private static Number getAttributeNumericValue(Variable variable, String attributeName) {
        Attribute att = variable.findAttribute(attributeName);
        return att != null ? (Number)att.getNumericValue() : (Number)null;
    }

    private static String getAttributeStringValue(Variable variable, String attributeName) {
        Attribute att = variable.findAttribute(attributeName);
        return att != null ? att.getStringValue() : null;
    }

    static ProductData.UTC extractStartTime(NetcdfFile netcdfFile) {
        return BinnedProductReader.extractTime(netcdfFile, "time_coverage_start");
    }

    static ProductData.UTC extractEndTime(NetcdfFile netcdfFile) {
        return BinnedProductReader.extractTime(netcdfFile, "time_coverage_end");
    }

    private static ProductData.UTC extractTime(NetcdfFile netcdfFile, String attributeName) {
        Attribute timeAttribute = netcdfFile.findGlobalAttribute(attributeName);
        if (timeAttribute == null) {
            return null;
        }
        String timeAsString = timeAttribute.getStringValue();
        if (timeAsString.isEmpty()) {
            return null;
        }
        timeAsString = timeAsString.substring(0, timeAsString.length() - 1);
        ProductData.UTC parsedDate = null;
        try {
            parsedDate = ProductData.UTC.parse((String)timeAsString, (String)"yyyyMMddHHmm");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return parsedDate;
    }

    private static class VariableMetadata {
        final Variable variable;
        final String name;
        final String description;
        final double fillValue;
        final int dataType;

        public VariableMetadata(Variable variable, String name, String description, double fillValue, int dataType) {
            this.variable = variable;
            this.name = name;
            this.description = description;
            this.fillValue = fillValue;
            this.dataType = dataType;
        }
    }
}

