/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.binning;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.esa.snap.binning.Aggregator;
import org.esa.snap.binning.Bin;
import org.esa.snap.binning.CellProcessor;
import org.esa.snap.binning.CellProcessorConfig;
import org.esa.snap.binning.CellProcessorDescriptor;
import org.esa.snap.binning.Observation;
import org.esa.snap.binning.SpatialBin;
import org.esa.snap.binning.TemporalBin;
import org.esa.snap.binning.TypedDescriptorsRegistry;
import org.esa.snap.binning.VariableContext;
import org.esa.snap.binning.Vector;
import org.esa.snap.binning.WritableVector;
import org.esa.snap.binning.support.BinTracer;
import org.esa.snap.binning.support.VariableContextImpl;
import org.esa.snap.binning.support.VectorImpl;

public class BinManager {
    private final VariableContext variableContext;
    private final CellProcessor cellProcessor;
    private final Aggregator[] aggregators;
    private final int spatialFeatureCount;
    private final int temporalFeatureCount;
    private final int outputFeatureCount;
    private final int postFeatureCount;
    private final int[] spatialFeatureOffsets;
    private final int[] temporalFeatureOffsets;
    private final int[] outputFeatureOffsets;
    private final String[] spatialFeatureNames;
    private final String[] temporalFeatureNames;
    private final String[] outputFeatureNames;
    private final String[] postFeatureNames;
    private BinTracer binTracer;

    public BinManager() {
        this((VariableContext)new VariableContextImpl(), new Aggregator[0]);
    }

    public BinManager(VariableContext variableContext, Aggregator ... aggregators) {
        this(variableContext, (CellProcessorConfig)null, aggregators);
    }

    public BinManager(VariableContext variableContext, CellProcessorConfig cellProcessorConfig, Aggregator ... aggregators) {
        this.variableContext = variableContext;
        this.aggregators = aggregators;
        this.spatialFeatureOffsets = new int[aggregators.length];
        this.temporalFeatureOffsets = new int[aggregators.length];
        this.outputFeatureOffsets = new int[aggregators.length];
        int spatialFeatureCount = 0;
        int temporalFeatureCount = 0;
        int outputFeatureCount = 0;
        ArrayList spatialFeatureNameList = new ArrayList();
        ArrayList temporalFeatureNameList = new ArrayList();
        for (int i = 0; i < aggregators.length; ++i) {
            Aggregator aggregator = aggregators[i];
            this.spatialFeatureOffsets[i] = spatialFeatureCount;
            this.temporalFeatureOffsets[i] = temporalFeatureCount;
            this.outputFeatureOffsets[i] = outputFeatureCount;
            spatialFeatureCount += aggregator.getSpatialFeatureNames().length;
            temporalFeatureCount += aggregator.getTemporalFeatureNames().length;
            outputFeatureCount += aggregator.getOutputFeatureNames().length;
            Collections.addAll(spatialFeatureNameList, aggregator.getSpatialFeatureNames());
            Collections.addAll(temporalFeatureNameList, aggregator.getTemporalFeatureNames());
        }
        this.spatialFeatureCount = spatialFeatureCount;
        this.temporalFeatureCount = temporalFeatureCount;
        this.outputFeatureCount = outputFeatureCount;
        this.spatialFeatureNames = spatialFeatureNameList.toArray(new String[spatialFeatureNameList.size()]);
        this.temporalFeatureNames = temporalFeatureNameList.toArray(new String[temporalFeatureNameList.size()]);
        this.outputFeatureNames = new String[outputFeatureCount];
        NameUnifier nameUnifier = new NameUnifier();
        int k = 0;
        for (Aggregator aggregator : aggregators) {
            for (int i = 0; i < aggregator.getOutputFeatureNames().length; ++i) {
                this.outputFeatureNames[k] = nameUnifier.unifyName(aggregator.getOutputFeatureNames()[i]);
                ++k;
            }
        }
        if (cellProcessorConfig != null) {
            this.cellProcessor = BinManager.createPostProcessor(cellProcessorConfig, this.outputFeatureNames);
            this.postFeatureNames = this.cellProcessor.getOutputFeatureNames();
            this.postFeatureCount = this.postFeatureNames.length;
        } else {
            this.cellProcessor = null;
            this.postFeatureCount = 0;
            this.postFeatureNames = new String[0];
        }
    }

    private static CellProcessor createPostProcessor(CellProcessorConfig config, String[] outputFeatureNames) {
        VariableContextImpl variableContextAgg = new VariableContextImpl();
        for (String outputFeatureName : outputFeatureNames) {
            variableContextAgg.defineVariable(outputFeatureName);
        }
        TypedDescriptorsRegistry registry = TypedDescriptorsRegistry.getInstance();
        CellProcessorDescriptor descriptor = registry.getDescriptor(CellProcessorDescriptor.class, config.getName());
        if (descriptor != null) {
            return descriptor.createCellProcessor(variableContextAgg, config);
        }
        throw new IllegalArgumentException("Unknown cell processor type: " + config.getName());
    }

    public final VariableContext getVariableContext() {
        return this.variableContext;
    }

    public final int getSpatialFeatureCount() {
        return this.spatialFeatureCount;
    }

    public final int getTemporalFeatureCount() {
        return this.temporalFeatureCount;
    }

    public final int getOutputFeatureCount() {
        return this.outputFeatureCount;
    }

    public final String[] getSpatialFeatureNames() {
        return this.spatialFeatureNames;
    }

    public final String[] getTemporalFeatureNames() {
        return this.temporalFeatureNames;
    }

    public final int getPostProcessFeatureCount() {
        return this.postFeatureCount;
    }

    public final String[] getOutputFeatureNames() {
        return this.outputFeatureNames;
    }

    public final String[] getPostProcessFeatureNames() {
        return this.postFeatureNames;
    }

    public final int getResultFeatureCount() {
        if (this.hasPostProcessor()) {
            return this.postFeatureCount;
        }
        return this.outputFeatureCount;
    }

    public final String[] getResultFeatureNames() {
        if (this.hasPostProcessor()) {
            return this.getPostProcessFeatureNames();
        }
        return this.getOutputFeatureNames();
    }

    public final int getAggregatorCount() {
        return this.aggregators.length;
    }

    public final Aggregator getAggregator(int aggIndex) {
        return this.aggregators[aggIndex];
    }

    public final Vector getSpatialVector(SpatialBin bin, int aggIndex) {
        VectorImpl vector = new VectorImpl(bin.featureValues);
        Aggregator aggregator = this.aggregators[aggIndex];
        vector.setOffsetAndSize(this.spatialFeatureOffsets[aggIndex], aggregator.getSpatialFeatureNames().length);
        return vector;
    }

    public final Vector getTemporalVector(TemporalBin bin, int aggIndex) {
        VectorImpl vector = new VectorImpl(bin.featureValues);
        Aggregator aggregator = this.aggregators[aggIndex];
        vector.setOffsetAndSize(this.temporalFeatureOffsets[aggIndex], aggregator.getTemporalFeatureNames().length);
        return vector;
    }

    public WritableVector createOutputVector() {
        return new VectorImpl(new float[this.outputFeatureCount]);
    }

    public SpatialBin createSpatialBin(long binIndex) {
        SpatialBin spatialBin = new SpatialBin(binIndex, this.spatialFeatureCount);
        this.initSpatialBin(spatialBin);
        this.traceSpatial("createSpatial", null, spatialBin);
        return spatialBin;
    }

    public void aggregateSpatialBin(Observation observation, SpatialBin spatialBin) {
        VectorImpl spatialVector = new VectorImpl(spatialBin.featureValues);
        for (int i = 0; i < this.aggregators.length; ++i) {
            Aggregator aggregator = this.aggregators[i];
            spatialVector.setOffsetAndSize(this.spatialFeatureOffsets[i], aggregator.getSpatialFeatureNames().length);
            aggregator.aggregateSpatial(spatialBin, observation, spatialVector);
        }
        ++spatialBin.numObs;
        this.traceSpatial("aggregateSpatial", observation, spatialBin);
    }

    public void completeSpatialBin(SpatialBin spatialBin) {
        VectorImpl spatialVector = new VectorImpl(spatialBin.featureValues);
        for (int i = 0; i < this.aggregators.length; ++i) {
            Aggregator aggregator = this.aggregators[i];
            spatialVector.setOffsetAndSize(this.spatialFeatureOffsets[i], aggregator.getSpatialFeatureNames().length);
            aggregator.completeSpatial(spatialBin, spatialBin.numObs, spatialVector);
        }
        this.traceSpatial("completeSpatial", null, spatialBin);
    }

    public TemporalBin createTemporalBin(long binIndex) {
        TemporalBin temporalBin = new TemporalBin(binIndex, this.temporalFeatureCount);
        this.initTemporalBin(temporalBin);
        this.traceTemporal("createTemporal", null, temporalBin);
        return temporalBin;
    }

    public TemporalBin createTemporalBin(long binIndex, Iterable<? extends SpatialBin> spatialBins) {
        TemporalBin temporalBin = this.createTemporalBin(binIndex);
        for (SpatialBin spatialBin : spatialBins) {
            this.aggregateTemporalBin(spatialBin, temporalBin);
        }
        this.completeTemporalBin(temporalBin);
        return temporalBin;
    }

    public void aggregateTemporalBin(SpatialBin inputBin, TemporalBin outputBin) {
        this.aggregateBin(inputBin, outputBin);
        ++outputBin.numPasses;
        this.traceTemporal("aggregateTemporal", inputBin, outputBin);
    }

    public void aggregateTemporalBin(TemporalBin inputBin, TemporalBin outputBin) {
        this.aggregateBin(inputBin, outputBin);
        outputBin.numPasses += inputBin.numPasses;
    }

    private void aggregateBin(Bin inputBin, Bin outputBin) {
        VectorImpl spatialVector = new VectorImpl(inputBin.featureValues);
        VectorImpl temporalVector = new VectorImpl(outputBin.featureValues);
        for (int i = 0; i < this.aggregators.length; ++i) {
            Aggregator aggregator = this.aggregators[i];
            spatialVector.setOffsetAndSize(this.spatialFeatureOffsets[i], aggregator.getSpatialFeatureNames().length);
            temporalVector.setOffsetAndSize(this.temporalFeatureOffsets[i], aggregator.getTemporalFeatureNames().length);
            aggregator.aggregateTemporal(outputBin, spatialVector, inputBin.numObs, temporalVector);
        }
        outputBin.numObs += inputBin.numObs;
    }

    public void completeTemporalBin(TemporalBin temporalBin) {
        VectorImpl temporalVector = new VectorImpl(temporalBin.featureValues);
        for (int i = 0; i < this.aggregators.length; ++i) {
            Aggregator aggregator = this.aggregators[i];
            temporalVector.setOffsetAndSize(this.temporalFeatureOffsets[i], aggregator.getTemporalFeatureNames().length);
            aggregator.completeTemporal(temporalBin, temporalBin.numObs, temporalVector);
        }
        this.traceTemporal("completeTemporal", null, temporalBin);
    }

    public TemporalBin createOutputBin(long binIndex) {
        return new TemporalBin(binIndex, this.outputFeatureCount);
    }

    public void computeOutput(TemporalBin temporalBin, WritableVector outputVector) {
        VectorImpl temporalVector = new VectorImpl(temporalBin.featureValues);
        VectorImpl outputVectorImpl = (VectorImpl)outputVector;
        for (int i = 0; i < this.aggregators.length; ++i) {
            Aggregator aggregator = this.aggregators[i];
            temporalVector.setOffsetAndSize(this.temporalFeatureOffsets[i], aggregator.getTemporalFeatureNames().length);
            outputVectorImpl.setOffsetAndSize(this.outputFeatureOffsets[i], aggregator.getOutputFeatureNames().length);
            aggregator.computeOutput(temporalVector, outputVector);
        }
        outputVectorImpl.setOffsetAndSize(0, this.outputFeatureCount);
        this.traceOutput(temporalBin, outputVector);
    }

    protected void initSpatialBin(SpatialBin bin) {
        VectorImpl vector = new VectorImpl(bin.featureValues);
        for (int i = 0; i < this.aggregators.length; ++i) {
            Aggregator aggregator = this.aggregators[i];
            vector.setOffsetAndSize(this.spatialFeatureOffsets[i], aggregator.getSpatialFeatureNames().length);
            aggregator.initSpatial(bin, vector);
        }
    }

    protected void initTemporalBin(TemporalBin bin) {
        VectorImpl vector = new VectorImpl(bin.featureValues);
        for (int i = 0; i < this.aggregators.length; ++i) {
            Aggregator aggregator = this.aggregators[i];
            vector.setOffsetAndSize(this.temporalFeatureOffsets[i], aggregator.getTemporalFeatureNames().length);
            aggregator.initTemporal(bin, vector);
        }
    }

    public boolean hasPostProcessor() {
        return this.cellProcessor != null;
    }

    public TemporalBin createProcessBin(long binIndex) {
        return new TemporalBin(binIndex, this.postFeatureCount);
    }

    public void postProcess(Vector outputVector, WritableVector postVector) {
        this.cellProcessor.compute(outputVector, postVector);
    }

    public void setBinTracer(BinTracer binTracer) {
        this.binTracer = binTracer;
    }

    public BinTracer getBinTracer() {
        return this.binTracer;
    }

    private void traceSpatial(String action, Observation observation, SpatialBin spatialBin) {
        if (BinTracer.traceThis(this.binTracer, spatialBin.getIndex())) {
            this.binTracer.traceSpatial(action, observation, spatialBin);
        }
    }

    private void traceTemporal(String action, SpatialBin spatialBin, TemporalBin temporalBin) {
        if (BinTracer.traceThis(this.binTracer, temporalBin.getIndex())) {
            this.binTracer.traceTemporal(action, spatialBin, temporalBin);
        }
    }

    private void traceOutput(TemporalBin temporalBin, WritableVector outputVector) {
        if (BinTracer.traceThis(this.binTracer, temporalBin.getIndex())) {
            this.binTracer.traceOutput(temporalBin, outputVector);
        }
    }

    static class NameUnifier {
        private final Map<String, Integer> addedNames = new HashMap<String, Integer>();

        NameUnifier() {
        }

        String unifyName(String name) {
            if (!this.addedNames.containsKey(name)) {
                this.addedNames.put(name, 0);
                return name;
            }
            this.addedNames.put(name, this.addedNames.get(name) + 1);
            return name + "_" + this.addedNames.get(name);
        }
    }
}

