/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.interpolators;

import java.text.MessageFormat;
import java.util.Arrays;
import org.esa.snap.interpolators.PolynomialFunction;

public class InterpolatingFunction {
    private final double[] knots;
    private final PolynomialFunction[] polynomials;
    private final int n;

    public InterpolatingFunction(double[] knots, PolynomialFunction[] polynomials) {
        if (knots.length < 2) {
            throw new IllegalArgumentException(MessageFormat.format("Spline partition must have at least {0} points, got {1}.", 2, knots.length));
        }
        if (knots.length - 1 != polynomials.length) {
            throw new IllegalArgumentException(MessageFormat.format("Number of polynomial interpolants must match the number of segments ({0} != {1} - 1).", polynomials.length, knots.length));
        }
        if (!InterpolatingFunction.isStrictlyIncreasing(knots)) {
            throw new IllegalArgumentException("Knot values must be strictly increasing.");
        }
        this.n = knots.length - 1;
        this.knots = new double[this.n + 1];
        System.arraycopy(knots, 0, this.knots, 0, this.n + 1);
        this.polynomials = new PolynomialFunction[this.n];
        System.arraycopy(polynomials, 0, this.polynomials, 0, this.n);
    }

    public double value(double forX) {
        if (forX < this.knots[0] || forX > this.knots[this.n]) {
            throw new IllegalArgumentException(MessageFormat.format("Value {0} is out of the domain of the spline function ({1}, {2}).", forX, this.knots[0], this.knots[this.n]));
        }
        int i = Arrays.binarySearch(this.knots, forX);
        if (i < 0) {
            i = -i - 2;
        }
        if (i >= this.polynomials.length) {
            --i;
        }
        return this.polynomials[i].value(forX - this.knots[i]);
    }

    private static boolean isStrictlyIncreasing(double[] x) {
        for (int i = 1; i < x.length; ++i) {
            if (!(x[i - 1] >= x[i])) continue;
            return false;
        }
        return true;
    }
}

