/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.envi;

import java.io.File;
import java.util.Locale;
import org.esa.snap.core.dataio.EncodeQualification;
import org.esa.snap.core.dataio.ProductWriter;
import org.esa.snap.core.dataio.ProductWriterPlugIn;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.dataio.envi.EnviConstants;
import org.esa.snap.dataio.envi.EnviProductWriter;

public class EnviProductWriterPlugIn
implements ProductWriterPlugIn {
    public static final String FORMAT_NAME = "ENVI";
    private final SnapFileFilter fileFilter = new SnapFileFilter(this.getFormatNames()[0], this.getDefaultFileExtensions(), this.getDescription(null));

    public EncodeQualification getEncodeQualification(Product product) {
        if (product.isMultiSize()) {
            return new EncodeQualification(EncodeQualification.Preservation.UNABLE, "Cannot write multisize products. Consider resampling the product first.");
        }
        return new EncodeQualification(EncodeQualification.Preservation.PARTIAL);
    }

    public String[] getFormatNames() {
        return new String[]{FORMAT_NAME};
    }

    public String[] getDefaultFileExtensions() {
        return EnviConstants.VALID_EXTENSIONS;
    }

    public Class[] getOutputTypes() {
        return new Class[]{String.class, File.class};
    }

    public String getDescription(Locale locale) {
        return "ENVI product writer";
    }

    public ProductWriter createWriterInstance() {
        return new EnviProductWriter(this);
    }

    public SnapFileFilter getProductFileFilter() {
        return this.fileFilter;
    }
}

