/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.utils;

import com.bc.ceres.binding.Property;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.esa.snap.core.util.StringUtils;
import org.jdesktop.swingx.prompt.PromptSupport;

public class UIUtils {
    private static final String FILE_FIELD_PROMPT = "browse for %s";
    private static final String TEXT_FIELD_PROMPT = "enter %s here";
    private static final String CAMEL_CASE_SPLIT = "(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])";

    public static void addPromptSupport(JComponent component, String text) {
        if (JTextComponent.class.isAssignableFrom(component.getClass())) {
            JTextComponent castedComponent = (JTextComponent)component;
            PromptSupport.setPrompt((String)text, (JTextComponent)castedComponent);
            PromptSupport.setFocusBehavior((PromptSupport.FocusBehavior)PromptSupport.FocusBehavior.HIDE_PROMPT, (JTextComponent)castedComponent);
        }
    }

    public static void addPromptSupport(JComponent component, Property property) {
        if (JTextComponent.class.isAssignableFrom(component.getClass())) {
            String text;
            JTextComponent castedComponent = (JTextComponent)component;
            if (File.class.isAssignableFrom(property.getType())) {
                text = String.format(FILE_FIELD_PROMPT, UIUtils.separateWords(property.getName()));
            } else {
                text = property.getDescriptor().getDescription();
                if (StringUtils.isNullOrEmpty((String)text)) {
                    text = String.format(TEXT_FIELD_PROMPT, UIUtils.separateWords(property.getName()));
                }
            }
            PromptSupport.setPrompt((String)text, (JTextComponent)castedComponent);
            PromptSupport.setFocusBehavior((PromptSupport.FocusBehavior)PromptSupport.FocusBehavior.HIDE_PROMPT, (JTextComponent)castedComponent);
        }
    }

    public static void enableUndoRedo(JComponent component) {
        if (component != null) {
            if (JTextComponent.class.isAssignableFrom(component.getClass())) {
                UndoManager undoManager = new UndoManager();
                ((JTextComponent)component).getDocument().addUndoableEditListener(e -> undoManager.addEdit(e.getEdit()));
                InputMap inputMap = component.getInputMap(0);
                ActionMap actionMap = component.getActionMap();
                inputMap.put(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "Undo");
                inputMap.put(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "Redo");
                actionMap.put("Undo", new UndoAction(undoManager));
                actionMap.put("Redo", new RedoAction(undoManager));
            } else if (JPanel.class.equals(component.getClass())) {
                Arrays.stream(component.getComponents()).filter(c -> JTextComponent.class.isAssignableFrom(c.getClass())).map(c -> (JTextComponent)c).forEach(UIUtils::enableUndoRedo);
            }
        }
    }

    private static String separateWords(String text) {
        return UIUtils.separateWords(text, true);
    }

    private static String separateWords(String text, boolean lowerCase) {
        CharSequence[] words = text.split(CAMEL_CASE_SPLIT);
        if (lowerCase) {
            for (int i = 0; i < words.length; ++i) {
                words[i] = ((String)words[i]).toLowerCase();
            }
        }
        return String.join((CharSequence)" ", words);
    }

    private static class RedoAction
    extends AbstractAction {
        private UndoManager undoManager;

        RedoAction(UndoManager manager) {
            this.undoManager = manager;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (this.undoManager != null && this.undoManager.canRedo()) {
                    this.undoManager.redo();
                }
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
        }
    }

    private static class UndoAction
    extends AbstractAction {
        private UndoManager undoManager;

        UndoAction(UndoManager manager) {
            this.undoManager = manager;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (this.undoManager != null && this.undoManager.canUndo()) {
                    this.undoManager.undo();
                }
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
        }
    }
}

