/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ui.tooladapter.model;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.DefaultPropertySetDescriptor;
import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.PropertySetDescriptor;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.converters.FloatConverter;
import com.bc.ceres.binding.converters.IntegerConverter;
import com.bc.ceres.swing.binding.BindingContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.DualHashBidiMap;
import org.esa.snap.core.gpf.annotations.ParameterDescriptorFactory;
import org.esa.snap.core.gpf.descriptor.OperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.ParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.PropertyAttributeException;
import org.esa.snap.core.gpf.descriptor.TemplateParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.ToolAdapterOperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.ToolParameterDescriptor;
import org.esa.snap.core.gpf.ui.OperatorParameterSupport;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.tool.ToolButtonFactory;
import org.esa.snap.ui.tooladapter.dialogs.TemplateParameterEditorDialog;
import org.esa.snap.ui.tooladapter.dialogs.ToolParameterEditorDialog;
import org.esa.snap.ui.tooladapter.model.Bundle;
import org.esa.snap.ui.tooladapter.model.CustomParameterClass;
import org.esa.snap.ui.tooladapter.model.FilePanel;
import org.esa.snap.ui.tooladapter.model.PropertyMemberUIWrapper;
import org.esa.snap.ui.tooladapter.model.PropertyMemberUIWrapperFactory;

public class OperatorParametersTable
extends JTable {
    private static final Logger logger = Logger.getLogger(OperatorParametersTable.class.getName());
    private static String[] columnNames = new String[]{"", "Name", "Description", "Label", "Data type", "Default value", ""};
    private static String[] columnsMembers = new String[]{"del", "name", "description", "label", "dataType", "defaultValue", "edit"};
    private static int[] widths = new int[]{27, 100, 200, 80, 100, 249, 30};
    private static final BidiMap typesMap = new DualHashBidiMap();
    private ToolAdapterOperatorDescriptor operator = null;
    private Map<ToolParameterDescriptor, PropertyMemberUIWrapper> propertiesValueUIDescriptorMap;
    private MultiRenderer tableRenderer;
    private BindingContext context;
    private final TableCellRenderer dataTypesComboCellRenderer;
    private final AppContext appContext;
    private final DefaultTableCellRenderer labelTypeCellRenderer;
    private JComboBox cellDefaultValueComboBox;
    private JCheckBox cellDefaultValueCheckBox;
    private JScrollPane cellDefaultValueList;
    private FilePanel cellDefaultValueFile;
    private JComboBox cellDataTypesComboBox;
    private JTextField cellTextComponent;
    private JComponent currentDisplayedCellComponent;
    private int cellComponentColumnIndex;
    private int cellComponentRowIndex;

    public OperatorParametersTable(ToolAdapterOperatorDescriptor operator, AppContext appContext) {
        this.operator = operator;
        this.appContext = appContext;
        this.propertiesValueUIDescriptorMap = new HashMap<ToolParameterDescriptor, PropertyMemberUIWrapper>();
        this.dataTypesComboCellRenderer = new DefaultTableCellRenderer();
        this.labelTypeCellRenderer = new DefaultTableCellRenderer();
        this.labelTypeCellRenderer.setText(Bundle.Type_ProductList_Text());
        List data = operator.getToolParameterDescriptors();
        PropertySet propertySet = new OperatorParameterSupport((OperatorDescriptor)operator).getPropertySet();
        this.context = new BindingContext(propertySet);
        for (ToolParameterDescriptor paramDescriptor : data) {
            if (paramDescriptor.getName().equals("sourceProduct")) {
                this.propertiesValueUIDescriptorMap.put(paramDescriptor, PropertyMemberUIWrapperFactory.buildEmptyPropertyWrapper());
                continue;
            }
            this.propertiesValueUIDescriptorMap.put(paramDescriptor, PropertyMemberUIWrapperFactory.buildPropertyWrapper("defaultValue", paramDescriptor, operator, this.context, null));
        }
        this.tableRenderer = new MultiRenderer();
        this.setModel(new OperatorParametersTableNewTableModel());
        this.setAutoResizeMode(0);
        for (int i = 0; i < widths.length; ++i) {
            this.getColumnModel().getColumn(i).setPreferredWidth(widths[i]);
        }
        this.putClientProperty("JComboBox.isTableCellEditor", Boolean.FALSE);
        this.setRowHeight(20);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                int clickedColumn = OperatorParametersTable.this.columnAtPoint(event.getPoint());
                int clickedRow = OperatorParametersTable.this.rowAtPoint(event.getPoint());
                if (clickedColumn >= 0 && clickedRow >= 0 && OperatorParametersTable.this.isTableCellEditable(clickedRow, clickedColumn)) {
                    OperatorParametersTable.this.mouseClickOnCell(clickedColumn, clickedRow);
                }
            }
        });
        FocusAdapter focusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                OperatorParametersTable.this.hideCurrentDisplayedCellComponent(focusEvent);
            }
        };
        this.createCellDefaultValueList(focusListener);
        this.createCellDefaultValueFileChooser(focusListener);
        this.createCellDefaultValueCheckBox(focusListener);
        this.createCellDefaultValueComboBox(focusListener);
        this.createCellTextComponent(focusListener);
        this.createCellDataTypesComponent();
        this.resetCellComponentPosition();
    }

    private void createCellDefaultValueFileChooser(FocusListener focusListener) {
        this.cellDefaultValueFile = new FilePanel();
        this.cellDefaultValueFile.setBackground(Color.white);
        this.cellDefaultValueFile.setOpaque(true);
        this.cellDefaultValueFile.setVisible(false);
        this.cellDefaultValueFile.addTextComponentFocusListener(focusListener);
        this.cellDefaultValueFile.addBrowseButtonActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                File selectedFile;
                ToolParameterDescriptor descriptor = (ToolParameterDescriptor)OperatorParametersTable.this.operator.getToolParameterDescriptors().get(OperatorParametersTable.this.cellComponentRowIndex);
                String parameterType = descriptor.getParameterType();
                int selectionMode = 0;
                if ("FolderParameter".equals(parameterType)) {
                    selectionMode = 1;
                }
                FileFilter filter = null;
                if ("TemplateParamater".equals(parameterType) || "TemplateBeforeExecution".equals(parameterType) || "TemplateAfterExecution".equals(parameterType)) {
                    filter = new FileFilter(){

                        @Override
                        public boolean accept(File file) {
                            return file.isDirectory() || file.getName().toLowerCase().endsWith(".vm");
                        }

                        @Override
                        public String getDescription() {
                            return "*.vm files";
                        }
                    };
                }
                if ((selectedFile = OperatorParametersTable.this.cellDefaultValueFile.showFileChooserDialog(selectionMode, filter)) != null) {
                    descriptor.setDefaultValue(selectedFile.getAbsolutePath());
                    OperatorParametersTable.this.fireTableRowsChanged();
                }
            }
        });
    }

    private void createCellDefaultValueList(FocusListener focusListener) {
        JList list = new JList();
        list.addFocusListener(focusListener);
        this.cellDefaultValueList = new JScrollPane(list);
        this.cellDefaultValueList.setVerticalScrollBarPolicy(22);
        this.cellDefaultValueList.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.cellDefaultValueList.setOpaque(true);
        this.cellDefaultValueList.setVisible(false);
        this.cellDefaultValueList.setBackground(Color.white);
        this.cellDefaultValueList.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent event) {
                OperatorParametersTable.this.cellDefaultValueList.getViewport().getView().requestFocusInWindow();
            }
        });
    }

    private void createCellDefaultValueCheckBox(FocusListener focusListener) {
        this.cellDefaultValueCheckBox = new JCheckBox();
        this.cellDefaultValueCheckBox.setBackground(Color.white);
        this.cellDefaultValueCheckBox.setOpaque(true);
        this.cellDefaultValueCheckBox.setVisible(false);
        this.cellDefaultValueCheckBox.addFocusListener(focusListener);
    }

    private void createCellDefaultValueComboBox(FocusListener focusListener) {
        this.cellDefaultValueComboBox = new JComboBox();
        this.cellDefaultValueComboBox.setOpaque(true);
        this.cellDefaultValueComboBox.setVisible(false);
        this.cellDefaultValueComboBox.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.cellDefaultValueComboBox.addFocusListener(focusListener);
    }

    private void createCellDataTypesComponent() {
        this.cellDataTypesComboBox = new JComboBox<Object>(typesMap.keySet().toArray());
        this.cellDataTypesComboBox.setOpaque(true);
        this.cellDataTypesComboBox.setVisible(false);
        this.cellDataTypesComboBox.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.cellDataTypesComboBox.addActionListener(ev -> {
            String typeName = (String)this.cellDataTypesComboBox.getSelectedItem();
            this.cellDataTypeChanged(typeName, this.cellComponentRowIndex, this.cellComponentColumnIndex);
        });
        this.cellDataTypesComboBox.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                OperatorParametersTable.this.hideCurrentDisplayedCellComponent();
            }
        });
    }

    private void createCellTextComponent(FocusListener focusListener) {
        this.cellTextComponent = new JTextField();
        this.cellTextComponent.setOpaque(true);
        this.cellTextComponent.setVisible(false);
        this.cellTextComponent.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.cellTextComponent.addFocusListener(focusListener);
    }

    private void mouseClickOnCell(int clickedColumn, int clickedRow) {
        if (clickedColumn == 0) {
            if (this.canRemoveRow(clickedRow)) {
                this.removeRow(clickedRow);
            }
        } else if (clickedColumn == 6) {
            this.showToolParameterEditorDialog(clickedRow);
        } else if (clickedColumn == 4) {
            this.showCellDataTypeComboBoxEditor(clickedColumn, clickedRow);
        } else if (clickedColumn == 5) {
            this.showCellDefaultValueComponent(clickedColumn, clickedRow);
        } else if (clickedColumn == 1 || clickedColumn == 2 || clickedColumn == 3) {
            this.showCellTextComponentEditor(clickedColumn, clickedRow);
        }
    }

    private void showCellDefaultValueComponent(int clickedColumn, int clickedRow) {
        ToolParameterDescriptor descriptor = (ToolParameterDescriptor)this.operator.getToolParameterDescriptors().get(clickedRow);
        String defaultValue = descriptor.getDefaultValue();
        if (descriptor.getDataType() == String.class || descriptor.getDataType() == Integer.class || descriptor.getDataType() == Float.class) {
            String[] valueSet = descriptor.getValueSet();
            if (valueSet != null && valueSet.length > 0) {
                DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
                String itemToSelect = null;
                for (int i = 0; i < valueSet.length; ++i) {
                    model.addElement(valueSet[i]);
                    if (defaultValue == null || !defaultValue.equals(valueSet[i])) continue;
                    itemToSelect = valueSet[i];
                }
                model.setSelectedItem(itemToSelect);
                this.cellDefaultValueComboBox.setModel(model);
                this.setCurrentCellComponentEditor(clickedColumn, clickedRow, this.cellDefaultValueComboBox);
            } else {
                this.cellTextComponent.setText(defaultValue);
                this.setCurrentCellComponentEditor(clickedColumn, clickedRow, this.cellTextComponent);
            }
        } else if (descriptor.getDataType() == Boolean.class) {
            this.cellDefaultValueCheckBox.setSelected(Boolean.parseBoolean(defaultValue));
            this.setCurrentCellComponentEditor(clickedColumn, clickedRow, this.cellDefaultValueCheckBox);
        } else if (descriptor.getDataType() == File.class) {
            this.cellDefaultValueFile.setText(defaultValue);
            this.setCurrentCellComponentEditor(clickedColumn, clickedRow, this.cellDefaultValueFile);
        } else if (descriptor.getDataType() == String[].class) {
            this.showCellDefaultValueList(clickedColumn, clickedRow);
        }
    }

    private void showCellDefaultValueList(int clickedColumn, int clickedRow) {
        int i;
        ToolParameterDescriptor descriptor = (ToolParameterDescriptor)this.operator.getToolParameterDescriptors().get(clickedRow);
        String defaultValue = descriptor.getDefaultValue();
        String[] valueSet = descriptor.getValueSet();
        JList list = (JList)this.cellDefaultValueList.getViewport().getView();
        DefaultListModel<String> model = new DefaultListModel<String>();
        ArrayList<Integer> selectedIndices = new ArrayList<Integer>();
        if (valueSet != null && valueSet.length > 0) {
            for (int i2 = 0; i2 < valueSet.length; ++i2) {
                model.addElement(valueSet[i2]);
            }
            String[] itemsToSelect = null;
            if (!StringUtils.isNullOrEmpty((String)defaultValue)) {
                itemsToSelect = defaultValue.split(",");
            }
            if (itemsToSelect != null && itemsToSelect.length > 0) {
                block1: for (i = 0; i < model.getSize(); ++i) {
                    Object item = model.getElementAt(i);
                    for (int k = 0; k < itemsToSelect.length; ++k) {
                        if (!item.equals(itemsToSelect[k])) continue;
                        selectedIndices.add(i);
                        continue block1;
                    }
                }
            }
        }
        list.setModel(model);
        int[] indices = new int[selectedIndices.size()];
        for (i = 0; i < selectedIndices.size(); ++i) {
            indices[i] = (Integer)selectedIndices.get(i);
        }
        list.setSelectedIndices(indices);
        this.setCurrentCellComponentEditor(clickedColumn, clickedRow, this.cellDefaultValueList);
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (this.hasValidCellComponent()) {
            Rectangle tableCellBounds = this.getCellRect(this.cellComponentRowIndex, this.cellComponentColumnIndex, false);
            this.currentDisplayedCellComponent.setBounds(tableCellBounds.x, tableCellBounds.y, tableCellBounds.width, tableCellBounds.height);
        }
    }

    private boolean hasValidCellComponent() {
        return this.currentDisplayedCellComponent != null && this.cellComponentColumnIndex >= 0 && this.cellComponentRowIndex >= 0;
    }

    private final void showCellDataTypeComboBoxEditor(int columnIndex, int rowIndex) {
        int i;
        Object cellValue = this.getValueAt(rowIndex, columnIndex);
        String cellValueAsString = cellValue == null ? "" : cellValue.toString();
        ActionListener[] listeners = this.cellDataTypesComboBox.getActionListeners();
        for (i = 0; i < listeners.length; ++i) {
            this.cellDataTypesComboBox.removeActionListener(listeners[i]);
        }
        this.cellDataTypesComboBox.setSelectedItem(cellValueAsString);
        for (i = 0; i < listeners.length; ++i) {
            this.cellDataTypesComboBox.addActionListener(listeners[i]);
        }
        this.setCurrentCellComponentEditor(columnIndex, rowIndex, this.cellDataTypesComboBox);
    }

    private void showCellTextComponentEditor(int columnIndex, int rowIndex) {
        Object cellValue = this.getValueAt(rowIndex, columnIndex);
        String cellValueAsString = cellValue == null ? "" : cellValue.toString();
        this.cellTextComponent.setText(cellValueAsString);
        this.setCurrentCellComponentEditor(columnIndex, rowIndex, this.cellTextComponent);
    }

    private final void setCurrentCellComponentEditor(final int columnIndex, final int rowIndex, final JComponent cellComponent) {
        if (this.currentDisplayedCellComponent != null && cellComponent != this.currentDisplayedCellComponent) {
            this.currentDisplayedCellComponent.setVisible(false);
            this.remove(this.currentDisplayedCellComponent);
            this.fireTableRowsChanged();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OperatorParametersTable.this.currentDisplayedCellComponent = cellComponent;
                OperatorParametersTable.this.cellComponentColumnIndex = columnIndex;
                OperatorParametersTable.this.cellComponentRowIndex = rowIndex;
                OperatorParametersTable.this.add(OperatorParametersTable.this.currentDisplayedCellComponent);
                Rectangle tableCellBounds = OperatorParametersTable.this.getCellRect(OperatorParametersTable.this.cellComponentRowIndex, OperatorParametersTable.this.cellComponentColumnIndex, false);
                OperatorParametersTable.this.currentDisplayedCellComponent.setBounds(tableCellBounds.x, tableCellBounds.y, tableCellBounds.width, tableCellBounds.height);
                OperatorParametersTable.this.currentDisplayedCellComponent.setVisible(true);
                OperatorParametersTable.this.currentDisplayedCellComponent.requestFocusInWindow();
            }
        });
    }

    private void hideCurrentDisplayedCellComponent(FocusEvent focusEvent) {
        if (this.hasValidCellComponent()) {
            ToolParameterDescriptor descriptor = (ToolParameterDescriptor)this.operator.getToolParameterDescriptors().get(this.cellComponentRowIndex);
            if (this.currentDisplayedCellComponent instanceof JTextField) {
                String cellText = ((JTextField)this.currentDisplayedCellComponent).getText();
                if (this.cellComponentColumnIndex == 1) {
                    this.setParameterNameAt(cellText, this.cellComponentRowIndex, this.cellComponentColumnIndex);
                } else if (this.cellComponentColumnIndex == 2) {
                    descriptor.setDescription(cellText);
                } else if (this.cellComponentColumnIndex == 3) {
                    descriptor.setLabel(cellText);
                } else if (this.cellComponentColumnIndex == 5) {
                    descriptor.setDefaultValue(cellText);
                }
            } else if (this.currentDisplayedCellComponent instanceof JCheckBox) {
                boolean isSelected = ((JCheckBox)this.currentDisplayedCellComponent).isSelected();
                if (this.cellComponentColumnIndex == 5) {
                    descriptor.setDefaultValue(Boolean.toString(isSelected));
                }
            } else if (this.currentDisplayedCellComponent instanceof JComboBox) {
                if (this.cellComponentColumnIndex == 5) {
                    String selectedItem = (String)((JComboBox)this.currentDisplayedCellComponent).getSelectedItem();
                    descriptor.setDefaultValue(selectedItem);
                }
            } else if (this.currentDisplayedCellComponent instanceof FilePanel) {
                if (this.cellComponentColumnIndex == 5) {
                    String filePath = ((FilePanel)this.currentDisplayedCellComponent).getText();
                    descriptor.setDefaultValue(filePath);
                }
            } else if ((this.currentDisplayedCellComponent instanceof JList || this.currentDisplayedCellComponent instanceof JScrollPane) && this.cellComponentColumnIndex == 5) {
                JList list = null;
                if (this.currentDisplayedCellComponent instanceof JList) {
                    list = (JList)this.currentDisplayedCellComponent;
                } else {
                    JScrollPane scrollPane = (JScrollPane)this.currentDisplayedCellComponent;
                    list = (JList)scrollPane.getViewport().getView();
                }
                int[] indices = list.getSelectedIndices();
                String defaultValue = "";
                for (int i = 0; i < indices.length; ++i) {
                    if (i > 0) {
                        defaultValue = defaultValue + ",";
                    }
                    defaultValue = defaultValue + (String)list.getModel().getElementAt(indices[i]);
                }
                descriptor.setDefaultValue(defaultValue);
            }
            this.hideCurrentDisplayedCellComponent();
        }
    }

    private void hideCurrentDisplayedCellComponent() {
        this.remove(this.currentDisplayedCellComponent);
        this.currentDisplayedCellComponent.setVisible(false);
        this.resetCellComponentPosition();
        this.requestFocusInWindow();
        this.currentDisplayedCellComponent = null;
        this.fireTableRowsChanged();
    }

    private void resetCellComponentPosition() {
        this.cellComponentColumnIndex = -1;
        this.cellComponentRowIndex = -1;
    }

    public void stopVariablesTableEditing() {
        if (this.getEditingRow() >= 0 && this.getEditingColumn() >= 0) {
            this.getCellEditor(this.getEditingRow(), this.getEditingColumn()).stopCellEditing();
        }
    }

    private void removeRow(int rowIndex) {
        ToolParameterDescriptor descriptor = (ToolParameterDescriptor)this.operator.getToolParameterDescriptors().get(rowIndex);
        this.operator.removeParamDescriptor(descriptor);
        this.fireTableRowsChanged();
    }

    private boolean canRemoveRow(int rowIndex) {
        ToolParameterDescriptor descriptor = (ToolParameterDescriptor)this.operator.getToolParameterDescriptors().get(rowIndex);
        String descriptorName = descriptor.getName();
        return !"sourceProduct".equals(descriptorName) && !"sourceProductFile".equals(descriptorName) && !"targetProductFile".equals(descriptorName);
    }

    private boolean isTableCellEditable(int rowIndex, int columnIndex) {
        ToolParameterDescriptor descriptor = (ToolParameterDescriptor)this.operator.getToolParameterDescriptors().get(rowIndex);
        String descriptorName = descriptor.getName();
        if ("sourceProduct".equals(descriptorName) || "sourceProductFile".equals(descriptorName)) {
            return false;
        }
        return !"targetProductFile".equals(descriptorName) || columnIndex != 0 && columnIndex != 1 && columnIndex != 4 && columnIndex != 6;
    }

    public void addParameterToTable() {
        String defaultParameterName = null;
        int count = this.operator.getToolParameterDescriptors().size();
        boolean canContinue = true;
        int index = 0;
        while (canContinue) {
            canContinue = false;
            defaultParameterName = "parameterName" + Integer.toString(++index);
            for (int i = 0; i < count && !canContinue; ++i) {
                ToolParameterDescriptor param = (ToolParameterDescriptor)this.operator.getToolParameterDescriptors().get(i);
                if (!param.getName().equals(defaultParameterName)) continue;
                canContinue = true;
            }
        }
        TemplateParameterDescriptor newParameter = new TemplateParameterDescriptor(defaultParameterName, String.class);
        newParameter.setParameterType("RegularParameter");
        final int rowIndex = 0;
        this.addParameterToTable((ToolParameterDescriptor)newParameter, rowIndex);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OperatorParametersTable.this.showCellTextComponentEditor(1, rowIndex);
            }
        });
    }

    public void addParameterToTable(ToolParameterDescriptor param, int index) {
        try {
            this.operator.getToolParameterDescriptors().add(index, param);
            PropertyDescriptor propertyDescriptor = ParameterDescriptorFactory.convert((ParameterDescriptor)param, (Map)new ParameterDescriptorFactory().getSourceProductMap());
            propertyDescriptor.setDefaultValue((Object)param.getDefaultValue());
            DefaultPropertySetDescriptor propertySetDescriptor = new DefaultPropertySetDescriptor();
            propertySetDescriptor.addPropertyDescriptor(propertyDescriptor);
            PropertyContainer container = PropertyContainer.createMapBacked(new HashMap(), (PropertySetDescriptor)propertySetDescriptor);
            this.context.getPropertySet().addProperties(container.getProperties());
            this.createDefaultComponent(param, propertyDescriptor);
            this.fireTableRowsChanged();
        }
        catch (Exception ex) {
            logger.warning(ex.getMessage());
        }
    }

    private void rebuildEditorCell(ToolParameterDescriptor descriptor, Map<String, Object> attributes) {
        PropertySet propertySet = this.context.getPropertySet();
        Property actualProperty = propertySet.getProperty(descriptor.getName());
        propertySet.removeProperty(actualProperty);
        PropertyDescriptor propertyDescriptor = null;
        try {
            propertyDescriptor = ParameterDescriptorFactory.convert((ParameterDescriptor)descriptor, (Map)new ParameterDescriptorFactory().getSourceProductMap());
        }
        catch (ConversionException ex) {
            logger.warning(ex.getMessage());
        }
        propertyDescriptor.setDefaultValue((Object)descriptor.getDefaultValue());
        if (attributes != null && attributes.size() > 0) {
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                propertyDescriptor.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        DefaultPropertySetDescriptor propertySetDescriptor = new DefaultPropertySetDescriptor();
        propertySetDescriptor.addPropertyDescriptor(propertyDescriptor);
        PropertyContainer container = PropertyContainer.createMapBacked(new HashMap(), (PropertySetDescriptor)propertySetDescriptor);
        Object defaultValue = null;
        if (descriptor.getDefaultValue() != null) {
            defaultValue = descriptor.getDefaultTypedValue();
        }
        try {
            container.getProperty(propertyDescriptor.getName()).setValue(defaultValue);
        }
        catch (ValidationException ex) {
            logger.warning(ex.getMessage());
        }
        propertySet.addProperties(container.getProperties());
        this.createDefaultComponent(descriptor, propertyDescriptor);
        this.fireTableRowsChanged();
    }

    private void createDefaultComponent(ToolParameterDescriptor descriptor, PropertyDescriptor propertyDescriptor) {
        if (descriptor.getDataType() != String.class && descriptor.getDataType() != Integer.class && descriptor.getDataType() != Float.class && descriptor.getDataType() != Boolean.class && descriptor.getDataType() != String[].class && descriptor.getDataType() != File.class) {
            this.propertiesValueUIDescriptorMap.put(descriptor, PropertyMemberUIWrapperFactory.buildPropertyWrapper("defaultValue", descriptor, this.operator, this.context, null));
        }
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component component = super.prepareRenderer(renderer, row, column);
        ToolParameterDescriptor descriptor = (ToolParameterDescriptor)this.operator.getToolParameterDescriptors().get(row);
        switch (descriptor.getName()) {
            case "sourceProduct": 
            case "sourceProductFile": 
            case "targetProduct": 
            case "targetProductFile": {
                component.setBackground(Color.lightGray);
                break;
            }
            default: {
                component.setBackground(SystemColor.text);
                component.setForeground(SystemColor.textText);
            }
        }
        return component;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        switch (column) {
            case 0: 
            case 5: 
            case 6: {
                return this.tableRenderer;
            }
            case 4: {
                ToolParameterDescriptor descriptor = (ToolParameterDescriptor)this.operator.getToolParameterDescriptors().get(row);
                if (descriptor.getName().equals("sourceProduct")) {
                    return this.labelTypeCellRenderer;
                }
                return this.dataTypesComboCellRenderer;
            }
        }
        return super.getCellRenderer(row, column);
    }

    public BindingContext getBindingContext() {
        return this.context;
    }

    public void showToolParameterEditorDialog(int rowIndex) {
        ToolParameterDescriptor descriptor = (ToolParameterDescriptor)this.operator.getToolParameterDescriptors().get(rowIndex);
        if (!descriptor.isParameter() && descriptor.getDataType().equals(File.class)) {
            try {
                TemplateParameterEditorDialog editor = new TemplateParameterEditorDialog(this.appContext, (TemplateParameterDescriptor)descriptor, this.operator);
                int returnCode = editor.show();
                if (returnCode == 1) {
                    this.rebuildEditorCell(descriptor, null);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Dialogs.showError((String)ex.getMessage());
            }
        } else {
            ToolParameterEditorDialog editor = new ToolParameterEditorDialog(this.appContext, this.operator, descriptor);
            int returnCode = editor.show();
            if (returnCode == 1) {
                this.rebuildEditorCell(descriptor, null);
            }
        }
    }

    private void fireTableRowsChanged() {
        ((AbstractTableModel)this.getModel()).fireTableDataChanged();
    }

    public static boolean checkUniqueParameterName(ToolAdapterOperatorDescriptor operator, String parameterName, ToolParameterDescriptor descriptorToEdit) {
        int count = operator.getToolParameterDescriptors().size();
        for (int i = 0; i < count; ++i) {
            ToolParameterDescriptor param = (ToolParameterDescriptor)operator.getToolParameterDescriptors().get(i);
            if (descriptorToEdit == param || !param.getName().equals(parameterName)) continue;
            Dialogs.showInformation((String)"Duplicate parameter name.");
            return false;
        }
        return true;
    }

    private void setParameterNameAt(String parameterName, int rowIndex, int columnIndex) {
        ToolParameterDescriptor descriptor = (ToolParameterDescriptor)this.operator.getToolParameterDescriptors().get(rowIndex);
        if (!OperatorParametersTable.checkUniqueParameterName(this.operator, parameterName, descriptor)) {
            return;
        }
        String oldName = descriptor.getName();
        PropertySet propertySet = this.context.getPropertySet();
        Property oldProperty = propertySet.getProperty(oldName);
        Object defaultValue = oldProperty == null ? null : oldProperty.getValue();
        descriptor.setName(parameterName);
        propertySet.removeProperty(oldProperty);
        try {
            PropertyDescriptor propertyDescriptor = ParameterDescriptorFactory.convert((ParameterDescriptor)descriptor, (Map)new ParameterDescriptorFactory().getSourceProductMap());
            if (defaultValue != null) {
                String defaultValueAsString = ToolParameterEditorDialog.processDefaultValue(defaultValue);
                descriptor.setDefaultValue(defaultValueAsString);
                propertyDescriptor.setDefaultValue(defaultValue);
            }
            if (descriptor.getParameterType().equals("FolderParameter")) {
                propertyDescriptor.setAttribute("directory", (Object)true);
            }
            DefaultPropertySetDescriptor propertySetDescriptor = new DefaultPropertySetDescriptor();
            propertySetDescriptor.addPropertyDescriptor(propertyDescriptor);
            PropertyContainer container = PropertyContainer.createMapBacked(new HashMap(), (PropertySetDescriptor)propertySetDescriptor);
            try {
                container.setDefaultValues();
            }
            catch (IllegalStateException ex) {
                logger.warning(ex.getMessage());
            }
            propertySet.addProperties(container.getProperties());
            this.createDefaultComponent(descriptor, propertyDescriptor);
            this.fireTableRowsChanged();
        }
        catch (ConversionException e) {
            logger.warning(e.getMessage());
            Dialogs.showError((String)e.getMessage());
        }
    }

    private void cellDataTypeChanged(Object aValue, int rowIndex, int columnIndex) {
        ToolParameterDescriptor descriptor = (ToolParameterDescriptor)this.operator.getToolParameterDescriptors().get(rowIndex);
        if (descriptor.isTemplateParameter() && "TemplateParamater".equals(descriptor.getParameterType()) && (((TemplateParameterDescriptor)descriptor).getTemplate() != null || ((TemplateParameterDescriptor)descriptor).getParameterDescriptors().stream().findFirst().isPresent())) {
            return;
        }
        CustomParameterClass customClass = (CustomParameterClass)typesMap.get(aValue);
        if (customClass == null) {
            customClass = CustomParameterClass.StringClass;
        }
        HashMap<String, Object> extra = null;
        if (customClass.equals(CustomParameterClass.FolderClass)) {
            extra = new HashMap<String, Object>();
            extra.put("directory", Boolean.TRUE);
        }
        descriptor.setParameterType(customClass.getTypeMask());
        if (descriptor.getDataType() != customClass.getParameterClass()) {
            descriptor.setDataType(customClass.getParameterClass());
            boolean canResetDefaultValue = true;
            if (customClass.getParameterClass() == String.class || customClass.getParameterClass() == String[].class) {
                canResetDefaultValue = false;
            } else if (customClass.getParameterClass() == Integer.class) {
                if (!StringUtils.isNullOrEmpty((String)descriptor.getDefaultValue())) {
                    IntegerConverter integerConverter = new IntegerConverter();
                    try {
                        Number number = integerConverter.parse(descriptor.getDefaultValue());
                        if (number != null) {
                            descriptor.setDefaultValue(number.toString());
                            canResetDefaultValue = false;
                        }
                    }
                    catch (ConversionException number) {}
                }
            } else if (customClass.getParameterClass() == Float.class && !StringUtils.isNullOrEmpty((String)descriptor.getDefaultValue())) {
                FloatConverter integerConverter = new FloatConverter();
                try {
                    Number number = integerConverter.parse(descriptor.getDefaultValue());
                    if (number != null) {
                        descriptor.setDefaultValue(number.toString());
                        canResetDefaultValue = false;
                    }
                }
                catch (ConversionException conversionException) {
                    // empty catch block
                }
            }
            if (canResetDefaultValue) {
                descriptor.setDefaultValue(null);
            }
            descriptor.setValueSet(null);
            this.rebuildEditorCell(descriptor, extra);
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    static {
        typesMap.put((Object)Bundle.Type_TemplateFileClass_Text(), (Object)CustomParameterClass.TemplateFileClass);
        typesMap.put((Object)Bundle.Type_BeforeTemplateFileClass_Text(), (Object)CustomParameterClass.BeforeTemplateFileClass);
        typesMap.put((Object)Bundle.Type_AfterTemplateFileClass_Text(), (Object)CustomParameterClass.AfterTemplateFileClass);
        typesMap.put((Object)Bundle.Type_RegularFileClass_Text(), (Object)CustomParameterClass.RegularFileClass);
        typesMap.put((Object)Bundle.Type_FolderClass_Text(), (Object)CustomParameterClass.FolderClass);
        typesMap.put((Object)Bundle.Type_FileListClass_Text(), (Object)CustomParameterClass.FileListClass);
        typesMap.put((Object)Bundle.Type_StringClass_Text(), (Object)CustomParameterClass.StringClass);
        typesMap.put((Object)Bundle.Type_IntegerClass_Text(), (Object)CustomParameterClass.IntegerClass);
        typesMap.put((Object)Bundle.Type_ListClass_Text(), (Object)CustomParameterClass.ListClass);
        typesMap.put((Object)Bundle.Type_BooleanClass_Text(), (Object)CustomParameterClass.BooleanClass);
        typesMap.put((Object)Bundle.Type_FloatClass_Text(), (Object)CustomParameterClass.FloatClass);
    }

    private class MultiRenderer
    extends AbstractCellEditor
    implements TableCellRenderer {
        private TableCellRenderer defaultRenderer;
        private AbstractButton deleteButton;
        private AbstractButton editButton;
        private JCheckBox checkBoxRenderer = new JCheckBox();
        private JTextField textComponentRenderer = new JTextField();

        public MultiRenderer() {
            this.textComponentRenderer.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.defaultRenderer = new DefaultTableCellRenderer();
            this.deleteButton = ToolButtonFactory.createButton((Icon)UIUtils.loadImageIcon((String)"/org/esa/snap/resources/images/icons/DeleteShapeTool16.gif"), (boolean)false);
            this.editButton = new JButton("...");
            this.deleteButton.addActionListener(e -> this.fireEditingStopped());
            this.editButton.addActionListener(e -> this.fireEditingStopped());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ToolParameterDescriptor descriptor = (ToolParameterDescriptor)OperatorParametersTable.this.operator.getToolParameterDescriptors().get(row);
            switch (column) {
                case 0: {
                    return this.deleteButton;
                }
                case 5: {
                    String defaultValue = descriptor.getDefaultValue();
                    if (descriptor.getDataType() == Boolean.class) {
                        this.checkBoxRenderer.setSelected(Boolean.parseBoolean(defaultValue));
                        return this.checkBoxRenderer;
                    }
                    if (descriptor.getDataType() == String.class || descriptor.getDataType() == Integer.class || descriptor.getDataType() == Float.class) {
                        this.textComponentRenderer.setText(defaultValue);
                        return this.textComponentRenderer;
                    }
                    if (descriptor.getDataType() == String[].class) {
                        this.textComponentRenderer.setText(defaultValue);
                        return this.textComponentRenderer;
                    }
                    if (descriptor.getDataType() == File.class) {
                        this.textComponentRenderer.setText(defaultValue);
                        return this.textComponentRenderer;
                    }
                    try {
                        return ((PropertyMemberUIWrapper)OperatorParametersTable.this.propertiesValueUIDescriptorMap.get(descriptor)).getUIComponent();
                    }
                    catch (Exception e) {
                        logger.warning(e.getMessage());
                        return null;
                    }
                }
                case 6: {
                    return this.editButton;
                }
            }
            return this.defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }
    }

    private class OperatorParametersTableNewTableModel
    extends AbstractTableModel {
        private OperatorParametersTableNewTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            return columnNames[column];
        }

        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public int getRowCount() {
            return OperatorParametersTable.this.operator.getToolParameterDescriptors().size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            ToolParameterDescriptor descriptor = (ToolParameterDescriptor)OperatorParametersTable.this.operator.getToolParameterDescriptors().get(row);
            switch (column) {
                case 0: {
                    return false;
                }
                case 4: {
                    String cellValue = null;
                    if (descriptor.getName().equals("sourceProduct")) {
                        cellValue = Bundle.Type_ProductList_Text();
                    } else if (descriptor.getName().equals("sourceProductFile")) {
                        cellValue = Bundle.Type_FileListClass_Text();
                    } else if (descriptor.getName().equals("targetProductFile")) {
                        cellValue = Bundle.Type_RegularFileClass_Text();
                    } else if (CustomParameterClass.getObject(descriptor.getDataType(), descriptor.getParameterType()).equals(CustomParameterClass.FolderClass)) {
                        cellValue = Bundle.Type_FolderClass_Text();
                    } else {
                        CustomParameterClass item = CustomParameterClass.getObject(descriptor.getDataType(), descriptor.getParameterType());
                        cellValue = (String)typesMap.getKey((Object)item);
                    }
                    return cellValue;
                }
                case 5: {
                    return descriptor.getDefaultValue();
                }
                case 6: {
                    return false;
                }
            }
            try {
                return descriptor.getAttribute(columnsMembers[column]);
            }
            catch (PropertyAttributeException e) {
                logger.warning(e.getMessage());
                return String.format("Error: %s", e.getMessage());
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }
}

