/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.classification.gpf;

import be.abeel.util.Pair;
import com.bc.ceres.core.ProgressMonitor;
import com.google.common.collect.ImmutableSet;
import com.thoughtworks.xstream.XStream;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.javaml.classification.Classifier;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.DefaultDataset;
import net.sf.javaml.core.DenseInstance;
import net.sf.javaml.core.Instance;
import org.esa.snap.classification.gpf.ClassifierAttributeEvaluation;
import org.esa.snap.classification.gpf.ClassifierDescriptor;
import org.esa.snap.classification.gpf.ClassifierReport;
import org.esa.snap.classification.gpf.Evaluator;
import org.esa.snap.classification.gpf.PowerSet;
import org.esa.snap.classification.gpf.SupervisedClassifier;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.IndexCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.dataop.downloadable.StatusProgressMonitor;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.StackUtils;
import org.esa.snap.engine_utilities.gpf.ThreadManager;
import org.esa.snap.engine_utilities.gpf.TileIndex;
import org.esa.snap.engine_utilities.util.VectorUtils;

public abstract class BaseClassifier
implements SupervisedClassifier {
    private final ClassifierParams params;
    private final ClassifierReport classifierReport;
    private Product maskProduct = null;
    private Product[] featureProducts;
    private int sourceImageWidth;
    private int sourceImageHeight;
    private boolean classifierTrained = false;
    private Band labelBand = null;
    private Band confidenceBand = null;
    private Band trainingSetMaskBand = null;
    private double maskNoDataValue = Double.NaN;
    private double maxClassValue = Double.NaN;
    private FeatureInfo[] featureInfoList;
    protected Classifier mlClassifier;
    private static final String LabelBandName = "LabeledClasses";
    private static final String ConfidenceBandName = "Confidence";
    public static final String VectorNodeNameLabelSource = "VectorNodeName";
    private boolean doLoadClassifier;
    private VectorDataNode[] polygonVectorDataNodes;
    private Map<VectorDataNode, Integer> polygonVectorDataNodeToVectorIndex;
    private Map<Integer, String> classLabelMap;
    private Map<String, Integer> labelClassMap;
    private boolean useVectorNodeNameAsLabel;
    private ClassifierDescriptor loadedClassifierDescriptor = null;
    private static final int INT_NO_DATA_VALUE = -1;
    private static final double DOUBLE_NO_DATA_VALUE = Double.NaN;
    private static final int NOT_IN_POLYGON = -1;
    public static final String CLASSIFIER_FILE_EXTENSION = ".class";
    public static final String CLASSIFIER_USER_INFO_FILE_EXTENSION = ".xml";
    public static final String CLASSIFIER_ROOT_FOLDER = "classifiers";
    private double topClassifierPercent = 0.0;
    private String topClassifierName;
    private FeatureInfo[] topFeatureInfoList;
    private static final String[] excludedBands = new String[]{"lat_band", "long_band", "flags"};

    public BaseClassifier(ClassifierParams params) {
        this.params = params;
        this.classifierReport = new ClassifierReport(params.classifierType, params.savedClassifierName);
    }

    protected Object getObjectToSave(Dataset trainDataset) {
        return this.mlClassifier;
    }

    protected Object getXMLInfoToSave(ClassifierUserInfo commonInfo) {
        return commonInfo;
    }

    @Override
    public String getClassifierType() {
        return this.params.classifierType;
    }

    @Override
    public String getProductSuffix() {
        return this.params.productSuffix;
    }

    @Override
    public String getClassifierName() {
        return this.params.savedClassifierName;
    }

    @Override
    public Classifier getMLClassifier() {
        return this.mlClassifier;
    }

    @Override
    public void initialize() throws OperatorException, IOException {
        this.checkSourceProductsValidity();
        this.maskProduct = this.params.sourceProducts[0];
        if (this.params.classValStepSize < 0.0) {
            throw new OperatorException("class value step size = " + this.params.classValStepSize);
        }
        if (this.params.classLevels < 2) {
            throw new OperatorException("class levels = " + this.params.classLevels + "; it must be at least 2");
        }
        this.maxClassValue = BaseClassifier.getMaxValue(this.params.minClassValue, this.params.classValStepSize, this.params.classLevels);
        if (!this.doLoadClassifier && this.params.trainOnRaster && this.params.trainingBands == null) {
            this.trainingSetMaskBand = this.maskProduct.getBandAt(0);
        }
        if (this.params.trainOnRaster && this.params.trainingBands != null && this.params.trainingBands.length == 1) {
            String bandName = this.params.trainingBands[0];
            if (this.params.trainingBands[0].contains("::")) {
                bandName = this.params.trainingBands[0].substring(0, this.params.trainingBands[0].indexOf("::"));
            }
            this.trainingSetMaskBand = this.maskProduct.getBand(bandName);
            if (this.trainingSetMaskBand == null) {
                throw new OperatorException("Fail to find training band in 1st source product: " + bandName);
            }
        }
        this.featureProducts = this.params.sourceProducts;
        if (this.trainingSetMaskBand != null && this.trainingSetMaskBand.isNoDataValueSet()) {
            this.maskNoDataValue = this.trainingSetMaskBand.getNoDataValue();
        }
        if (this.maskProduct != null && !this.params.trainOnRaster) {
            this.polygonVectorDataNodeToVectorIndex = new HashMap<VectorDataNode, Integer>();
            if (this.params.trainingVectors == null || this.params.trainingVectors.length == 0) {
                ArrayList<String> geometryNames = new ArrayList<String>();
                ProductNodeGroup vectorDataNodes = this.maskProduct.getVectorDataGroup();
                for (int i = 0; i < vectorDataNodes.getNodeCount(); ++i) {
                    VectorDataNode node = (VectorDataNode)vectorDataNodes.get(i);
                    if (node.getFeatureCollection().isEmpty()) continue;
                    geometryNames.add(node.getName() + "::" + this.maskProduct.getName());
                }
                if (geometryNames.size() < 2) {
                    throw new OperatorException("Cannot train on vectors because source product has less than 2 vectors");
                }
                ClassifierParams.access$902(this.params, geometryNames.toArray(new String[geometryNames.size()]));
            }
            if (this.doLoadClassifier || this.params.trainingVectors != null) {
                if (this.params.trainingVectors.length == 1) {
                    throw new OperatorException("Please select two or more vectors as classes");
                }
                this.polygonVectorDataNodes = new VectorDataNode[this.params.trainingVectors.length];
                ProductNodeGroup vectorGroup = this.maskProduct.getVectorDataGroup();
                for (int i = 0; i < this.params.trainingVectors.length; ++i) {
                    int multiProductIndex = this.params.trainingVectors[i].indexOf("::");
                    String name = this.params.trainingVectors[i];
                    if (multiProductIndex > 0) {
                        name = this.params.trainingVectors[i].substring(0, multiProductIndex);
                    }
                    this.polygonVectorDataNodes[i] = (VectorDataNode)vectorGroup.get(name);
                    if (this.polygonVectorDataNodes[i] != null) continue;
                    throw new OperatorException("Cannot find vector " + this.params.trainingVectors[i]);
                }
                this.useVectorNodeNameAsLabel = this.params.labelSource == null || this.params.labelSource.isEmpty() || this.params.labelSource.equals(VectorNodeNameLabelSource);
                this.classLabelMap = new HashMap<Integer, String>();
                this.labelClassMap = new HashMap<String, Integer>();
                int classIndex = 0;
                HashSet attribValues = new HashSet();
                for (int i = 0; i < this.polygonVectorDataNodes.length; ++i) {
                    this.polygonVectorDataNodeToVectorIndex.put(this.polygonVectorDataNodes[i], i);
                    if (this.useVectorNodeNameAsLabel) {
                        classIndex = i;
                        this.classLabelMap.put(classIndex, this.polygonVectorDataNodes[i].getName());
                        continue;
                    }
                    String classLabel = VectorUtils.getAttribStringValue((VectorDataNode)this.polygonVectorDataNodes[i], (String)this.params.labelSource);
                    if (this.classLabelMap.values().contains(classLabel)) continue;
                    this.classLabelMap.put(classIndex, classLabel);
                    this.labelClassMap.put(classLabel, classIndex);
                    ++classIndex;
                }
            }
        }
    }

    public static double getMaxValue(double minVal, double stepSize, int levels) {
        return minVal + stepSize * (double)(levels - 1);
    }

    private void checkSourceProductsValidity() {
        this.sourceImageHeight = this.params.sourceProducts[0].getSceneRasterHeight();
        this.sourceImageWidth = this.params.sourceProducts[0].getSceneRasterWidth();
        for (int i = 1; i < this.params.sourceProducts.length; ++i) {
            if (this.sourceImageHeight == this.params.sourceProducts[i].getSceneRasterHeight() && this.sourceImageWidth == this.params.sourceProducts[i].getSceneRasterWidth()) continue;
            throw new OperatorException("Source products are of different dimensions");
        }
    }

    @Override
    public Product createTargetProduct() {
        Product targetProduct = new Product(this.params.sourceProducts[0].getName() + this.getProductSuffix(), this.params.sourceProducts[0].getProductType(), this.sourceImageWidth, this.sourceImageHeight);
        ProductUtils.copyProductNodes((Product)this.params.sourceProducts[0], (Product)targetProduct);
        int dataType = this.params.trainOnRaster ? this.trainingSetMaskBand.getDataType() : 11;
        this.labelBand = new Band(LabelBandName, dataType, this.sourceImageWidth, this.sourceImageHeight);
        String unit = this.params.trainOnRaster && this.trainingSetMaskBand != null ? this.trainingSetMaskBand.getUnit() : "discrete classes";
        this.labelBand.setUnit(unit);
        double noDataVal = this.params.trainOnRaster ? this.trainingSetMaskBand.getNoDataValue() : -1.0;
        this.labelBand.setNoDataValue(noDataVal);
        this.labelBand.setNoDataValueUsed(true);
        this.labelBand.setValidPixelExpression("Confidence >= 0.5");
        if (!this.params.trainOnRaster) {
            IndexCoding indexCoding = new IndexCoding("Classes");
            indexCoding.addIndex("no data", -1, "no data");
            for (Integer i : this.classLabelMap.keySet()) {
                String label = this.classLabelMap.get(i);
                if (label == null || label.isEmpty()) {
                    label = "null";
                }
                indexCoding.addIndex(label, i.intValue(), "");
            }
            targetProduct.getIndexCodingGroup().add((ProductNode)indexCoding);
            this.labelBand.setSampleCoding((SampleCoding)indexCoding);
            ProductNodeGroup vectorDataGroup = targetProduct.getVectorDataGroup();
            for (String vector : this.params.trainingVectors) {
                vectorDataGroup.remove(vectorDataGroup.get(BaseClassifier.createClassLabel(vector)));
            }
        } else {
            IndexCoding indexCoding = this.trainingSetMaskBand.getIndexCoding();
            if (indexCoding != null) {
                IndexCoding icCopy = ProductUtils.copyIndexCoding((IndexCoding)indexCoding, (Product)targetProduct);
                this.labelBand.setSampleCoding((SampleCoding)icCopy);
            }
        }
        targetProduct.addBand(this.labelBand);
        this.confidenceBand = new Band(ConfidenceBandName, 30, this.sourceImageWidth, this.sourceImageHeight);
        this.confidenceBand.setUnit("(0, 1]");
        this.confidenceBand.setNoDataValue(Double.NaN);
        this.confidenceBand.setNoDataValueUsed(true);
        targetProduct.addBand(this.confidenceBand);
        return targetProduct;
    }

    private static String createClassLabel(String vectorName) {
        String label = vectorName;
        if (vectorName.contains("::")) {
            label = vectorName.substring(0, vectorName.indexOf("::"));
        }
        return label;
    }

    public static boolean containsFeature(Product product, String[] featureNames) {
        String[] bandnames = product.getBandNames();
        if (featureNames == null || bandnames == null) {
            return false;
        }
        for (String featureName : featureNames) {
            for (String bandname : bandnames) {
                if (!bandname.contains(featureName)) continue;
                return true;
            }
        }
        return false;
    }

    protected double getConfidence(Instance instance, Object classVal) {
        Map classDis = this.mlClassifier.classDistribution(instance);
        return (Double)classDis.get(classVal);
    }

    @Override
    public void computeTileStack(Operator operator, Map<Band, Tile> targetTileMap, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException, IOException {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int xMax = x0 + targetRectangle.width;
        int yMax = y0 + targetRectangle.height;
        if (!this.classifierTrained) {
            if (this.doLoadClassifier) {
                this.loadClassifier(operator);
            } else {
                this.trainClassifier(operator, pm);
            }
        }
        Tile labelTile = targetTileMap.get(this.labelBand);
        Tile confidenceTile = targetTileMap.get(this.confidenceBand);
        ProductData labelBuffer = labelTile.getDataBuffer();
        ProductData confidenceBuffer = confidenceTile.getDataBuffer();
        TileIndex tgtIndex = new TileIndex(labelTile);
        Tile[] featureTiles = new Tile[this.featureInfoList.length];
        int i = 0;
        for (FeatureInfo feature : this.featureInfoList) {
            featureTiles[i++] = operator.getSourceTile((RasterDataNode)feature.featureBand, targetRectangle);
        }
        for (int y = y0; y < yMax; ++y) {
            tgtIndex.calculateStride(y);
            for (int x = x0; x < xMax; ++x) {
                int tgtIdx = tgtIndex.getIndex(x);
                double[] features = BaseClassifier.getFeatures(featureTiles, this.featureInfoList, x, y);
                if (features == null) {
                    labelBuffer.setElemDoubleAt(tgtIdx, this.params.trainOnRaster ? Double.NaN : -1.0);
                    confidenceBuffer.setElemDoubleAt(tgtIdx, Double.NaN);
                    continue;
                }
                DenseInstance instance = new DenseInstance(features);
                double confidence = Double.NaN;
                Object classVal = this.mlClassifier.classify((Instance)instance);
                if (classVal == null) {
                    classVal = this.params.trainOnRaster ? Double.NaN : -1.0;
                } else {
                    confidence = this.getConfidence((Instance)instance, classVal);
                }
                labelBuffer.setElemDoubleAt(tgtIdx, ((Double)classVal).doubleValue());
                confidenceBuffer.setElemDoubleAt(tgtIdx, confidence);
            }
        }
    }

    public static int getTotalNumBands(Product[] products) {
        int numBands = 0;
        for (Product product : products) {
            numBands += product.getNumBands();
        }
        return numBands;
    }

    private void getVectorInstanceLists(List<Instance> parentList, List<Instance> trainList, List<Instance> testList) {
        HashMap classToInstanceListMap = new HashMap();
        for (Integer i : this.classLabelMap.keySet()) {
            classToInstanceListMap.put(i, new ArrayList());
        }
        for (Instance instance : parentList) {
            int classVal = (int)((Double)instance.classValue()).doubleValue();
            ((List)classToInstanceListMap.get(classVal)).add(instance);
        }
        for (Integer i : this.classLabelMap.keySet()) {
            List list = (List)classToInstanceListMap.get(i);
            boolean addToTrainList = true;
            for (Instance instance : list) {
                if (addToTrainList) {
                    trainList.add(instance);
                    addToTrainList = false;
                    continue;
                }
                testList.add(instance);
                addToTrainList = true;
            }
        }
    }

    public static boolean excludeBand(String bandName) {
        for (String excludedBand : excludedBands) {
            if (!bandName.startsWith(excludedBand)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void trainClassifier(Operator operator, ProgressMonitor opPM) throws IOException {
        if (this.classifierTrained) {
            return;
        }
        try {
            if (this.params.featureBands == null) {
                ArrayList<String> allFeatureBands = new ArrayList<String>();
                for (Product p : this.params.sourceProducts) {
                    for (Band b : p.getBands()) {
                        String bandName;
                        if (b == this.trainingSetMaskBand || BaseClassifier.excludeBand(bandName = b.getName())) continue;
                        allFeatureBands.add(bandName + "::" + p.getName());
                    }
                }
                ClassifierParams.access$1102(this.params, allFeatureBands.toArray(new String[allFeatureBands.size()]));
            }
            HashMap<String, Product> productHashMap = new HashMap<String, Product>();
            for (Product product : this.params.sourceProducts) {
                productHashMap.put(product.getName(), product);
            }
            int i = 0;
            ArrayList<FeatureInfo> featureInfos = new ArrayList<FeatureInfo>(this.params.featureBands.length);
            for (String s : this.params.featureBands) {
                Product product;
                int multiProductIndex = s.indexOf("::");
                String bandName = s;
                String productName = this.maskProduct.getName();
                if (multiProductIndex > 0) {
                    bandName = s.substring(0, multiProductIndex);
                    productName = s.substring(s.indexOf("::") + 2);
                }
                if ((product = (Product)productHashMap.get(productName)) != null) {
                    Band featureBand = product.getBand(bandName);
                    if (featureBand == null) {
                        throw new OperatorException("Failed to find feature band " + s);
                    }
                    if (this.trainingSetMaskBand != null && featureBand == this.trainingSetMaskBand) {
                        throw new OperatorException("The training band has also been selected as a feature band");
                    }
                    FeatureInfo featureInfo = new FeatureInfo(featureBand, i);
                    featureInfos.add(featureInfo);
                    ++i;
                    continue;
                }
                throw new OperatorException("Failed to find feature product " + s);
            }
            this.featureInfoList = featureInfos.toArray(new FeatureInfo[featureInfos.size()]);
            LabeledInstances allLabeledInstances = this.getLabeledInstances(operator, this.params.numTrainSamples * 2, this.featureInfoList);
            if (this.params.evaluateClassifier && this.params.evaluateFeaturePowerSet) {
                this.runFeaturePowerSet(operator, allLabeledInstances, this.featureInfoList, opPM);
            }
            if (!this.classifierTrained) {
                this.mlClassifier = this.createMLClassifier(this.featureInfoList);
                Dataset trainDataset = this.trainClassifier(this.mlClassifier, this.getClassifierName(), allLabeledInstances, this.featureInfoList, false);
                this.saveClassifier(trainDataset);
            }
        }
        finally {
            this.classifierTrained = true;
        }
    }

    private Dataset trainClassifier(Classifier classifier, String name, LabeledInstances labeledInstances, FeatureInfo[] featureInfos, boolean quickEvaluation) {
        List<Instance> testList;
        ArrayList<Instance> trainList;
        if (this.params.trainOnRaster) {
            trainList = labeledInstances.instanceList.subList(0, labeledInstances.instanceList.size() / 2);
            testList = labeledInstances.instanceList.subList(labeledInstances.instanceList.size() / 2, labeledInstances.instanceList.size());
        } else {
            trainList = new ArrayList();
            testList = new ArrayList<Instance>();
            this.getVectorInstanceLists(labeledInstances.instanceList, trainList, testList);
        }
        DefaultDataset trainDataset = new DefaultDataset(trainList);
        this.buildClassifier(classifier, (Dataset)trainDataset);
        if (this.params.evaluateClassifier) {
            DefaultDataset testDataset = new DefaultDataset(testList);
            if (quickEvaluation) {
                this.runQuickEvaluation(classifier, name, labeledInstances, featureInfos, (Dataset)testDataset);
            } else {
                this.runEvaluation(classifier, labeledInstances, featureInfos, (Dataset)testDataset);
            }
        }
        return trainDataset;
    }

    protected void buildClassifier(Classifier classifier, Dataset trainDataset) {
        classifier.buildClassifier(trainDataset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runEvaluation(Classifier mlClassifier, LabeledInstances labeledInstances, FeatureInfo[] featureInfos, Dataset testDataset) {
        StatusProgressMonitor pm = new StatusProgressMonitor(StatusProgressMonitor.TYPE.SUBTASK);
        try {
            Evaluator evaluator = new Evaluator(mlClassifier, this.classifierReport);
            evaluator.evaluateClassifier(labeledInstances.labelMap, labeledInstances.instanceList, testDataset, "Testing");
            evaluator.evaluateFeatures(featureInfos, testDataset, "Testing", (ProgressMonitor)pm);
            this.saveAndOpenReport(true);
        }
        finally {
            pm.done();
        }
    }

    private void saveAndOpenReport(boolean openReport) {
        try {
            this.classifierReport.writeReport();
            if (openReport) {
                this.classifierReport.openClassifierReport();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void runQuickEvaluation(Classifier mlClassifier, String name, LabeledInstances labeledInstances, FeatureInfo[] featureInfos, Dataset testDataset) {
        Evaluator evaluator = new Evaluator(mlClassifier, new ClassifierReport(this.params.classifierType, "dummy"));
        Evaluator.Score score = evaluator.evaluateClassifier(labeledInstances.labelMap, labeledInstances.instanceList, testDataset, "Testing");
        StringBuilder featureBands = new StringBuilder();
        for (FeatureInfo featureInfo : featureInfos) {
            featureBands.append(featureInfo.featureBand.getName());
            featureBands.append(", ");
        }
        this.classifierReport.addPowerSetEvaluation(name + ": " + "cv " + BaseClassifier.f(score.crossValidationPercent * 100.0) + "% " + featureBands.toString());
        if (score.crossValidationPercent > this.topClassifierPercent) {
            this.updateTopSpot(score.crossValidationPercent, name, featureInfos);
        }
    }

    private static String f(double val) {
        return String.format("%-6.2f", val);
    }

    private synchronized void updateTopSpot(double percentCorrect, String name, FeatureInfo[] featureInfos) {
        this.topClassifierPercent = percentCorrect;
        this.topClassifierName = name;
        this.topFeatureInfoList = featureInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runFeaturePowerSet(Operator operator, LabeledInstances allLabeledInstances, FeatureInfo[] completeFeatureInfoList, ProgressMonitor opPM) {
        StatusProgressMonitor pm = new StatusProgressMonitor(StatusProgressMonitor.TYPE.SUBTASK);
        try {
            PowerSet featurePowerSet = new PowerSet(ImmutableSet.copyOf(Arrays.asList(completeFeatureInfoList)), this.params.minPowerSetSize, this.params.maxPowerSetSize);
            ArrayList featureSetList = new ArrayList();
            for (Set set : featurePowerSet) {
                featureSetList.add(set);
            }
            pm.beginTask("Evaluating feature power set", featureSetList.size());
            int cnt = 1;
            for (Set set : featureSetList) {
                if (opPM.isCanceled()) break;
                FeatureInfo[] featureInfos = set.toArray(new FeatureInfo[set.size()]);
                Classifier setClassifier = this.createMLClassifier(featureInfos);
                LabeledInstances subsetLabeledInstances = this.createSubsetLabeledInstances(featureInfos, allLabeledInstances);
                this.trainClassifier(setClassifier, this.getClassifierName() + '.' + cnt, subsetLabeledInstances, featureInfos, true);
                ++cnt;
                pm.worked(1);
            }
            this.classifierReport.setTopClassifier("TOP Classifier = " + this.topClassifierName + " at " + String.format("%-6.2f", this.topClassifierPercent * 100.0) + '%');
            if (this.topFeatureInfoList != null) {
                this.featureInfoList = this.topFeatureInfoList;
                this.mlClassifier = this.createMLClassifier(this.featureInfoList);
                LabeledInstances labeledInstances = this.getLabeledInstances(operator, this.params.numTrainSamples * 2, this.featureInfoList);
                Dataset dataset = this.trainClassifier(this.mlClassifier, this.getClassifierName(), labeledInstances, this.featureInfoList, false);
                this.saveClassifier(dataset);
                this.classifierTrained = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            pm.done();
        }
    }

    private LabeledInstances createSubsetLabeledInstances(FeatureInfo[] featureInfos, LabeledInstances allLabeledInstances) {
        ArrayList<Instance> instanceList = new ArrayList<Instance>();
        ArrayList<Integer> featureIndexList = new ArrayList<Integer>();
        block0: for (FeatureInfo fi : featureInfos) {
            String name = fi.featureBand.getName();
            int i = 0;
            for (FeatureInfo origFI : this.featureInfoList) {
                if (name.equals(origFI.featureBand.getName())) {
                    featureIndexList.add(i);
                    continue block0;
                }
                ++i;
            }
        }
        for (Instance instance : allLabeledInstances.instanceList) {
            instance.keySet();
            DenseInstance newInstance = new DenseInstance(featureIndexList.size());
            newInstance.setClassValue(instance.classValue());
            int i = 0;
            for (Integer index : featureIndexList) {
                newInstance.put((Object)i++, instance.get((Object)index));
            }
            instanceList.add((Instance)newInstance);
        }
        return new LabeledInstances(allLabeledInstances.labelMap, instanceList);
    }

    private Path getClassifierFilePath() throws IOException {
        Path classifierDir = SystemUtils.getAuxDataPath().resolve(CLASSIFIER_ROOT_FOLDER).resolve(this.params.classifierType);
        if (Files.notExists(classifierDir, new LinkOption[0])) {
            Files.createDirectories(classifierDir, new FileAttribute[0]);
        }
        return classifierDir.resolve(this.params.savedClassifierName + CLASSIFIER_FILE_EXTENSION);
    }

    public static void findBandInProducts(Product[] products, String bandName, int[] indices) {
        indices[0] = -1;
        indices[1] = -1;
        for (int i = 0; i < products.length; ++i) {
            for (int j = 0; j < products[i].getNumBands(); ++j) {
                if (!products[i].getBandAt(j).getName().contains(bandName)) continue;
                indices[0] = i;
                indices[1] = j;
                return;
            }
        }
    }

    private void loadClassifierDescriptor() {
        try {
            Path filePath = this.getClassifierFilePath();
            FileInputStream fis = new FileInputStream(filePath.toString());
            try (ObjectInputStream in = new ObjectInputStream(fis);){
                this.loadedClassifierDescriptor = (ClassifierDescriptor)in.readObject();
                String cType = this.loadedClassifierDescriptor.getClassifierType();
                if (!cType.equals(this.params.classifierType)) {
                    throw new OperatorException("Loaded classifier is " + cType + " NOT " + this.params.classifierType);
                }
                this.params.doClassValQuantization = this.loadedClassifierDescriptor.getDoClassValQuantization();
                this.params.minClassValue = this.loadedClassifierDescriptor.getMinClassValue();
                this.params.classValStepSize = this.loadedClassifierDescriptor.getClassValStepSize();
                this.params.classLevels = this.loadedClassifierDescriptor.getClassLevels();
                ClassifierParams.access$902(this.params, this.loadedClassifierDescriptor.getPolygonsAsClasses());
            }
        }
        catch (Exception ex) {
            throw new OperatorException("Failed to load classifier " + ex.getMessage());
        }
    }

    private synchronized void loadClassifier(Operator operator) throws IOException {
        if (this.classifierTrained) {
            return;
        }
        try {
            this.loadClassifierDescriptor();
            String[] featureNames = this.loadedClassifierDescriptor.getFeatureNames();
            int totalAvailableFeatures = BaseClassifier.getTotalNumBands(this.featureProducts);
            if (featureNames.length > totalAvailableFeatures) {
                throw new OperatorException("classifier expects " + featureNames.length + " features; source product(s) only have " + totalAvailableFeatures);
            }
            this.mlClassifier = this.retrieveMLClassifier(this.loadedClassifierDescriptor);
            double[] featureMinValues = this.loadedClassifierDescriptor.getFeatureMinValues();
            double[] featureMaxValues = this.loadedClassifierDescriptor.getFeatureMaxValues();
            SystemUtils.LOG.info("*** Loaded " + this.params.classifierType + " classifier (filename = " + this.params.savedClassifierName + ") to predict " + this.loadedClassifierDescriptor.getClassName());
            int numFeatures = featureNames.length;
            ArrayList<FeatureInfo> featureInfos = new ArrayList<FeatureInfo>(featureNames.length);
            HashSet<Pair> indicesSet = new HashSet<Pair>();
            for (int i = 0; i < numFeatures; ++i) {
                int[] indices = new int[2];
                BaseClassifier.findBandInProducts(this.featureProducts, featureNames[i], indices);
                if (indices[0] < 0) {
                    throw new OperatorException("Failed to find feature band " + featureNames[i] + " in source product");
                }
                Pair idxPair = new Pair((Object)indices[0], (Object)indices[1]);
                if (indicesSet.contains(idxPair)) {
                    throw new OperatorException(this.featureProducts[indices[0]].getBandAt(indices[1]).getName() + " for " + featureNames[i] + " has already appeared as an earlier feature");
                }
                indicesSet.add(idxPair);
                Band featureBand = this.featureProducts[indices[0]].getBandAt(indices[1]);
                double noDataValue = Double.NaN;
                if (featureBand.isNoDataValueSet()) {
                    noDataValue = featureBand.getNoDataValue();
                }
                double offset = featureMinValues[i];
                double scale = 1.0 / (featureMaxValues[i] - offset);
                featureInfos.add(new FeatureInfo(featureBand, i, noDataValue, offset, scale));
            }
            this.featureInfoList = featureInfos.toArray(new FeatureInfo[featureInfos.size()]);
        }
        catch (Exception ex) {
            throw new OperatorException("Error loading or using loaded classifier (" + ex.getMessage() + ')');
        }
        if (this.params.evaluateClassifier && this.trainingSetMaskBand != null) {
            LabeledInstances labeledInstances = this.getLabeledInstances(operator, this.params.numTrainSamples, this.featureInfoList);
            DefaultDataset testDataset = new DefaultDataset(labeledInstances.instanceList);
            this.runEvaluation(this.mlClassifier, labeledInstances, this.featureInfoList, (Dataset)testDataset);
        }
        this.classifierTrained = true;
    }

    private static String getFirstPartOfExpression(String polygonName, int polygonIdx) {
        return '\'' + polygonName + "' ? " + polygonIdx + " : ";
    }

    private static String getExpression(VectorDataNode[] polygons, Map<VectorDataNode, Integer> indexMap) {
        if (polygons == null || indexMap == null) {
            return null;
        }
        VectorDataNode firstNode = polygons[0];
        String expression = BaseClassifier.getFirstPartOfExpression(firstNode.getName(), indexMap.get(firstNode)) + -1;
        for (int i = 1; i < polygons.length; ++i) {
            VectorDataNode nextNode = polygons[i];
            expression = BaseClassifier.getFirstPartOfExpression(nextNode.getName(), indexMap.get(nextNode)) + '(' + expression + ')';
        }
        return expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LabeledInstances getInstanceListFromPolygons(final Operator operator, int numInstances, FeatureInfo[] featureInfos) throws OperatorException {
        Dimension tileSize = new Dimension(512, 512);
        Rectangle[] tileRectangles = OperatorUtils.getAllTileRectangles((Product)this.maskProduct, (Dimension)tileSize, (int)0);
        StatusProgressMonitor status = new StatusProgressMonitor(StatusProgressMonitor.TYPE.SUBTASK);
        status.beginTask("Extracting data... ", tileRectangles.length);
        ArrayList<Instance> instanceList = new ArrayList<Instance>();
        ThreadManager threadManager = new ThreadManager();
        int numClasses = this.classLabelMap.size();
        int[] instancesCnt = new int[numClasses];
        for (int i = 0; i < instancesCnt.length; ++i) {
            instancesCnt[i] = 0;
        }
        int maxCnt = (int)Math.ceil((double)numInstances / (double)numClasses);
        try {
            int i;
            for (i = 0; i < tileRectangles.length; ++i) {
                final Rectangle rectangle = tileRectangles[i];
                VectorDataNode[] polygons = VectorUtils.getPolygonsForOneRectangle((Rectangle)rectangle, (GeoCoding)this.params.sourceProducts[0].getSceneGeoCoding(), (VectorDataNode[])this.polygonVectorDataNodes);
                if (polygons.length == 0) {
                    status.worked(1);
                    continue;
                }
                String virtualBandName = "tmpVirtualBand_" + i;
                String expression = BaseClassifier.getExpression(polygons, this.polygonVectorDataNodeToVectorIndex);
                VirtualBand virtualBand = new VirtualBand(virtualBandName, 11, this.sourceImageWidth, this.sourceImageHeight, expression);
                this.maskProduct.addBand((Band)virtualBand);
                Thread worker = new Thread((Band)virtualBand, featureInfos, instanceList, numInstances, instancesCnt, maxCnt){
                    final /* synthetic */ Band val$virtualBand;
                    final /* synthetic */ FeatureInfo[] val$featureInfos;
                    final /* synthetic */ List val$instanceList;
                    final /* synthetic */ int val$numInstances;
                    final /* synthetic */ int[] val$instancesCnt;
                    final /* synthetic */ int val$maxCnt;
                    {
                        this.val$virtualBand = band;
                        this.val$featureInfos = featureInfoArray;
                        this.val$instanceList = list;
                        this.val$numInstances = n;
                        this.val$instancesCnt = nArray;
                        this.val$maxCnt = n2;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            int x0 = rectangle.x;
                            int y0 = rectangle.y;
                            int w = rectangle.width;
                            int h = rectangle.height;
                            int xMax = x0 + w;
                            int yMax = y0 + h;
                            Tile virtualBandTile = operator.getSourceTile((RasterDataNode)this.val$virtualBand, rectangle);
                            ProductData virtualBandData = virtualBandTile.getDataBuffer();
                            Tile[] featureTiles = new Tile[this.val$featureInfos.length];
                            for (int j = 0; j < this.val$featureInfos.length; ++j) {
                                featureTiles[j] = operator.getSourceTile((RasterDataNode)this.val$featureInfos[j].featureBand, rectangle);
                            }
                            for (int y = y0; y < yMax; ++y) {
                                for (int x = x0; x < xMax; ++x) {
                                    double[] features;
                                    int classVal = virtualBandData.getElemIntAt(virtualBandTile.getDataBufferIndex(x, y));
                                    if (classVal < 0 || (features = BaseClassifier.getFeatures(featureTiles, this.val$featureInfos, x, y)) == null) continue;
                                    DenseInstance instance = new DenseInstance(features);
                                    if (BaseClassifier.this.useVectorNodeNameAsLabel) {
                                        instance.setClassValue((Object)classVal);
                                    } else {
                                        int vectorIndex = classVal;
                                        String val = VectorUtils.getAttribStringValue((VectorDataNode)BaseClassifier.this.polygonVectorDataNodes[vectorIndex], (String)BaseClassifier.this.params.labelSource);
                                        classVal = (Integer)BaseClassifier.this.labelClassMap.get(val);
                                        instance.setClassValue((Object)classVal);
                                    }
                                    List list = this.val$instanceList;
                                    synchronized (list) {
                                        if (this.val$instanceList.size() < this.val$numInstances) {
                                            if (this.val$instancesCnt[classVal] < this.val$maxCnt) {
                                                this.val$instanceList.add(instance);
                                                int n = classVal;
                                                this.val$instancesCnt[n] = this.val$instancesCnt[n] + 1;
                                                if (this.val$instanceList.size() >= this.val$numInstances) {
                                                    return;
                                                }
                                            }
                                        } else {
                                            return;
                                        }
                                        continue;
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            SystemUtils.LOG.severe("Error retrieving features from polygons " + e.getMessage());
                        }
                    }
                };
                threadManager.add(worker);
                status.worked(1);
            }
            threadManager.finish();
            for (i = 0; i < tileRectangles.length; ++i) {
                Band band = this.maskProduct.getBand("tmpVirtualBand_" + i);
                if (band == null) continue;
                this.maskProduct.removeBand(band);
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)(this.params.classifierType + " getTrainingData from polygons "), (Throwable)e);
        }
        finally {
            status.done();
        }
        HashMap<Double, String> labelMap = new HashMap<Double, String>();
        for (Integer classIndex : this.classLabelMap.keySet()) {
            labelMap.put((double)classIndex, this.classLabelMap.get(classIndex));
        }
        return new LabeledInstances(labelMap, instanceList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LabeledInstances getInstanceListFromMaskProduct(final Operator operator, final int numInstances, final FeatureInfo[] featureInfos) throws OperatorException {
        Dimension tileSize = new Dimension(20, 10);
        Rectangle[] tileRectangles = OperatorUtils.getAllTileRectangles((Product)this.maskProduct, (Dimension)tileSize, (int)0);
        StatusProgressMonitor status = new StatusProgressMonitor(StatusProgressMonitor.TYPE.SUBTASK);
        status.beginTask("Getting training data... ", tileRectangles.length);
        final ArrayList<Instance> instanceList = new ArrayList<Instance>();
        try {
            ThreadManager threadManager = new ThreadManager();
            for (final Rectangle rectangle : tileRectangles) {
                Thread worker = new Thread(){
                    final int xMin;
                    final int xMax;
                    final int yMin;
                    final int yMax;
                    final Tile maskTile;
                    final Tile[] featureTiles;
                    {
                        this.xMin = rectangle.x;
                        this.xMax = rectangle.x + rectangle.width;
                        this.yMin = rectangle.y;
                        this.yMax = rectangle.y + rectangle.height;
                        this.maskTile = operator.getSourceTile((RasterDataNode)BaseClassifier.this.trainingSetMaskBand, rectangle);
                        this.featureTiles = new Tile[featureInfos.length];
                    }

                    @Override
                    public void run() {
                        int i = 0;
                        for (FeatureInfo featureInfo : featureInfos) {
                            this.featureTiles[i++] = operator.getSourceTile((RasterDataNode)featureInfo.featureBand, rectangle);
                        }
                        BaseClassifier.this.getData(this.xMin, this.xMax, this.yMin, this.yMax, this.maskTile, this.featureTiles, numInstances, BaseClassifier.this.maskNoDataValue, instanceList);
                    }
                };
                threadManager.add(worker);
                status.worked(1);
            }
            threadManager.finish();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)(this.params.classifierType + " getTrainingData "), (Throwable)e);
        }
        finally {
            status.done();
        }
        HashMap<Double, String> labelMap = new HashMap<Double, String>();
        labelMap.put(0.0, this.trainingSetMaskBand.getName());
        return new LabeledInstances(labelMap, instanceList);
    }

    private LabeledInstances getLabeledInstances(Operator operator, int numInstances, FeatureInfo[] featureInfos) throws OperatorException {
        if (this.params.trainOnRaster) {
            return this.getInstanceListFromMaskProduct(operator, numInstances, featureInfos);
        }
        return this.getInstanceListFromPolygons(operator, numInstances, featureInfos);
    }

    private double quantize(double val) {
        if (!this.params.doClassValQuantization) {
            return val;
        }
        return VectorUtils.quantize((double)val, (double)this.params.minClassValue, (double)this.maxClassValue, (double)this.params.classValStepSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getData(int xMin, int xMax, int yMin, int yMax, Tile maskTile, Tile[] featureTiles, int maxSamples, double maskNoDataValue, List<Instance> instanceList) {
        for (int y = yMin; y < yMax; ++y) {
            for (int x = xMin; x < xMax; ++x) {
                double[] features;
                double maskValue = maskTile.getDataBuffer().getElemDoubleAt(maskTile.getDataBufferIndex(x, y));
                if (Double.isNaN(maskValue) || maskValue == maskNoDataValue || (features = BaseClassifier.getFeatures(featureTiles, this.featureInfoList, x, y)) == null) continue;
                DenseInstance instance = new DenseInstance(features);
                instance.setClassValue((Object)this.quantize(maskValue));
                List<Instance> list = instanceList;
                synchronized (list) {
                    if (instanceList.size() < maxSamples) {
                        instanceList.add((Instance)instance);
                        if (instanceList.size() >= maxSamples) {
                            return;
                        }
                    } else {
                        return;
                    }
                    continue;
                }
            }
        }
    }

    private static double[] getFeatures(Tile[] featureTiles, FeatureInfo[] featureInfos, int x, int y) {
        double[] features = new double[featureTiles.length];
        for (int i = 0; i < featureTiles.length; ++i) {
            double val = featureTiles[i].getDataBuffer().getElemDoubleAt(featureTiles[i].getDataBufferIndex(x, y));
            if (val == featureInfos[i].featureNoDataValue) {
                return null;
            }
            if ((val = (val - featureInfos[i].featureOffsetValue) * featureInfos[i].featureScaleValue) > 1.0) {
                val = 1.0;
            } else if (val < 0.0) {
                val = 0.0;
            }
            features[i] = val;
        }
        return features;
    }

    private void saveClassifier(Dataset trainDataset) throws IOException {
        Object objectToSave = this.getObjectToSave(trainDataset);
        String className = this.trainingSetMaskBand == null ? "???" : StackUtils.getBandNameWithoutDate((String)this.trainingSetMaskBand.getName());
        Object[] sortedObjects = ClassifierAttributeEvaluation.getSortedObjects(trainDataset.classes());
        double[] sortedClassValues = new double[sortedObjects.length];
        for (int i = 0; i < sortedObjects.length; ++i) {
            sortedClassValues[i] = (Double)sortedObjects[i];
        }
        String[] featureNames = new String[this.featureInfoList.length];
        double[] featureMinValues = new double[this.featureInfoList.length];
        double[] featureMaxValues = new double[this.featureInfoList.length];
        for (int i = 0; i < featureNames.length; ++i) {
            Band featureBand = this.featureInfoList[i].featureBand;
            featureNames[i] = featureBand.getName();
            if (featureNames[i].contains("_mst") || featureNames[i].contains("_slv")) {
                featureNames[i] = StackUtils.getBandNameWithoutDate((String)featureNames[i]);
            }
            featureMinValues[i] = featureBand.getStx().getMinimum();
            featureMaxValues[i] = featureBand.getStx().getMaximum();
        }
        String classUnit = this.labelBand.getUnit();
        ClassifierDescriptor classifierDescriptor = new ClassifierDescriptor(this.params.classifierType, this.params.savedClassifierName, objectToSave, sortedClassValues, className, classUnit, featureNames, featureMinValues, featureMaxValues, this.params.doClassValQuantization, this.params.minClassValue, this.params.classValStepSize, this.params.classLevels, this.params.trainingVectors);
        Path filePath = this.getClassifierFilePath();
        try {
            FileOutputStream fos = new FileOutputStream(filePath.toString());
            ObjectOutputStream out = new ObjectOutputStream(fos);
            out.writeObject(classifierDescriptor);
            out.close();
        }
        catch (Exception ex) {
            throw new OperatorException("Failed to save classifier " + ex.getMessage());
        }
        ClassifierUserInfo classifierUserInfo = new ClassifierUserInfo(this.params.savedClassifierName, this.params.classifierType, className, this.params.numTrainSamples, sortedClassValues, this.featureInfoList.length, this.params.trainingBands, this.params.trainingVectors, featureNames, this.params.doClassValQuantization ? this.params.minClassValue : 0.0, this.params.doClassValQuantization ? this.params.classValStepSize : 0.0, this.params.doClassValQuantization ? this.params.classLevels : -1, this.params.doClassValQuantization ? this.maxClassValue : 0.0);
        Object xmlToSave = this.getXMLInfoToSave(classifierUserInfo);
        XStream xstream = new XStream();
        xstream.processAnnotations(xmlToSave.getClass());
        String xmlContent = xstream.toXML(xmlToSave);
        File infoFile = filePath.getParent().resolve(this.params.savedClassifierName + CLASSIFIER_USER_INFO_FILE_EXTENSION).toFile();
        FileWriter fileWriter = new FileWriter(infoFile);
        fileWriter.write(xmlContent);
        fileWriter.flush();
        fileWriter.close();
    }

    private static void dumpInstance(Instance instance) {
        SystemUtils.LOG.info(" Class value = " + instance.classValue());
        for (int i = 0; i < instance.noAttributes(); ++i) {
            SystemUtils.LOG.info(" attr " + i + ": " + instance.value(i));
        }
    }

    public static class ClassifierUserInfo {
        private String classifierFilename;
        private String classifierType;
        private String className;
        private int numSamples;
        private double[] sortedClasses;
        private int numFeatures;
        private String[] trainingBands;
        private String[] trainingVectors;
        private String[] featureNames;
        private double minClassValue;
        private double classValStepSize;
        private int classLevels;
        private double maxClassValue;

        ClassifierUserInfo(String classifierFilename, String classifierType, String className, int numSamples, double[] sortedClasses, int numFeatures, String[] trainingBands, String[] trainingVectors, String[] featureNames, double minClassValue, double classValStepSize, int classLevels, double maxClassValue) {
            this.classifierFilename = classifierFilename;
            this.classifierType = classifierType;
            this.className = className;
            this.numSamples = numSamples;
            this.sortedClasses = sortedClasses;
            this.numFeatures = numFeatures;
            this.trainingBands = trainingBands;
            this.trainingVectors = trainingVectors;
            this.featureNames = featureNames;
            this.minClassValue = minClassValue;
            this.classValStepSize = classValStepSize;
            this.classLevels = classLevels;
            this.maxClassValue = maxClassValue;
        }
    }

    public static class FeatureInfo
    implements Comparable<FeatureInfo> {
        final Band featureBand;
        double featureNoDataValue;
        final double featureOffsetValue;
        final double featureScaleValue;
        private final int id;

        FeatureInfo(Band featureBand, int id) {
            this.featureBand = featureBand;
            this.id = id;
            this.featureNoDataValue = Double.NaN;
            if (featureBand.isNoDataValueSet()) {
                this.featureNoDataValue = featureBand.getNoDataValue();
            }
            this.featureOffsetValue = featureBand.getStx().getMinimum();
            this.featureScaleValue = 1.0 / (featureBand.getStx().getMaximum() - this.featureOffsetValue);
        }

        FeatureInfo(Band featureBand, int id, double featureNoDataValue, double featureOffsetValue, double featureScaleValue) {
            this.featureBand = featureBand;
            this.id = id;
            this.featureNoDataValue = featureNoDataValue;
            this.featureOffsetValue = featureOffsetValue;
            this.featureScaleValue = featureScaleValue;
        }

        @Override
        public int compareTo(FeatureInfo o) {
            return Integer.compare(this.id, o.id);
        }
    }

    private static class LabeledInstances {
        final Map<Double, String> labelMap;
        final List<Instance> instanceList;

        LabeledInstances(Map<Double, String> labelMap, List<Instance> instancesList) {
            this.labelMap = labelMap;
            this.instanceList = instancesList;
        }
    }

    public static class ClassifierParams {
        private final String classifierType;
        private final String productSuffix;
        private final Product[] sourceProducts;
        private final int numTrainSamples;
        private double minClassValue;
        private double classValStepSize;
        private int classLevels;
        private String savedClassifierName;
        private boolean doClassValQuantization;
        private final boolean trainOnRaster;
        private final String[] trainingBands;
        private String[] trainingVectors;
        private String labelSource;
        private String[] featureBands;
        private final boolean evaluateClassifier;
        private final boolean evaluateFeaturePowerSet;
        private final int minPowerSetSize;
        private final int maxPowerSetSize;

        public ClassifierParams(String classifierType, String productSuffix, Product[] sourceProducts, int numTrainSamples, double minClassValue, double classValStepSize, int classLevels, String savedClassifierName, boolean doClassValQuantization, boolean trainOnRaster, String[] trainingBands, String[] trainingVectors, String[] featureBands, String labelSource, boolean evaluateClassifier, boolean evaluateFeaturePowerSet, int minPowerSetSize, int maxPowerSetSize) {
            this.classifierType = classifierType;
            this.productSuffix = productSuffix;
            this.sourceProducts = sourceProducts;
            this.numTrainSamples = numTrainSamples;
            this.minClassValue = minClassValue;
            this.classValStepSize = classValStepSize;
            this.classLevels = classLevels;
            this.savedClassifierName = savedClassifierName;
            this.doClassValQuantization = doClassValQuantization;
            this.trainOnRaster = trainOnRaster;
            this.trainingBands = trainingBands;
            this.trainingVectors = trainingVectors;
            this.featureBands = featureBands;
            this.labelSource = labelSource;
            this.evaluateClassifier = evaluateClassifier;
            this.evaluateFeaturePowerSet = evaluateFeaturePowerSet;
            this.minPowerSetSize = minPowerSetSize;
            this.maxPowerSetSize = maxPowerSetSize;
        }

        static /* synthetic */ String[] access$902(ClassifierParams x0, String[] x1) {
            x0.trainingVectors = x1;
            return x1;
        }

        static /* synthetic */ String[] access$1102(ClassifierParams x0, String[] x1) {
            x0.featureBands = x1;
            return x1;
        }
    }
}

