/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.pgx;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.dataio.pgx.PgxProductReaderPlugIn;

public class PgxProductReader
extends AbstractProductReader {
    private Band band;
    private long dataPosition;
    private ImageInputStream stream;

    public PgxProductReader(PgxProductReaderPlugIn readerPlugIn) {
        super((ProductReaderPlugIn)readerPlugIn);
    }

    protected Product readProductNodesImpl() throws IOException {
        Object input = this.getInput();
        if (input instanceof String || input instanceof File) {
            this.stream = new FileImageInputStream(new File(input.toString()));
        } else if (input instanceof ImageInputStream) {
            this.stream = (ImageInputStream)input;
        } else {
            throw new IllegalStateException("Illegal input: " + input);
        }
        String inputName = input != this.stream ? input.toString() : "PGX-stream";
        Header header = PgxProductReader.readHeader(this.stream);
        if (header == null) {
            throw new IOException(inputName + " does not appear to have a valid PGX format");
        }
        if (header.bitDepth != 16) {
            throw new IOException(inputName + ": can (currently) only decode a bit depths of 16, but found " + header.bitDepth);
        }
        if (header.byteOrder != ByteOrder.BIG_ENDIAN) {
            throw new IOException(inputName + ": can (currently) only decode " + ByteOrder.BIG_ENDIAN + ", but found " + header.byteOrder);
        }
        this.dataPosition = this.stream.getStreamPosition();
        Product product = new Product(FileUtils.getFilenameWithoutExtension((File)new File(inputName)), "PGX", header.width, header.height);
        product.setFileLocation(new File(inputName));
        product.setPreferredTileSize(new Dimension(512, 512));
        this.band = product.addBand("data", header.signed ? 11 : 21);
        return product;
    }

    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
            this.band = null;
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        if (this.band != destBand) {
            return;
        }
        PgxProductReader pgxProductReader = this;
        synchronized (pgxProductReader) {
            int width = destBand.getRasterWidth();
            if (sourceOffsetX == 0 && sourceWidth == width && destBuffer.getNumElems() == sourceWidth * sourceHeight) {
                long pos = this.dataPosition + (long)(sourceOffsetY * width * 2);
                this.stream.seek(pos);
                destBuffer.readFrom(this.stream);
            } else if (destWidth == sourceWidth || destHeight == sourceHeight) {
                for (int i = 0; i < sourceHeight; ++i) {
                    long pos = this.dataPosition + (long)(((i + sourceOffsetY) * width + sourceOffsetX) * 2);
                    this.stream.seek(pos);
                    destBuffer.readFrom(i * sourceWidth, sourceWidth, this.stream);
                }
            }
        }
    }

    static Header readHeader(ImageInputStream stream) throws IOException {
        byte[] buffer = new byte[64];
        stream.read(buffer);
        String header = new String(buffer).split("\n")[0];
        return PgxProductReader.parseHeaderLine(header);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Header parseHeaderLine(String headerLine) {
        StringTokenizer st = new StringTokenizer(headerLine);
        try {
            boolean signed;
            ByteOrder byteOrder;
            int nTokens = st.countTokens();
            if (!st.nextToken().equals("PG")) {
                return null;
            }
            String tmp = st.nextToken();
            if (tmp.equals("LM")) {
                byteOrder = ByteOrder.LITTLE_ENDIAN;
            } else {
                if (!tmp.equals("ML")) return null;
                byteOrder = ByteOrder.BIG_ENDIAN;
            }
            if (nTokens == 6) {
                tmp = st.nextToken();
                if (tmp.equals("+")) {
                    signed = false;
                } else {
                    if (!tmp.equals("-")) return null;
                    signed = true;
                }
            } else {
                signed = false;
            }
            try {
                int bitDepth = new Integer(st.nextToken());
                if (bitDepth <= 0 || bitDepth > 31) {
                    return null;
                }
                int width = new Integer(st.nextToken());
                int height = new Integer(st.nextToken());
                return new Header(byteOrder, signed, bitDepth, width, height);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public static class Header {
        public final ByteOrder byteOrder;
        public final boolean signed;
        public final int bitDepth;
        public final int width;
        public final int height;

        public Header(ByteOrder byteOrder, boolean signed, int bitDepth, int width, int height) {
            this.byteOrder = byteOrder;
            this.signed = signed;
            this.bitDepth = bitDepth;
            this.width = width;
            this.height = height;
        }
    }
}

