/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import weka.core.Instances;
import weka.core.WekaException;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.KFStep;

@KFStep(name="TestSetMaker", category="Evaluation", toolTipText="Make an incoming dataSet or trainingSet into a testSet", iconPath="weka/gui/knowledgeflow/icons/TestSetMaker.gif")
public class TestSetMaker
extends BaseStep {
    private static final long serialVersionUID = 6384920860783839811L;

    @Override
    public void stepInit() {
    }

    @Override
    public void processIncoming(Data data) throws WekaException {
        this.getStepManager().processing();
        String incomingConnName = data.getConnectionName();
        Instances insts = (Instances)data.getPayloadElement(incomingConnName);
        if (insts == null) {
            throw new WekaException("Incoming instances should not be null!");
        }
        this.getStepManager().logBasic("Creating a test set for relation " + insts.relationName());
        Data newData = new Data();
        newData.setPayloadElement("testSet", insts);
        newData.setPayloadElement("aux_set_num", 1);
        newData.setPayloadElement("aux_max_set_num", 1);
        if (!this.isStopRequested()) {
            this.getStepManager().outputData("testSet", newData);
        }
        this.getStepManager().finished();
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        if (this.getStepManager().numIncomingConnections() == 0) {
            return Arrays.asList("dataSet", "trainingSet");
        }
        return new ArrayList<String>();
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        if (this.getStepManager().numIncomingConnections() > 0) {
            return Arrays.asList("testSet");
        }
        return new ArrayList<String>();
    }

    @Override
    public Instances outputStructureForConnectionType(String connectionName) throws WekaException {
        if (!connectionName.equals("testSet") || this.getStepManager().numIncomingConnections() == 0) {
            return null;
        }
        Instances strucForDatasetCon = this.getStepManager().getIncomingStructureForConnectionType("dataSet");
        if (strucForDatasetCon != null) {
            return strucForDatasetCon;
        }
        Instances strucForTrainingSetCon = this.getStepManager().getIncomingStructureForConnectionType("trainingSet");
        if (strucForTrainingSetCon != null) {
            return strucForTrainingSetCon;
        }
        return null;
    }
}

