/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dem.rcp;

import com.bc.ceres.binding.BindingException;
import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.Validator;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.ComponentAdapter;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.dataop.dem.ElevationModel;
import org.esa.snap.core.dataop.dem.ElevationModelDescriptor;
import org.esa.snap.core.dataop.dem.ElevationModelRegistry;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.core.dataop.resamp.ResamplingFactory;
import org.esa.snap.core.image.RasterDataNodeSampleOpImage;
import org.esa.snap.core.image.ResolutionLevel;
import org.esa.snap.dem.dataio.DEMFactory;
import org.esa.snap.dem.rcp.Bundle;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.ModalDialog;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class AddElevationAction
extends AbstractAction
implements ContextAwareAction,
LookupListener,
HelpCtx.Provider {
    private static final String HELP_ID = "createElevation";
    private final Lookup lkp;
    private Product product;
    public static final String DIALOG_TITLE = "Add Elevation Band";
    public static final String DEFAULT_ELEVATION_BAND_NAME = "elevation";
    public static final String DEFAULT_LATITUDE_BAND_NAME = "corr_latitude";
    public static final String DEFAULT_LONGITUDE_BAND_NAME = "corr_longitude";

    public AddElevationAction() {
        this(Utilities.actionsGlobalContext());
    }

    public AddElevationAction(Lookup lkp) {
        super(Bundle.CTL_AddElevationAction_MenuText());
        this.lkp = lkp;
        Lookup.Result lkpContext = lkp.lookupResult(ProductNode.class);
        lkpContext.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, (Object)lkpContext));
        this.setEnableState();
        this.putValue("ShortDescription", Bundle.CTL_AddElevationAction_ShortDescription());
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new AddElevationAction(actionContext);
    }

    public void resultChanged(LookupEvent ev) {
        this.setEnableState();
    }

    private void setEnableState() {
        ProductNode productNode = (ProductNode)this.lkp.lookup(ProductNode.class);
        boolean state = false;
        if (productNode != null) {
            this.product = productNode.getProduct();
            state = this.product.getSceneGeoCoding() != null;
        }
        this.setEnabled(state);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        DialogData dialogData = this.requestDialogData(this.product);
        if (dialogData == null) {
            return;
        }
        String demName = DEMFactory.getProperDEMName((String)dialogData.demName);
        ElevationModelRegistry elevationModelRegistry = ElevationModelRegistry.getInstance();
        ElevationModelDescriptor demDescriptor = elevationModelRegistry.getDescriptor(demName);
        if (demDescriptor == null) {
            Dialogs.showError((String)DIALOG_TITLE, (String)("The DEM '" + demName + "' is not supported."));
            return;
        }
        Resampling resampling = Resampling.BILINEAR_INTERPOLATION;
        if (dialogData.resamplingMethod != null) {
            resampling = ResamplingFactory.createResampling((String)dialogData.resamplingMethod);
        }
        AddElevationAction.computeBands(this.product, demDescriptor, dialogData.outputElevationBand ? dialogData.elevationBandName : null, resampling);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    private static void computeBands(Product product, ElevationModelDescriptor demDescriptor, String elevationBandName, Resampling resampling) {
        ElevationModel dem = demDescriptor.createDem(resampling);
        if (elevationBandName != null) {
            AddElevationAction.addElevationBand(product, dem, elevationBandName);
        }
    }

    private static void addElevationBand(Product product, ElevationModel dem, String elevationBandName) {
        GeoCoding geoCoding = product.getSceneGeoCoding();
        ElevationModelDescriptor demDescriptor = dem.getDescriptor();
        float noDataValue = dem.getDescriptor().getNoDataValue();
        Band elevationBand = product.addBand(elevationBandName, 30);
        elevationBand.setNoDataValueUsed(true);
        elevationBand.setNoDataValue((double)noDataValue);
        elevationBand.setUnit("meters");
        elevationBand.setDescription(demDescriptor.getName());
        elevationBand.setSourceImage(AddElevationAction.createElevationSourceImage(dem, geoCoding, elevationBand));
    }

    private static RenderedImage createElevationSourceImage(final ElevationModel dem, final GeoCoding geoCoding, final Band band) {
        return new DefaultMultiLevelImage((MultiLevelSource)new AbstractMultiLevelSource(band.createMultiLevelModel()){

            protected RenderedImage createImage(int level) {
                return new ElevationSourceImage(dem, geoCoding, band, ResolutionLevel.create((MultiLevelModel)this.getModel(), (int)level));
            }
        });
    }

    private static boolean isOrtorectifiable(Product product) {
        return product.getNumBands() > 0 && product.getBandAt(0).canBeOrthorectified();
    }

    private DialogData requestDialogData(Product product) {
        boolean ortorectifiable = AddElevationAction.isOrtorectifiable(product);
        String[] demNames = DEMFactory.getDEMNameList();
        List<String> sortedDEMNames = Arrays.asList(demNames);
        Collections.sort(sortedDEMNames);
        demNames = sortedDEMNames.toArray(new String[sortedDEMNames.size()]);
        DialogData dialogData = new DialogData("SRTM 3sec (Auto Download)", "BILINEAR_INTERPOLATION", ortorectifiable);
        PropertyContainer propertySet = PropertyContainer.createObjectBacked((Object)dialogData);
        AddElevationAction.configureDemNameProperty((PropertySet)propertySet, "demName", demNames, "SRTM 3sec (Auto Download)");
        AddElevationAction.configureDemNameProperty((PropertySet)propertySet, "resamplingMethod", ResamplingFactory.resamplingNames, "BILINEAR_INTERPOLATION");
        AddElevationAction.configureBandNameProperty((PropertySet)propertySet, "elevationBandName", product);
        AddElevationAction.configureBandNameProperty((PropertySet)propertySet, "latitudeBandName", product);
        AddElevationAction.configureBandNameProperty((PropertySet)propertySet, "longitudeBandName", product);
        BindingContext ctx = new BindingContext((PropertySet)propertySet);
        JList demList = new JList();
        demList.setVisibleRowCount(10);
        ctx.bind("demName", (ComponentAdapter)new SingleSelectionListComponentAdapter(demList));
        JTextField elevationBandNameField = new JTextField();
        elevationBandNameField.setColumns(10);
        ctx.bind("elevationBandName", elevationBandNameField);
        JCheckBox outputDemCorrectedBandsChecker = new JCheckBox("Output DEM-corrected bands");
        ctx.bind("outputDemCorrectedBands", outputDemCorrectedBandsChecker);
        JLabel latitudeBandNameLabel = new JLabel("Latitude band name:");
        JTextField latitudeBandNameField = new JTextField();
        latitudeBandNameField.setEnabled(ortorectifiable);
        ctx.bind("latitudeBandName", latitudeBandNameField).addComponent((JComponent)latitudeBandNameLabel);
        ctx.bindEnabledState("latitudeBandName", true, "outputGeoCodingBands", (Object)true);
        JLabel longitudeBandNameLabel = new JLabel("Longitude band name:");
        JTextField longitudeBandNameField = new JTextField();
        longitudeBandNameField.setEnabled(ortorectifiable);
        ctx.bind("longitudeBandName", longitudeBandNameField).addComponent((JComponent)longitudeBandNameLabel);
        ctx.bindEnabledState("longitudeBandName", true, "outputGeoCodingBands", (Object)true);
        TableLayout tableLayout = new TableLayout(2);
        tableLayout.setTableAnchor(TableLayout.Anchor.WEST);
        tableLayout.setTableFill(TableLayout.Fill.HORIZONTAL);
        tableLayout.setTablePadding(4, 4);
        tableLayout.setCellColspan(0, 0, Integer.valueOf(2));
        tableLayout.setCellColspan(1, 0, Integer.valueOf(2));
        JPanel parameterPanel = new JPanel((LayoutManager)tableLayout);
        parameterPanel.add(new JLabel("Digital elevation model (DEM):"));
        parameterPanel.add(new JScrollPane(demList));
        parameterPanel.add(new JLabel("Resampling method:"));
        JComboBox<String> resamplingCombo = new JComboBox<String>(DEMFactory.getDEMResamplingMethods());
        parameterPanel.add(resamplingCombo);
        ctx.bind("resamplingMethod", resamplingCombo);
        parameterPanel.add(new JLabel("Elevation band name:"));
        parameterPanel.add(elevationBandNameField);
        if (ortorectifiable) {
            parameterPanel.add(outputDemCorrectedBandsChecker);
            parameterPanel.add(latitudeBandNameLabel);
            parameterPanel.add(latitudeBandNameField);
            parameterPanel.add(longitudeBandNameLabel);
            parameterPanel.add(longitudeBandNameField);
            outputDemCorrectedBandsChecker.setSelected(ortorectifiable);
            outputDemCorrectedBandsChecker.setEnabled(ortorectifiable);
        }
        ModalDialog dialog = new ModalDialog((Window)SnapApp.getDefault().getMainFrame(), DIALOG_TITLE, 33, HELP_ID);
        dialog.setContent((Component)parameterPanel);
        if (dialog.show() == 1) {
            return dialogData;
        }
        return null;
    }

    private static void configureDemNameProperty(PropertySet propertySet, String propertyName, String[] demNames, String defaultValue) {
        PropertyDescriptor descriptor = propertySet.getProperty(propertyName).getDescriptor();
        descriptor.setValueSet(new ValueSet((Object[])demNames));
        descriptor.setDefaultValue((Object)defaultValue);
        descriptor.setNotNull(true);
        descriptor.setNotEmpty(true);
    }

    private static void configureBandNameProperty(PropertySet propertySet, String propertyName, Product product) {
        Property property = propertySet.getProperty(propertyName);
        PropertyDescriptor descriptor = property.getDescriptor();
        descriptor.setNotNull(true);
        descriptor.setNotEmpty(true);
        descriptor.setValidator((Validator)new BandNameValidator(product));
        AddElevationAction.setValidBandName(property, product);
    }

    private static void setValidBandName(Property property, Product product) {
        String bandName;
        String bandNameStub = bandName = (String)property.getValue();
        int i = 2;
        while (product.containsBand(bandName)) {
            bandName = String.format("%s_%d", bandNameStub, i);
            ++i;
        }
        try {
            property.setValue((Object)bandName);
        }
        catch (ValidationException e) {
            throw new IllegalStateException(e);
        }
    }

    private static class DialogData {
        String demName;
        String resamplingMethod;
        boolean outputElevationBand;
        boolean outputDemCorrectedBands;
        String elevationBandName = "elevation";
        String latitudeBandName = "corr_latitude";
        String longitudeBandName = "corr_longitude";

        public DialogData(String demName, String resamplingMethod, boolean ortorectifiable) {
            this.demName = demName;
            this.resamplingMethod = resamplingMethod;
            this.outputElevationBand = true;
            this.outputDemCorrectedBands = ortorectifiable;
        }
    }

    private static class ElevationSourceImage
    extends RasterDataNodeSampleOpImage {
        private final ElevationModel dem;
        private final GeoCoding geoCoding;
        private double noDataValue;

        public ElevationSourceImage(ElevationModel dem, GeoCoding geoCoding, Band band, ResolutionLevel level) {
            super((RasterDataNode)band, level);
            this.dem = dem;
            this.geoCoding = geoCoding;
            this.noDataValue = band.getNoDataValue();
        }

        protected double computeSample(int sourceX, int sourceY) {
            try {
                return this.dem.getElevation(this.geoCoding.getGeoPos(new PixelPos((double)sourceX, (double)sourceY), null));
            }
            catch (Exception e) {
                return this.noDataValue;
            }
        }
    }

    private static class BandNameValidator
    implements Validator {
        private final Product product;

        public BandNameValidator(Product product) {
            this.product = product;
        }

        public void validateValue(Property property, Object value) throws ValidationException {
            String bandName = value.toString().trim();
            if (!ProductNode.isValidNodeName((String)bandName)) {
                throw new ValidationException(MessageFormat.format("The band name ''{0}'' appears not to be valid.\nPlease choose another one.", bandName));
            }
            if (this.product.containsBand(bandName)) {
                throw new ValidationException(MessageFormat.format("The selected product already contains a band named ''{0}''.\nPlease choose another one.", bandName));
            }
        }
    }

    private static class SingleSelectionListComponentAdapter
    extends ComponentAdapter
    implements ListSelectionListener,
    PropertyChangeListener {
        private final JList list;

        public SingleSelectionListComponentAdapter(JList list) {
            this.list = list;
            list.setSelectionMode(0);
        }

        public JComponent[] getComponents() {
            return new JComponent[]{this.list};
        }

        public void bindComponents() {
            this.updateListModel();
            this.getPropertyDescriptor().addAttributeChangeListener((PropertyChangeListener)this);
            this.list.addListSelectionListener(this);
        }

        public void unbindComponents() {
            this.getPropertyDescriptor().removeAttributeChangeListener((PropertyChangeListener)this);
            this.list.removeListSelectionListener(this);
        }

        public void adjustComponents() {
            Object value = this.getBinding().getPropertyValue();
            if (value != null) {
                this.list.setSelectedValue(value, true);
            } else {
                this.list.clearSelection();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == this.getPropertyDescriptor() && evt.getPropertyName().equals("valueSet")) {
                this.updateListModel();
            }
        }

        private PropertyDescriptor getPropertyDescriptor() {
            return this.getBinding().getContext().getPropertySet().getDescriptor(this.getBinding().getPropertyName());
        }

        private void updateListModel() {
            ValueSet valueSet = this.getPropertyDescriptor().getValueSet();
            if (valueSet != null) {
                this.list.setListData(valueSet.getItems());
                this.adjustComponents();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (event.getValueIsAdjusting()) {
                return;
            }
            if (this.getBinding().isAdjustingComponents()) {
                return;
            }
            Property property = this.getBinding().getContext().getPropertySet().getProperty(this.getBinding().getPropertyName());
            Object selectedValue = this.list.getSelectedValue();
            try {
                property.setValue(selectedValue);
                this.getBinding().clearProblem();
            }
            catch (ValidationException e) {
                this.getBinding().reportProblem((BindingException)e);
            }
        }
    }
}

