/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dem.dataio.ace;

import java.io.IOException;
import org.esa.snap.core.dataop.dem.AbstractElevationModelDescriptor;
import org.esa.snap.core.dataop.dem.ElevationModel;
import org.esa.snap.core.dataop.resamp.Resampling;
import org.esa.snap.dem.dataio.ace.ACEElevationModel;

public class ACEElevationModelDescriptor
extends AbstractElevationModelDescriptor {
    private static final String NAME = "ACE30";
    public static final int NUM_X_TILES = 24;
    public static final int NUM_Y_TILES = 12;
    public static final int DEGREE_RES = 15;
    public static final int PIXEL_RES = 1800;
    public static final int NO_DATA_VALUE = -500;
    public static final int RASTER_WIDTH = 43200;
    public static final int RASTER_HEIGHT = 21600;

    public String getName() {
        return NAME;
    }

    public int getNumXTiles() {
        return 24;
    }

    public int getNumYTiles() {
        return 12;
    }

    public float getNoDataValue() {
        return -500.0f;
    }

    public int getRasterWidth() {
        return 43200;
    }

    public int getRasterHeight() {
        return 21600;
    }

    public int getTileWidthInDegrees() {
        return 15;
    }

    public int getTileWidth() {
        return 1800;
    }

    public boolean canBeDownloaded() {
        return true;
    }

    public ElevationModel createDem(Resampling resamplingMethod) {
        try {
            return new ACEElevationModel(this, resamplingMethod);
        }
        catch (IOException e) {
            return null;
        }
    }
}

