/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.raster.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.HashMap;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;

@OperatorMetadata(alias="LinearToFromdB", category="Raster/Data Conversion", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2015 by Array Systems Computing Inc.", description="Converts bands to/from dB")
public final class LinearTodBOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The list of source bands.", alias="sourceBands", rasterDataNodeType=Band.class, label="Source Bands")
    private String[] sourceBandNames;
    private static final String dBStr = "_db";
    private static final double underFlowFloat = 1.0E-30;
    private static final String PRODUCT_SUFFIX = "_dB";
    private final HashMap<String, String[]> targetBandNameToSourceBandName = new HashMap();

    public void initialize() throws OperatorException {
        try {
            this.createTargetProduct();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        try {
            Tile sourceRaster1;
            Band sourceBand1;
            Rectangle targetTileRectangle = targetTile.getRectangle();
            int x0 = targetTileRectangle.x;
            int y0 = targetTileRectangle.y;
            int w = targetTileRectangle.width;
            int h = targetTileRectangle.height;
            Tile sourceRaster2 = null;
            String[] srcBandNames = this.targetBandNameToSourceBandName.get(targetBand.getName());
            if (srcBandNames.length == 1) {
                sourceBand1 = this.sourceProduct.getBand(srcBandNames[0]);
                sourceRaster1 = this.getSourceTile((RasterDataNode)sourceBand1, targetTileRectangle);
                if (sourceRaster1 == null) {
                    throw new OperatorException("Cannot get source tile");
                }
            } else {
                sourceBand1 = this.sourceProduct.getBand(srcBandNames[0]);
                Band sourceBand2 = this.sourceProduct.getBand(srcBandNames[1]);
                sourceRaster1 = this.getSourceTile((RasterDataNode)sourceBand1, targetTileRectangle);
                sourceRaster2 = this.getSourceTile((RasterDataNode)sourceBand2, targetTileRectangle);
                if (sourceRaster1 == null || sourceRaster2 == null) {
                    throw new OperatorException("Cannot get source tile");
                }
            }
            boolean linearTodB = !sourceBand1.getUnit().endsWith("db");
            Double nodatavalue = sourceBand1.getNoDataValue();
            ProductData trgData = targetTile.getDataBuffer();
            ProductData srcData1 = sourceRaster1.getDataBuffer();
            ProductData srcData2 = null;
            if (sourceRaster2 != null) {
                srcData2 = sourceRaster2.getDataBuffer();
            }
            TileIndex trgIndex = new TileIndex(targetTile);
            int maxY = y0 + h;
            int maxX = x0 + w;
            for (int y = y0; y < maxY; ++y) {
                trgIndex.calculateStride(y);
                for (int x = x0; x < maxX; ++x) {
                    double value;
                    int index = trgIndex.getIndex(x);
                    if (srcData2 != null) {
                        double i = srcData1.getElemDoubleAt(index);
                        double q = srcData2.getElemDoubleAt(index);
                        value = i * i + q * q;
                    } else {
                        value = srcData1.getElemDoubleAt(index);
                    }
                    if (nodatavalue.equals(value)) {
                        trgData.setElemDoubleAt(index, value);
                        continue;
                    }
                    value = linearTodB ? (value < 1.0E-30 ? -1.0E-30 : 10.0 * Math.log10(value)) : Math.pow(10.0, value / 10.0);
                    trgData.setElemDoubleAt(index, value);
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
        finally {
            pm.done();
        }
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName() + PRODUCT_SUFFIX, this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        this.addSelectedBands();
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
    }

    private void addSelectedBands() throws OperatorException {
        Band[] sourceBands = OperatorUtils.getSourceBands((Product)this.sourceProduct, (String[])this.sourceBandNames, (boolean)false);
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
        boolean isPolsar = absRoot.getAttributeInt("polsar_data", 0) == 1;
        for (int i = 0; i < sourceBands.length; ++i) {
            String targetBandName;
            String[] srcBandNames;
            Band srcBand = sourceBands[i];
            String unit = srcBand.getUnit();
            if (unit == null) {
                unit = "amplitude";
            }
            String targetUnit = "";
            if (unit.equals("real") || unit.equals("imaginary")) {
                String pol;
                if (i == sourceBands.length - 1) {
                    throw new OperatorException("Real and imaginary bands should be selected in pairs");
                }
                String nextUnit = sourceBands[i + 1].getUnit();
                if (!(nextUnit != null && (unit.equals("real") && nextUnit.equals("imaginary") || unit.equals("imaginary") && nextUnit.equals("real")))) {
                    throw new OperatorException("Real and imaginary bands should be selected in pairs");
                }
                srcBandNames = new String[]{srcBand.getName(), sourceBands[i + 1].getName()};
                targetBandName = "Intensity";
                String suff = OperatorUtils.getSuffixFromBandName((String)srcBandNames[0]);
                if (suff != null) {
                    targetBandName = targetBandName + "_" + suff;
                }
                if ((pol = OperatorUtils.getBandPolarization((String)srcBandNames[0], (MetadataElement)absRoot)) != null && !pol.isEmpty() && !targetBandName.toLowerCase().contains(pol)) {
                    targetBandName = targetBandName + "_" + pol.toUpperCase();
                }
                if (isPolsar) {
                    String pre = OperatorUtils.getPrefixFromBandName((String)srcBandNames[0]);
                    targetBandName = "Intensity_" + pre;
                }
                targetBandName = targetBandName + dBStr;
                targetUnit = "intensity_db";
                ++i;
            } else {
                String srcBandName = srcBand.getName();
                srcBandNames = new String[]{srcBandName};
                if (unit.endsWith("db")) {
                    targetBandName = srcBandName.endsWith(dBStr) ? srcBandName.substring(0, srcBandName.lastIndexOf(dBStr)) : srcBandName;
                    targetUnit = unit.substring(0, unit.indexOf(dBStr));
                } else {
                    targetBandName = srcBandName + dBStr;
                    targetUnit = unit + dBStr;
                }
            }
            if (this.targetProduct.getBand(targetBandName) != null) continue;
            Band targetBand = new Band(targetBandName, 30, srcBand.getRasterWidth(), srcBand.getRasterHeight());
            targetBand.setUnit(targetUnit);
            targetBand.setDescription(srcBand.getDescription());
            targetBand.setNoDataValue(srcBand.getNoDataValue());
            targetBand.setNoDataValueUsed(true);
            this.targetProduct.addBand(targetBand);
            this.targetBandNameToSourceBandName.put(targetBandName, srcBandNames);
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(LinearTodBOp.class);
        }
    }
}

