/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.bigtiff.internal;

import java.io.IOException;
import javax.imageio.stream.ImageOutputStream;
import org.esa.snap.dataio.bigtiff.internal.TiffShort;
import org.esa.snap.dataio.bigtiff.internal.TiffType;
import org.esa.snap.dataio.bigtiff.internal.TiffUInt;
import org.esa.snap.dataio.bigtiff.internal.TiffValue;

public class TiffDirectoryEntry {
    public static final short BYTES_PER_ENTRY = 12;
    private TiffShort tag;
    private TiffShort type;
    private TiffUInt count;
    private TiffValue[] values;
    private TiffUInt valuesOffset;

    public TiffDirectoryEntry(TiffShort tiffTag, TiffValue value) {
        this(tiffTag, new TiffValue[]{value});
    }

    public TiffDirectoryEntry(TiffShort tiffTag, TiffValue[] values) {
        this.type = TiffType.getType(values);
        this.tag = tiffTag;
        this.count = this.getCount(values);
        this.values = values;
    }

    public TiffShort getTag() {
        return this.tag;
    }

    public TiffUInt getCount() {
        return this.count;
    }

    public TiffShort getType() {
        return this.type;
    }

    public TiffValue[] getValues() {
        return this.values;
    }

    public void write(ImageOutputStream ios) throws IOException {
        if (this.mustValuesBeReferenced() && this.valuesOffset == null) {
            throw new IllegalStateException("no value offset given");
        }
        this.tag.write(ios);
        this.type.write(ios);
        this.count.write(ios);
        if (this.valuesOffset == null) {
            this.writeValuesInsideEnty(ios);
        } else {
            this.writeValuesReferenced(ios);
        }
    }

    private void writeValuesInsideEnty(ImageOutputStream ios) throws IOException {
        this.writeValues(ios);
        this.fillEntry(ios);
    }

    private void fillEntry(ImageOutputStream ios) throws IOException {
        long bytesToWrite = 4L - this.getValuesSizeInBytes();
        int i = 0;
        while ((long)i < bytesToWrite) {
            ios.writeByte(0);
            ++i;
        }
    }

    private long getReferencedValuesSizeInBytes() {
        if (this.mustValuesBeReferenced()) {
            return this.getValuesSizeInBytes();
        }
        return 0L;
    }

    public void setValuesOffset(long offset) {
        this.valuesOffset = new TiffUInt(offset);
    }

    public long getSize() {
        return 12L + this.getReferencedValuesSizeInBytes();
    }

    public boolean mustValuesBeReferenced() {
        return this.getValuesSizeInBytes() > 4L;
    }

    public long getValuesSizeInBytes() {
        int size = 0;
        for (TiffValue _value : this.values) {
            size += _value.getSizeInBytes();
        }
        return size;
    }

    private void writeValuesReferenced(ImageOutputStream ios) throws IOException {
        this.valuesOffset.write(ios);
        ios.seek(this.valuesOffset.getValue());
        this.writeValues(ios);
    }

    private void writeValues(ImageOutputStream ios) throws IOException {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i].write(ios);
        }
    }

    public TiffUInt getValuesOffset() {
        return this.valuesOffset;
    }

    private TiffUInt getCount(TiffValue[] values) {
        if (this.type.getValue() != TiffType.ASCII.getValue()) {
            return new TiffUInt(values.length);
        }
        long size = 0L;
        for (TiffValue value : values) {
            size += (long)value.getSizeInBytes();
        }
        return new TiffUInt(size);
    }
}

