/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.pixex.visat;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.esa.snap.core.dataio.placemark.PlacemarkIO;
import org.esa.snap.core.datamodel.PinDescriptor;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.PlacemarkDescriptor;
import org.esa.snap.core.util.PropertyMap;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.pixex.visat.CoordinateTableModel;
import org.esa.snap.ui.AppContext;

class AddPlacemarkFileAction
extends AbstractAction {
    private static final String LAST_OPEN_PLACEMARK_DIR = "beam.pixex.lastOpenPlacemarkDir";
    private final CoordinateTableModel tableModel;
    private final AppContext appContext;
    private final JComponent parentComponent;

    AddPlacemarkFileAction(AppContext appContext, CoordinateTableModel tableModel, JPanel parentComponent) {
        super("Add coordinates from file...");
        this.tableModel = tableModel;
        this.appContext = appContext;
        this.parentComponent = parentComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        PropertyMap preferences = this.appContext.getPreferences();
        String lastDir = preferences.getPropertyString(LAST_OPEN_PLACEMARK_DIR, SystemUtils.getUserHomeDir().getPath());
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.addChoosableFileFilter((FileFilter)PlacemarkIO.createPlacemarkFileFilter());
        fileChooser.setFileFilter((FileFilter)PlacemarkIO.createTextFileFilter());
        fileChooser.setCurrentDirectory(new File(lastDir));
        int answer = fileChooser.showDialog(this.parentComponent, "Select");
        if (answer == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            preferences.setPropertyString(LAST_OPEN_PLACEMARK_DIR, selectedFile.getParent());
            FileReader reader = null;
            try {
                reader = new FileReader(selectedFile);
                List placemarks = PlacemarkIO.readPlacemarks((Reader)reader, null, (PlacemarkDescriptor)PinDescriptor.getInstance());
                for (Placemark placemark : placemarks) {
                    this.tableModel.addPlacemark(placemark);
                }
            }
            catch (IOException ioe) {
                this.appContext.handleError(String.format("Error occurred while reading file: %s", selectedFile), (Throwable)ioe);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

