/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.utils;

import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.esa.snap.rcp.SnapApp;

public class ProductOpener {
    public static void openProducts(File[] productFiles) {
        ExecutorService es = Executors.newSingleThreadExecutor();
        for (File productFile : productFiles) {
            if (!productFile.exists()) continue;
            es.submit(new Opener(productFile));
        }
    }

    private static class Opener
    implements Runnable {
        private final File productFile;

        public Opener(File file) {
            this.productFile = file;
        }

        @Override
        public void run() {
            try {
                org.esa.snap.rcp.actions.file.ProductOpener opener = new org.esa.snap.rcp.actions.file.ProductOpener();
                opener.setFiles(new File[]{this.productFile});
                opener.setMultiSelectionEnabled(true);
                opener.openProduct();
            }
            catch (Exception e) {
                SnapApp.getDefault().handleError("Not able to open product:\n" + this.productFile.getPath(), (Throwable)e);
            }
        }
    }
}

