/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews.timeline;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Map;
import java.util.TreeSet;
import org.esa.snap.productlibrary.rcp.toolviews.model.DatabaseStatistics;
import org.esa.snap.productlibrary.rcp.toolviews.timeline.AbstractTimelinePlot;

class TimelinePlot
extends AbstractTimelinePlot {
    TimelinePlot(DatabaseStatistics stats) {
        super(stats);
    }

    @Override
    protected void paintPlot(Graphics2D g2d) {
        Map<Integer, DatabaseStatistics.YearData> yearDataMap = this.stats.getYearDataMap();
        TreeSet<Integer> years = new TreeSet<Integer>(yearDataMap.keySet());
        int numYears = years.size();
        int maxDayCnt = this.stats.getOverallMaxDayCnt();
        int w = this.getWidth();
        int h = this.getHeight() - 15;
        float interval = (float)w / (float)numYears;
        float halfInterval = interval / 2.0f;
        int y = this.getHeight() - 2;
        float x = halfInterval;
        for (Integer year : years) {
            g2d.setColor(Color.BLACK);
            g2d.drawString(String.valueOf(year), x - 20.0f, (float)y);
            DatabaseStatistics.YearData data = yearDataMap.get(year);
            g2d.setColor(Color.BLACK);
            g2d.drawLine((int)(x - halfInterval), h - 10, (int)(x - halfInterval), h + 5);
            for (int d = 1; d < 366; ++d) {
                float pctX = (float)d / 365.0f;
                float newH = (float)data.dayOfYearMap.get(d).intValue() / (float)maxDayCnt * (float)h;
                TimelinePlot.drawBar(g2d, (int)(x - halfInterval + pctX * interval), (int)((float)h - newH), 1, (int)newH, h);
            }
            x += interval;
        }
    }
}

