/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews.listviews;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import org.esa.snap.engine_utilities.db.ProductEntry;
import org.esa.snap.productlibrary.rcp.toolviews.ProductLibraryActions;
import org.esa.snap.productlibrary.rcp.toolviews.listviews.ListView;
import org.esa.snap.productlibrary.rcp.toolviews.model.ProductEntryTableModel;
import org.esa.snap.productlibrary.rcp.toolviews.model.SortingDecorator;

public class ProductEntryTable
extends JTable
implements ListView {
    public ProductEntryTable(final ProductLibraryActions productLibraryActions) {
        this.setAutoResizeMode(3);
        this.setSelectionMode(2);
        this.setComponentPopupMenu(productLibraryActions.createEntryTablePopup());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int clickCount = e.getClickCount();
                if (clickCount == 2) {
                    productLibraryActions.performOpenAction();
                } else if (clickCount == 1) {
                    ProductEntryTable.this.notifySelectionChanged();
                }
            }
        });
    }

    @Override
    public void setProductEntryList(ProductEntry[] productEntryList) {
        ProductEntryTableModel tableModel = new ProductEntryTableModel(productEntryList, false);
        this.setModel(new SortingDecorator(tableModel, this.getTableHeader()));
        this.setColumnModel(tableModel.getColumnModel());
    }

    @Override
    public File[] getSelectedFiles() {
        int[] selectedRows = this.getSelectedRows();
        File[] selectedFiles = new File[selectedRows.length];
        for (int i = 0; i < selectedRows.length; ++i) {
            Object entry = this.getValueAt(selectedRows[i], 0);
            if (!(entry instanceof ProductEntry)) continue;
            selectedFiles[i] = ((ProductEntry)entry).getFile();
        }
        return selectedFiles;
    }

    @Override
    public ProductEntry[] getSelectedProductEntries() {
        int[] selectedRows = this.getSelectedRows();
        ProductEntry[] selectedEntries = new ProductEntry[selectedRows.length];
        for (int i = 0; i < selectedRows.length; ++i) {
            Object entry = this.getValueAt(selectedRows[i], 0);
            if (!(entry instanceof ProductEntry)) continue;
            selectedEntries[i] = (ProductEntry)entry;
        }
        return selectedEntries;
    }

    @Override
    public ProductEntry getEntryOverMouse() {
        Point pos = this.getMousePosition();
        int row = 0;
        if (pos != null) {
            row = this.rowAtPoint(pos);
        }
        return (ProductEntry)this.getValueAt(row, 0);
    }

    @Override
    public void sort(SortingDecorator.SORT_BY sortBy) {
        TableModel model = this.getModel();
        if (model instanceof SortingDecorator) {
            SortingDecorator sortedModel = (SortingDecorator)model;
            sortedModel.sortBy(sortBy);
        }
    }

    @Override
    public int getTotalCount() {
        return this.getRowCount();
    }

    @Override
    public int getSelectionCount() {
        return this.getSelectedRowCount();
    }
}

