/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.internal;

import com.bc.ceres.binio.CollectionData;
import com.bc.ceres.binio.DataAccessException;
import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.SequenceType;
import com.bc.ceres.binio.VarSequenceType;
import com.bc.ceres.binio.internal.AbstractCollection;
import com.bc.ceres.binio.internal.CompoundInstance;
import com.bc.ceres.binio.internal.SequenceInstance;
import java.io.IOException;
import java.text.MessageFormat;

abstract class AbstractSequence
extends AbstractCollection
implements SequenceInstance {
    private final SequenceType sequenceType;

    protected AbstractSequence(DataContext context, CollectionData parent, SequenceType sequenceType) {
        super(context, parent);
        this.sequenceType = sequenceType;
    }

    @Override
    public SequenceType getType() {
        return this.sequenceType;
    }

    @Override
    @Deprecated
    public final SequenceType getSequenceType() {
        return this.getType();
    }

    @Override
    public CompoundInstance getCompound() {
        throw new DataAccessException(this.getTypeErrorMsg());
    }

    @Override
    public SequenceInstance getSequence() {
        return this;
    }

    SequenceType resolveSequenceType() throws IOException {
        SequenceType unresolvedSequenceType = this.getType();
        if (unresolvedSequenceType.isSizeKnown()) {
            return unresolvedSequenceType;
        }
        SequenceType resolvedSequenceType = AbstractSequence.resolveSequenceType(this.getParent(), unresolvedSequenceType);
        if (resolvedSequenceType == null || !resolvedSequenceType.isSizeKnown()) {
            String msg = MessageFormat.format("Failed to resolve type ''{0}''", unresolvedSequenceType);
            throw new DataAccessException(msg);
        }
        return resolvedSequenceType;
    }

    static SequenceType resolveSequenceType(CollectionData parent, SequenceType sequenceType) throws IOException {
        SequenceType resolvedSequenceType;
        if (sequenceType instanceof VarSequenceType) {
            resolvedSequenceType = ((VarSequenceType)sequenceType).resolve(parent);
            if (resolvedSequenceType == null) {
                throw new IllegalStateException("Sequence type resolved to null: " + sequenceType);
            }
            if (resolvedSequenceType == sequenceType) {
                throw new IllegalStateException("Sequence type resolved to itself: " + sequenceType);
            }
            if (resolvedSequenceType instanceof VarSequenceType && (resolvedSequenceType = AbstractSequence.resolveSequenceType(parent, resolvedSequenceType)) instanceof VarSequenceType) {
                throw new IllegalStateException("Sequence type resolved to an unresolvable type: " + resolvedSequenceType);
            }
        } else {
            resolvedSequenceType = sequenceType;
        }
        return resolvedSequenceType;
    }
}

