/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util.kmz;

import com.bc.ceres.core.Assert;

public abstract class KmlFeature {
    private String kmlElementName;
    private final String name;
    private final String description;

    protected KmlFeature(String kmlElementName, String name, String description) {
        Assert.notNull((Object)kmlElementName, (String)"xmlTagName");
        Assert.notNull((Object)name, (String)"name");
        this.kmlElementName = kmlElementName;
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public final void createKml(StringBuilder sb) {
        sb.append("<").append(this.kmlElementName).append(">");
        sb.append("<name>");
        sb.append(this.getName());
        sb.append("</name>");
        String description1 = this.getDescription();
        if (description1 != null && !description1.isEmpty()) {
            sb.append("<description>");
            sb.append(description1);
            sb.append("</description>");
        }
        this.createKmlSpecifics(sb);
        sb.append("</").append(this.kmlElementName).append(">");
    }

    protected abstract void createKmlSpecifics(StringBuilder var1);
}

