/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.util;

import com.bc.ceres.core.runtime.Version;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.runtime.EngineConfig;

public class VersionChecker {
    public static final String PK_CHECK_INTERVAL = "snap.versionCheck.interval";
    private static final String PK_LAST_DATE = "snap.versionCheck.lastDate";
    private static final String VERSION_FILE_NAME = "VERSION.txt";
    private static final String REMOTE_VERSION_FILE_URL = "http://step.esa.int/downloads/VERSION.txt";
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ISO_DATE_TIME;
    private static VersionChecker instance = new VersionChecker();
    private final InputStream localVersionStream;
    private final InputStream remoteVersionStream;
    private final AtomicReference<Version> localVersion = new AtomicReference();
    private final AtomicReference<Version> remoteVersion = new AtomicReference();
    private final Preferences preferences;

    public static VersionChecker getInstance() {
        return instance;
    }

    private VersionChecker() {
        this(null, null);
    }

    VersionChecker(InputStream localVersionStream, InputStream remoteVersionStream) {
        this.localVersionStream = localVersionStream;
        this.remoteVersionStream = remoteVersionStream;
        EngineConfig config = EngineConfig.instance().load();
        this.preferences = config.preferences();
    }

    public boolean mustCheck() {
        String dateText = this.preferences.get(PK_LAST_DATE, null);
        return VersionChecker.mustCheck(CHECK.valueOf(this.preferences.get(PK_CHECK_INTERVAL, CHECK.WEEKLY.name())), dateText != null ? LocalDateTime.parse(dateText, DATE_FORMATTER) : null);
    }

    public boolean checkForNewRelease() {
        boolean newRelease = false;
        try {
            Version localVersion = this.getLocalVersion();
            if (localVersion == null) {
                SystemUtils.LOG.log(Level.WARNING, "Not able to check for new SNAP version. Local version could not be retrieved.");
                return false;
            }
            Version remoteVersion = this.getRemoteVersion();
            if (remoteVersion == null) {
                SystemUtils.LOG.log(Level.WARNING, "Not able to check for new SNAP version. Remote version could not be retrieved.");
                return false;
            }
            newRelease = this.compareVersions();
        }
        catch (IOException e) {
            SystemUtils.LOG.log(Level.WARNING, "Not able to check for new SNAP version.", e);
        }
        return newRelease;
    }

    public void setChecked() {
        this.preferences.put(PK_LAST_DATE, LocalDateTime.now().format(DATE_FORMATTER));
        try {
            this.preferences.flush();
        }
        catch (BackingStoreException e) {
            SystemUtils.LOG.log(Level.WARNING, "Not able to store preferences.", e);
        }
    }

    public Version getLocalVersion() {
        if (this.localVersion.get() == null) {
            Path versionFile = SystemUtils.getApplicationHomeDir().toPath().resolve(VERSION_FILE_NAME);
            try {
                this.localVersion.set(VersionChecker.readVersionFromStream(this.localVersionStream == null ? Files.newInputStream(versionFile, new OpenOption[0]) : this.localVersionStream));
            }
            catch (IOException e) {
                SystemUtils.LOG.log(Level.WARNING, "Not able to check for new SNAP version. Local version could not be retrieved.", e);
                return null;
            }
        }
        return this.localVersion.get();
    }

    public Version getRemoteVersion() {
        if (this.remoteVersion.get() == null) {
            try {
                this.remoteVersion.set(VersionChecker.readVersionFromStream(this.remoteVersionStream == null ? new URL(REMOTE_VERSION_FILE_URL).openStream() : this.remoteVersionStream));
            }
            catch (IOException e) {
                SystemUtils.LOG.log(Level.WARNING, "Not able to check for new SNAP version. Remote version could not be retrieved.", e);
                return null;
            }
        }
        return this.remoteVersion.get();
    }

    static boolean mustCheck(CHECK checkInterval, LocalDateTime lastDate) {
        if (CHECK.NEVER.equals((Object)checkInterval)) {
            return false;
        }
        if (CHECK.ON_START.equals((Object)checkInterval)) {
            return true;
        }
        if (lastDate == null) {
            return true;
        }
        Duration duration = Duration.between(LocalDateTime.now(), lastDate);
        long daysAgo = duration.toDays();
        return checkInterval.exceedsInterval(daysAgo);
    }

    private boolean compareVersions() throws IOException {
        Version localVersion;
        Version remoteVersion = this.getRemoteVersion();
        return remoteVersion.compareTo((Object)(localVersion = this.getLocalVersion())) > 0;
    }

    private static Version readVersionFromStream(InputStream inputStream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line = reader.readLine();
            if (line != null) {
                Version version = Version.parseVersion((String)line.toUpperCase());
                return version;
            }
        }
        return null;
    }

    public static enum CHECK {
        ON_START(0),
        DAILY(1),
        WEEKLY(7),
        MONTHLY(30),
        NEVER(-1);

        private final int days;

        private CHECK(int days) {
            this.days = days;
        }

        boolean exceedsInterval(long daysAgo) {
            return Math.abs(daysAgo) > (long)this.days;
        }
    }
}

