/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.dataop.dem;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.esa.snap.core.dataio.ProductIOPlugInManager;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.dataop.dem.ElevationFile;
import org.esa.snap.core.dataop.dem.ElevationModel;
import org.esa.snap.core.dataop.dem.ElevationModelDescriptor;
import org.esa.snap.core.dataop.dem.ElevationTile;
import org.esa.snap.core.dataop.resamp.Resampling;

public abstract class BaseElevationModel
implements ElevationModel,
Resampling.Raster {
    private final int NUM_X_TILES;
    protected final int NUM_Y_TILES;
    protected final int NUM_PIXELS_PER_TILE;
    private final double NUM_PIXELS_PER_TILEinv;
    private final double NO_DATA_VALUE;
    protected final int DEGREE_RES;
    private final int RASTER_WIDTH;
    protected final int RASTER_HEIGHT;
    protected final double DEGREE_RES_BY_NUM_PIXELS_PER_TILE;
    protected final double DEGREE_RES_BY_NUM_PIXELS_PER_TILEinv;
    protected final ElevationModelDescriptor descriptor;
    private final ElevationFile[][] elevationFiles;
    private final Resampling resampling;
    private final Resampling.Raster resamplingRaster;
    private final List<ElevationTile> elevationTileCache = new ArrayList<ElevationTile>(20);
    private int maxCacheSize = 60;

    public BaseElevationModel(ElevationModelDescriptor descriptor, Resampling resamplingMethod) {
        this.descriptor = descriptor;
        if (resamplingMethod == null) {
            resamplingMethod = Resampling.BILINEAR_INTERPOLATION;
        }
        this.resampling = resamplingMethod;
        this.resamplingRaster = this;
        this.NUM_X_TILES = descriptor.getNumXTiles();
        this.NUM_Y_TILES = descriptor.getNumYTiles();
        this.NO_DATA_VALUE = descriptor.getNoDataValue();
        this.NUM_PIXELS_PER_TILE = descriptor.getTileWidth();
        this.NUM_PIXELS_PER_TILEinv = 1.0 / (double)this.NUM_PIXELS_PER_TILE;
        this.DEGREE_RES = descriptor.getTileWidthInDegrees();
        this.RASTER_WIDTH = this.NUM_X_TILES * this.NUM_PIXELS_PER_TILE;
        this.RASTER_HEIGHT = this.NUM_Y_TILES * this.NUM_PIXELS_PER_TILE;
        this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE = (double)this.DEGREE_RES / (double)this.NUM_PIXELS_PER_TILE;
        this.DEGREE_RES_BY_NUM_PIXELS_PER_TILEinv = 1.0 / this.DEGREE_RES_BY_NUM_PIXELS_PER_TILE;
        this.elevationFiles = this.createElevationFiles();
    }

    @Override
    public Resampling getResampling() {
        return this.resampling;
    }

    @Override
    public ElevationModelDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected void setMaxCacheSize(int size) {
        this.maxCacheSize = size;
    }

    @Override
    public final double getElevation(GeoPos geoPos) throws Exception {
        double pixelY;
        if (geoPos.lon > 180.0) {
            geoPos.lon -= 360.0;
        }
        if ((pixelY = this.getIndexY(geoPos)) < 0.0 || Double.isNaN(pixelY)) {
            return this.NO_DATA_VALUE;
        }
        Resampling.Index newIndex = this.resampling.createIndex();
        this.resampling.computeCornerBasedIndex(this.getIndexX(geoPos), pixelY, this.RASTER_WIDTH, this.RASTER_HEIGHT, newIndex);
        double elevation = this.resampling.resample(this.resamplingRaster, newIndex);
        return Double.isNaN(elevation) ? this.NO_DATA_VALUE : elevation;
    }

    public abstract double getIndexX(GeoPos var1);

    public abstract double getIndexY(GeoPos var1);

    @Override
    public abstract GeoPos getGeoPos(PixelPos var1);

    @Override
    public PixelPos getIndex(GeoPos geoPos) {
        return new PixelPos(this.getIndexX(geoPos), this.getIndexY(geoPos));
    }

    @Override
    public int getWidth() {
        return this.RASTER_WIDTH;
    }

    @Override
    public int getHeight() {
        return this.RASTER_HEIGHT;
    }

    public void updateCache(ElevationTile tile) {
        this.elevationTileCache.remove(tile);
        this.elevationTileCache.add(0, tile);
        while (this.elevationTileCache.size() > this.maxCacheSize) {
            int index = this.elevationTileCache.size() - 1;
            ElevationTile lastTile = this.elevationTileCache.get(index);
            if (lastTile != null) {
                lastTile.clearCache();
            }
            this.elevationTileCache.remove(index);
        }
    }

    @Override
    public final double getSample(double pixelX, double pixelY) throws Exception {
        int tileXIndex = (int)(pixelX * this.NUM_PIXELS_PER_TILEinv);
        int tileYIndex = (int)(pixelY * this.NUM_PIXELS_PER_TILEinv);
        ElevationTile tile = this.elevationFiles[tileXIndex][tileYIndex].getTile();
        if (tile == null) {
            return Double.NaN;
        }
        double sample = tile.getSample((int)(pixelX - (double)(tileXIndex * this.NUM_PIXELS_PER_TILE)), (int)(pixelY - (double)(tileYIndex * this.NUM_PIXELS_PER_TILE)));
        return sample == this.NO_DATA_VALUE ? Double.NaN : sample;
    }

    @Override
    public final boolean getSamples(int[] xArray, int[] yArray, double[][] samples) throws Exception {
        boolean allValid = true;
        int i = 0;
        for (int y : yArray) {
            int tileYIndex = (int)((double)y * this.NUM_PIXELS_PER_TILEinv);
            int pixelY = y - tileYIndex * this.NUM_PIXELS_PER_TILE;
            int j = 0;
            for (int x : xArray) {
                int tileXIndex = (int)((double)x * this.NUM_PIXELS_PER_TILEinv);
                ElevationTile tile = this.elevationFiles[tileXIndex][tileYIndex].getTile();
                if (tile == null) {
                    samples[i][j] = Double.NaN;
                    allValid = false;
                    ++j;
                    continue;
                }
                samples[i][j] = tile.getSample(x - tileXIndex * this.NUM_PIXELS_PER_TILE, pixelY);
                if (samples[i][j] == this.NO_DATA_VALUE) {
                    samples[i][j] = Double.NaN;
                    allValid = false;
                }
                ++j;
            }
            ++i;
        }
        return allValid;
    }

    @Override
    public void dispose() {
        for (ElevationTile tile : this.elevationTileCache) {
            if (tile == null) continue;
            tile.dispose();
        }
        this.elevationTileCache.clear();
        ElevationFile[][] elevationFileArray = this.elevationFiles;
        int n = elevationFileArray.length;
        for (int i = 0; i < n; ++i) {
            ElevationFile[] elevationFile;
            for (ElevationFile anElevationFile : elevationFile = elevationFileArray[i]) {
                if (anElevationFile == null) continue;
                anElevationFile.dispose();
            }
        }
    }

    protected abstract void createElevationFile(ElevationFile[][] var1, int var2, int var3, File var4);

    protected static ProductReaderPlugIn getReaderPlugIn(String formatName) {
        Iterator<ProductReaderPlugIn> readerPlugIns = ProductIOPlugInManager.getInstance().getReaderPlugIns(formatName);
        return readerPlugIns.next();
    }

    private ElevationFile[][] createElevationFiles() {
        ElevationFile[][] elevationFiles = new ElevationFile[this.NUM_X_TILES][this.NUM_Y_TILES];
        File demInstallDir = this.descriptor.getDemInstallDir();
        for (int x = 0; x < elevationFiles.length; ++x) {
            for (int y = 0; y < elevationFiles[x].length; ++y) {
                this.createElevationFile(elevationFiles, x, y, demInstallDir);
            }
        }
        return elevationFiles;
    }
}

