/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.datamodel;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import java.awt.Dimension;
import java.awt.image.RenderedImage;
import java.io.IOException;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductVisitor;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VirtualBandMultiLevelImage;
import org.esa.snap.core.dataop.barithm.BandArithmetic;
import org.esa.snap.core.image.ResolutionLevel;
import org.esa.snap.core.image.VirtualBandOpImage;
import org.esa.snap.core.jexp.Term;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.core.util.StringUtils;

public class VirtualBand
extends Band {
    public static final String PROPERTY_NAME_EXPRESSION = "expression";
    private String expression;

    public VirtualBand(String name, int dataType, int width, int height, String expression) {
        super(name, dataType, width, height);
        this.setSpectralBandIndex(-1);
        this.setSynthetic(true);
        this.expression = expression;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        if (expression != null && !this.expression.equals(expression)) {
            this.expression = expression;
            if (this.isSourceImageSet()) {
                this.setSourceImage((MultiLevelImage)null);
            }
            this.resetValidMask();
            this.setStx(null);
            this.setImageInfo(null);
            this.setModified(true);
            this.fireProductNodeChanged(PROPERTY_NAME_EXPRESSION);
            this.fireProductNodeChanged("data");
            this.fireProductNodeDataChanged();
        }
    }

    @Override
    public void updateExpression(String oldExternalName, String newExternalName) {
        String updatedExpression = StringUtils.replaceWord(this.expression, oldExternalName, newExternalName);
        if (!this.expression.equals(updatedExpression)) {
            this.expression = updatedExpression;
            this.setModified(true);
        }
        super.updateExpression(oldExternalName, newExternalName);
    }

    @Override
    public void setPixelInt(int x, int y, int pixelValue) {
        throw new IllegalStateException("set not supported for virtual band");
    }

    @Override
    public void setPixelFloat(int x, int y, float pixelValue) {
        throw new IllegalStateException("set not supported for virtual band");
    }

    @Override
    public void setPixelDouble(int x, int y, double pixelValue) {
        throw new IllegalStateException("set not supported for virtual band");
    }

    @Override
    public void writePixels(int x, int y, int w, int h, int[] pixels, ProgressMonitor pm) throws IOException {
        throw new IllegalStateException("write not supported for virtual band");
    }

    @Override
    public synchronized void writePixels(int x, int y, int w, int h, float[] pixels, ProgressMonitor pm) throws IOException {
        throw new IllegalStateException("write not supported for virtual band");
    }

    @Override
    public void writePixels(int x, int y, int w, int h, double[] pixels, ProgressMonitor pm) throws IOException {
        throw new IllegalStateException("write not supported for virtual band");
    }

    @Override
    public void acceptVisitor(ProductVisitor visitor) {
        Guardian.assertNotNull("visitor", visitor);
        visitor.visit(this);
    }

    @Override
    public long getRawStorageSize(ProductSubsetDef subsetDef) {
        return 256L;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[" + this.getName() + "," + ProductData.getTypeString(this.getDataType()) + "," + this.getRasterWidth() + "," + this.getRasterHeight() + "]";
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    protected RenderedImage createSourceImage() {
        return VirtualBand.createSourceImage(this, this.getExpression());
    }

    public static MultiLevelImage createSourceImage(final RasterDataNode raster, String expression) {
        Assert.notNull((Object)raster, (String)"raster");
        Assert.notNull((Object)expression, (String)PROPERTY_NAME_EXPRESSION);
        Assert.argument((raster.getProduct() != null ? 1 : 0) != 0, (String)"raster.getProduct() != null");
        final Term term = VirtualBandOpImage.parseExpression(expression, raster.getProduct());
        final Dimension sourceSize = raster.getRasterSize();
        final Dimension tileSize = raster.getProduct().getPreferredTileSize();
        final int dataType = raster.getDataType();
        final Double fillValue = raster.isNoDataValueUsed() ? Double.valueOf(raster.getGeophysicalNoDataValue()) : null;
        RasterDataNode[] refRasters = BandArithmetic.getRefRasters(term);
        MultiLevelModel multiLevelModel = refRasters.length > 0 ? refRasters[0].getMultiLevelModel() : raster.createMultiLevelModel();
        AbstractMultiLevelSource multiLevelSource = new AbstractMultiLevelSource(multiLevelModel){

            public RenderedImage createImage(int level) {
                return VirtualBandOpImage.builder(term).mask(raster instanceof Mask).dataType(dataType).fillValue(fillValue).sourceSize(sourceSize).tileSize(tileSize).level(ResolutionLevel.create(this.getModel(), level)).create();
            }
        };
        return new VirtualBandMultiLevelImage((MultiLevelSource)multiLevelSource, term){

            public void reset() {
                super.reset();
                raster.fireProductNodeDataChanged();
            }
        };
    }
}

