/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.landcover.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.dataop.barithm.BandArithmetic;
import org.esa.snap.core.dataop.barithm.ProductNamespacePrefixProvider;
import org.esa.snap.core.dataop.barithm.RasterDataEvalEnv;
import org.esa.snap.core.dataop.barithm.RasterDataSymbol;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.jexp.EvalEnv;
import org.esa.snap.core.jexp.Namespace;
import org.esa.snap.core.jexp.ParseException;
import org.esa.snap.core.jexp.Term;
import org.esa.snap.core.jexp.WritableNamespace;
import org.esa.snap.core.jexp.impl.ParserImpl;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;

@OperatorMetadata(alias="Land-Cover-Mask", category="Raster/Masks", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2015 by Array Systems Computing Inc.", description="Perform decision tree classification")
public final class LandCoverMaskOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The list of source bands.", alias="sourceBands", rasterDataNodeType=Band.class, label="Source Bands")
    private String[] sourceBandNames = null;
    @Parameter(description="Land cover band", label="Land Cover Band")
    private String landCoverBand = null;
    @Parameter(description="Land cover classes to include", label="Valid land cover classes")
    private int[] validLandCoverClasses = null;
    @Parameter(description="Add other bands unmasked", defaultValue="false", label="Include all other bands")
    private boolean includeOtherBands = false;
    private Map<Band, Band> srcBandMap = new HashMap<Band, Band>();
    private Map<Band, String> expressionMap = new HashMap<Band, String>();

    public void initialize() throws OperatorException {
        try {
            this.createTargetProduct();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void createTargetProduct() {
        Band[] sourceBands;
        this.ensureSingleRasterSize(new Product[]{this.sourceProduct});
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        if (this.includeOtherBands) {
            for (String srcBandName : this.sourceProduct.getBandNames()) {
                ProductUtils.copyBand((String)srcBandName, (Product)this.sourceProduct, (String)srcBandName, (Product)this.targetProduct, (boolean)true);
            }
        }
        for (Band srcBand : sourceBands = OperatorUtils.getSourceBands((Product)this.sourceProduct, (String[])this.sourceBandNames, (boolean)false)) {
            String targetBandName = srcBand.getName() + "_masked";
            Band targetBand = new Band(targetBandName, srcBand.getDataType(), this.targetProduct.getSceneRasterWidth(), this.targetProduct.getSceneRasterHeight());
            targetBand.setUnit(srcBand.getUnit());
            targetBand.setNoDataValue(srcBand.getNoDataValue());
            targetBand.setNoDataValueUsed(true);
            this.targetProduct.addBand(targetBand);
            this.srcBandMap.put(targetBand, srcBand);
            this.expressionMap.put(targetBand, this.createExpression(srcBand));
        }
    }

    private String createExpression(Band srcBand) {
        StringBuilder str = new StringBuilder("");
        if (this.validLandCoverClasses != null) {
            for (int c : this.validLandCoverClasses) {
                if (str.length() == 0) {
                    str.append("( ");
                } else {
                    str.append(" || ");
                }
                str.append('\'' + this.landCoverBand + "'==" + c);
            }
            str.append(" ) ? '");
            str.append(srcBand.getName());
            str.append("' : ");
            str.append(srcBand.getNoDataValue());
        }
        return str.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        try {
            RasterDataSymbol[] refRasterDataSymbols;
            Rectangle rect = targetTile.getRectangle();
            RasterDataEvalEnv env = new RasterDataEvalEnv(rect.x, rect.y, rect.width, rect.height);
            String expression = this.expressionMap.get(targetBand);
            Term term = this.createTerm(expression);
            for (RasterDataSymbol symbol : refRasterDataSymbols = BandArithmetic.getRefRasterDataSymbols((Term[])new Term[]{term})) {
                Tile tile = this.getSourceTile(symbol.getRaster(), rect);
                symbol.setData((Object)tile.getRawSamples());
            }
            pm.beginTask("Evaluating expression", rect.height);
            int pixelIndex = 0;
            for (int y = rect.y; y < rect.y + rect.height; ++y) {
                if (pm.isCanceled()) {
                    break;
                }
                for (int x = rect.x; x < rect.x + rect.width; ++x) {
                    env.setElemIndex(pixelIndex);
                    double val = term.evalD((EvalEnv)env);
                    targetTile.setSample(x, y, val);
                    ++pixelIndex;
                }
                pm.worked(1);
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
        finally {
            pm.done();
        }
    }

    private Term createTerm(String expression) {
        Term term;
        WritableNamespace namespace = BandArithmetic.createDefaultNamespace((Product[])new Product[]{this.sourceProduct}, (int)0, (ProductNamespacePrefixProvider)new SourceProductPrefixProvider());
        try {
            ParserImpl parser = new ParserImpl((Namespace)namespace, false);
            term = parser.parse(expression);
        }
        catch (ParseException e) {
            throw new OperatorException("Could not parse expression: " + expression, (Throwable)e);
        }
        return term;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(LandCoverMaskOp.class);
        }
    }

    private static class SourceProductPrefixProvider
    implements ProductNamespacePrefixProvider {
        private SourceProductPrefixProvider() {
        }

        public String getPrefix(Product product) {
            return BandArithmetic.getProductNodeNamePrefix((Product)product);
        }
    }
}

