/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.clustering.evaluation;

import net.sf.javaml.clustering.evaluation.ClusterEvaluation;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.distance.DistanceMeasure;
import net.sf.javaml.distance.EuclideanDistance;

public class SumOfSquaredErrors
implements ClusterEvaluation {
    private DistanceMeasure dm;

    public SumOfSquaredErrors() {
        this(new EuclideanDistance());
    }

    public SumOfSquaredErrors(DistanceMeasure dm) {
        this.dm = dm;
    }

    @Override
    public double score(Dataset[] datas) {
        double sum = 0.0;
        for (int i = 0; i < datas.length; ++i) {
            double tmpSum = 0.0;
            for (int j = 0; j < datas[i].size(); ++j) {
                for (int k = 0; k < datas[i].size(); ++k) {
                    double error = this.dm.measure(datas[i].instance(j), datas[i].instance(k));
                    tmpSum += error * error;
                }
            }
            sum += tmpSum / (double)datas[i].size();
        }
        return sum;
    }

    @Override
    public boolean compareScore(double score1, double score2) {
        return score2 < score1;
    }
}

