/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.internal;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ServiceRegistry;
import com.bc.ceres.core.ServiceRegistryListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.esa.snap.SnapCoreActivator;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.OperatorSpiRegistry;
import org.esa.snap.core.util.SystemUtils;

public class OperatorSpiRegistryImpl
implements OperatorSpiRegistry {
    private final ServiceRegistry<OperatorSpi> serviceRegistry;
    private final Map<String, String> classNames;
    private final Map<String, OperatorSpi> extraOperatorSpis;

    public OperatorSpiRegistryImpl(ServiceRegistry<OperatorSpi> serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
        this.classNames = new ConcurrentHashMap<String, String>(20);
        this.serviceRegistry.addListener((ServiceRegistryListener)new ServiceRegistryListener<OperatorSpi>(){

            public void serviceAdded(ServiceRegistry<OperatorSpi> registry, OperatorSpi service) {
                OperatorSpiRegistryImpl.this.registerAlias(service);
            }

            public void serviceRemoved(ServiceRegistry<OperatorSpi> registry, OperatorSpi service) {
                OperatorSpiRegistryImpl.this.unregisterAlias(service);
            }
        });
        Set services = this.serviceRegistry.getServices();
        for (OperatorSpi operatorSpi : services) {
            this.registerAlias(operatorSpi);
        }
        this.extraOperatorSpis = new ConcurrentHashMap<String, OperatorSpi>();
    }

    @Override
    public void loadOperatorSpis() {
        SnapCoreActivator.loadServices(this.getServiceRegistry());
    }

    @Override
    public Set<OperatorSpi> getOperatorSpis() {
        HashSet<OperatorSpi> operatorSpis = new HashSet<OperatorSpi>(this.serviceRegistry.getServices());
        operatorSpis.addAll(this.extraOperatorSpis.values());
        return operatorSpis;
    }

    @Override
    public ServiceRegistry<OperatorSpi> getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Override
    public OperatorSpi getOperatorSpi(String operatorName) {
        OperatorSpi service = (OperatorSpi)this.serviceRegistry.getService(operatorName);
        if (service != null) {
            return service;
        }
        service = this.getName(this.extraOperatorSpis, operatorName);
        if (service != null) {
            return service;
        }
        String className = this.getName(this.classNames, operatorName);
        if (className != null && (service = (OperatorSpi)this.serviceRegistry.getService(className)) != null) {
            return service;
        }
        return null;
    }

    private <T> T getName(Map<String, T> tMap, String operatorName) {
        Optional<String> optional = tMap.keySet().stream().filter(p -> p.equalsIgnoreCase(operatorName)).findFirst();
        return optional.isPresent() ? (T)tMap.get(optional.get()) : null;
    }

    @Override
    public boolean addOperatorSpi(OperatorSpi operatorSpi) {
        String spiClassName = operatorSpi.getClass().getName();
        if (this.serviceRegistry.getService(spiClassName) == operatorSpi) {
            return false;
        }
        this.registerAlias(operatorSpi);
        return this.serviceRegistry.addService((Object)operatorSpi);
    }

    @Override
    public boolean addOperatorSpi(String operatorName, OperatorSpi operatorSpi) {
        if (operatorName.equals(operatorSpi.getClass().getName())) {
            return this.addOperatorSpi(operatorSpi);
        }
        if (this.extraOperatorSpis.get(operatorName) == operatorSpi) {
            return false;
        }
        this.registerAlias(operatorSpi.getClass().getName(), operatorName);
        this.extraOperatorSpis.put(operatorName, operatorSpi);
        return true;
    }

    @Override
    public boolean removeOperatorSpi(OperatorSpi operatorSpi) {
        if (!this.serviceRegistry.removeService((Object)operatorSpi)) {
            Stream extraSpiStream = this.extraOperatorSpis.entrySet().stream();
            Optional<Map.Entry> spiEntry = extraSpiStream.filter(entry -> entry.getValue() == operatorSpi).findFirst();
            if (spiEntry.isPresent() && this.extraOperatorSpis.remove(spiEntry.get().getKey(), spiEntry.get().getValue())) {
                this.unregisterAlias((OperatorSpi)spiEntry.get().getValue());
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public Set<String> getAliases() {
        return this.classNames.keySet();
    }

    @Override
    @Deprecated
    public void setAlias(String aliasName, String spiClassName) {
        this.registerAlias(spiClassName, aliasName);
    }

    private void registerAlias(String spiClassName, String aliasName) {
        Assert.notNull((Object)aliasName, (String)"aliasName");
        Assert.notNull((Object)spiClassName, (String)"spiClassName");
        if (this.classNames.get(aliasName) != null) {
            SystemUtils.LOG.severe(spiClassName + ':' + aliasName + " conflicts with " + this.classNames.get(aliasName) + ':' + aliasName);
        }
        this.classNames.put(aliasName, spiClassName);
    }

    private void registerAlias(OperatorSpi operatorSpi) {
        String operatorAlias = operatorSpi.getOperatorDescriptor().getAlias();
        if (operatorAlias != null) {
            this.registerAlias(operatorSpi.getClass().getName(), operatorAlias);
        }
    }

    private void unregisterAlias(OperatorSpi operatorSpi) {
        String alias = operatorSpi.getOperatorAlias();
        if (this.classNames.remove(alias) == null) {
            String spiClassName = operatorSpi.getClass().getName();
            Stream stream = new HashSet<String>(this.classNames.keySet()).stream();
            stream.filter(key -> this.classNames.get(key).equals(spiClassName)).forEach(this.classNames::remove);
        }
    }
}

