/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common.resample;

import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.jai.GeneralFilterFunction;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.Raster;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.BorderExtender;
import javax.media.jai.BorderExtenderConstant;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Kernel;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.common.resample.InterpolationScaler;
import org.esa.snap.core.gpf.common.resample.ResamplingScaler;
import org.geotools.resources.XArray;

public class Resample {
    public static MultiLevelImage createInterpolatedMultiLevelImage(MultiLevelImage sourceImage, double noDataValue, AffineTransform sourceImageToModelTransform, int referenceWidth, int referenceHeight, MultiLevelModel referenceMultiLevelModel, Interpolation interpolation) {
        RenderingHints targetHints = Resample.getRenderingHints(noDataValue);
        float[] scalings = Resample.getScalings(sourceImageToModelTransform, referenceMultiLevelModel);
        return InterpolationScaler.scaleMultiLevelImage(referenceWidth, referenceHeight, referenceMultiLevelModel, sourceImage, scalings, targetHints, noDataValue, interpolation);
    }

    private static float[] getScalings(AffineTransform sourceTransform, MultiLevelModel referenceMultiLevelModel) {
        AffineTransform transform = new AffineTransform(sourceTransform);
        transform.concatenate(referenceMultiLevelModel.getModelToImageTransform(0));
        return new float[]{(float)transform.getScaleX(), (float)transform.getScaleY()};
    }

    static MultiLevelImage createInterpolatedMultiLevelImage(Band sourceBand, RasterDataNode referenceNode, Interpolation interpolation) {
        RenderingHints targetHints = Resample.getRenderingHints(sourceBand.getNoDataValue());
        float[] scalings = Resample.getScalings(sourceBand.getImageToModelTransform(), referenceNode);
        return ResamplingScaler.scaleMultiLevelImage(referenceNode.getSourceImage(), sourceBand.getSourceImage(), scalings, null, targetHints, sourceBand.getNoDataValue(), interpolation);
    }

    static MultiLevelImage createAggregatedMultiLevelImage(Band sourceBand, RasterDataNode referenceNode, Type type, Type flagType) {
        RenderingHints targetHints = Resample.getRenderingHints(sourceBand.getNoDataValue());
        float[] scalings = Resample.getScalings(sourceBand.getImageToModelTransform(), referenceNode);
        int kernelWidth = (int)(1.0f / scalings[0]);
        int kernelHeight = (int)(1.0f / scalings[1]);
        Kernel kernel = new Kernel(kernelWidth, kernelHeight, new double[kernelWidth * kernelHeight]);
        GeneralFilterFunction filterFunction = sourceBand.isFlagBand() || sourceBand.isIndexBand() ? Resample.getFlagFilterFunction(flagType, kernel) : Resample.getFilterFunction(type, kernel);
        Interpolation interpolation = Interpolation.getInstance((int)0);
        MultiLevelImage multiLevelImage = sourceBand.getSourceImage();
        return ResamplingScaler.scaleMultiLevelImage(referenceNode.getSourceImage(), multiLevelImage, scalings, filterFunction, targetHints, sourceBand.getNoDataValue(), interpolation);
    }

    private static float[] getScalings(AffineTransform sourceTransform, RasterDataNode referenceNode) {
        AffineTransform transform = new AffineTransform(sourceTransform);
        transform.concatenate(referenceNode.getMultiLevelModel().getModelToImageTransform(0));
        return new float[]{(float)transform.getScaleX(), (float)transform.getScaleY()};
    }

    private static RenderingHints getRenderingHints(double noDataValue) {
        RenderingHints hints = new RenderingHints(null);
        double[] background = new double[]{noDataValue};
        Object borderExtender = XArray.allEquals((double[])background, (double)0.0) ? BorderExtender.createInstance((int)0) : new BorderExtenderConstant(background);
        hints.put(JAI.KEY_BORDER_EXTENDER, borderExtender);
        return hints;
    }

    private static GeneralFilterFunction getFilterFunction(Type type, Kernel kernel) {
        switch (type) {
            case MIN: {
                return new GeneralFilterFunction.Min(kernel.getWidth(), kernel.getHeight(), kernel.getXOrigin(), kernel.getYOrigin(), null);
            }
            case MAX: {
                return new GeneralFilterFunction.Max(kernel.getWidth(), kernel.getHeight(), kernel.getXOrigin(), kernel.getYOrigin(), null);
            }
            case MEDIAN: {
                return new GeneralFilterFunction.Median(kernel.getWidth(), kernel.getHeight(), kernel.getXOrigin(), kernel.getYOrigin(), null);
            }
            case MEAN: {
                return new GeneralFilterFunction.Mean(kernel.getWidth(), kernel.getHeight(), kernel.getXOrigin(), kernel.getYOrigin(), null);
            }
        }
        return null;
    }

    private static GeneralFilterFunction getFlagFilterFunction(Type type, Kernel kernel) {
        switch (type) {
            case MIN: {
                return new FlagMinFunction(kernel.getWidth(), kernel.getHeight(), kernel.getXOrigin(), kernel.getYOrigin(), null);
            }
            case MAX: {
                return new FlagMaxFunction(kernel.getWidth(), kernel.getHeight(), kernel.getXOrigin(), kernel.getYOrigin(), null);
            }
            case MIN_MEDIAN: {
                return new FlagMedianMinFunction(kernel.getWidth(), kernel.getHeight(), kernel.getXOrigin(), kernel.getYOrigin(), null);
            }
            case MAX_MEDIAN: {
                return new FlagMedianMaxFunction(kernel.getWidth(), kernel.getHeight(), kernel.getXOrigin(), kernel.getYOrigin(), null);
            }
        }
        return null;
    }

    private class NewOp
    extends GeometricOpImage {
        public NewOp(Vector sources, ImageLayout layout, Map configuration, boolean cobbleSources, BorderExtender extender, Interpolation interp) {
            super(sources, layout, configuration, cobbleSources, extender, interp);
        }

        protected Rectangle forwardMapRect(Rectangle rectangle, int i) {
            return null;
        }

        protected Rectangle backwardMapRect(Rectangle rectangle, int i) {
            return null;
        }
    }

    private class NewImage
    extends PlanarImage {
        private NewImage() {
        }

        public Raster getTile(int i, int i1) {
            return null;
        }
    }

    static class FlagMedianMaxFunction
    extends GeneralFilterFunction {
        protected FlagMedianMaxFunction(int width, int height, int xOrigin, int yOrigin, boolean[] structuringElement) {
            super(width, height, xOrigin, yOrigin, structuringElement);
        }

        public float filter(float[] fdata) {
            boolean[] se = this.structuringElement;
            int n = 0;
            int[] occurenceCounter = new int[63];
            int highestOccurence = 0;
            for (int i = 0; i < fdata.length; ++i) {
                if (se != null && !se[i] || Float.isNaN(fdata[i])) continue;
                Long v = (long)fdata[i];
                int j = 0;
                while (v > 0L) {
                    long compare = v & 1L;
                    if (compare != 0L) {
                        int n2 = j;
                        occurenceCounter[n2] = occurenceCounter[n2] + 1;
                    }
                    v = v >> 1;
                    ++j;
                }
                highestOccurence = Math.max(highestOccurence, j - 1);
                ++n;
            }
            long res = 0L;
            float halfN = (float)n / 2.0f;
            for (int i = highestOccurence; i >= 0; --i) {
                res <<= 1;
                if (!((float)occurenceCounter[i] >= halfN)) continue;
                ++res;
            }
            return res;
        }
    }

    static class FlagMedianMinFunction
    extends GeneralFilterFunction {
        protected FlagMedianMinFunction(int width, int height, int xOrigin, int yOrigin, boolean[] structuringElement) {
            super(width, height, xOrigin, yOrigin, structuringElement);
        }

        public float filter(float[] fdata) {
            boolean[] se = this.structuringElement;
            int n = 0;
            int[] occurenceCounter = new int[63];
            int highestOccurence = 0;
            for (int i = 0; i < fdata.length; ++i) {
                if (se != null && !se[i] || Float.isNaN(fdata[i])) continue;
                Long v = (long)fdata[i];
                int j = 0;
                while (v > 0L) {
                    long compare = v & 1L;
                    if (compare != 0L) {
                        int n2 = j;
                        occurenceCounter[n2] = occurenceCounter[n2] + 1;
                    }
                    v = v >> 1;
                    ++j;
                }
                highestOccurence = Math.max(highestOccurence, j - 1);
                ++n;
            }
            long res = 0L;
            float halfN = (float)n / 2.0f;
            for (int i = highestOccurence; i >= 0; --i) {
                res <<= 1;
                if (!((float)occurenceCounter[i] > halfN)) continue;
                ++res;
            }
            return res;
        }
    }

    static class FlagMaxFunction
    extends GeneralFilterFunction {
        protected FlagMaxFunction(int width, int height, int xOrigin, int yOrigin, boolean[] structuringElement) {
            super(width, height, xOrigin, yOrigin, structuringElement);
        }

        public float filter(float[] fdata) {
            boolean[] se = this.structuringElement;
            long res = 0L;
            int n = 0;
            for (int i = 0; i < fdata.length; ++i) {
                if (se != null && !se[i] || Float.isNaN(fdata[i])) continue;
                long v = (long)fdata[i];
                res |= v;
                ++n;
            }
            return n > 0 ? (float)res : 0.0f;
        }
    }

    static class FlagMinFunction
    extends GeneralFilterFunction {
        protected FlagMinFunction(int width, int height, int xOrigin, int yOrigin, boolean[] structuringElement) {
            super(width, height, xOrigin, yOrigin, structuringElement);
        }

        public float filter(float[] fdata) {
            boolean[] se = this.structuringElement;
            long res = Long.MAX_VALUE;
            int n = 0;
            for (int i = 0; i < fdata.length; ++i) {
                if (se != null && !se[i] || Float.isNaN(fdata[i])) continue;
                long v = (long)fdata[i];
                res &= v;
                ++n;
            }
            return n > 0 ? (float)res : 0.0f;
        }
    }

    static enum Type {
        FIRST,
        MIN,
        MAX,
        MEDIAN,
        MEAN,
        MIN_MEDIAN,
        MAX_MEDIAN;

    }
}

