/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common.resample;

import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import com.bc.ceres.glevel.support.DefaultMultiLevelModel;
import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.BorderExtenderConstant;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.operator.BorderDescriptor;
import javax.media.jai.operator.CropDescriptor;
import javax.media.jai.operator.ScaleDescriptor;
import javax.media.jai.operator.TranslateDescriptor;
import org.apache.commons.math3.util.Precision;
import org.esa.snap.core.image.ImageManager;
import org.esa.snap.core.image.ResolutionLevel;
import org.esa.snap.core.util.jai.JAIUtils;

class InterpolationScaler {
    InterpolationScaler() {
    }

    static MultiLevelImage scaleMultiLevelImage(int masterWidth, int masterHeight, MultiLevelModel masterMultiLevelModel, MultiLevelImage sourceImage, float[] scalings, RenderingHints renderingHints, double noDataValue, Interpolation interpolation) {
        ScaledMultiLevelSource multiLevelSource = new ScaledMultiLevelSource(masterWidth, masterHeight, masterMultiLevelModel, sourceImage, scalings, renderingHints, noDataValue, interpolation);
        return new DefaultMultiLevelImage((MultiLevelSource)multiLevelSource);
    }

    private static class ScaledMultiLevelSource
    extends AbstractMultiLevelSource {
        private final MultiLevelImage sourceImage;
        private final float[] scalings;
        private final RenderingHints renderingHints;
        private final double noDataValue;
        private final MultiLevelModel masterMultiLevelModel;
        private final int masterWidth;
        private final int masterHeight;
        private Interpolation interpolation;
        private static double EPSILON = 1.0E-12;
        private final Dimension tileSize;

        private ScaledMultiLevelSource(int masterWidth, int masterHeight, MultiLevelModel masterMultiLevelModel, MultiLevelImage sourceImage, float[] scalings, RenderingHints renderingHints, double noDataValue, Interpolation interpolation) {
            super((MultiLevelModel)new DefaultMultiLevelModel(masterMultiLevelModel.getLevelCount(), new AffineTransform(), masterWidth, masterHeight));
            this.tileSize = JAIUtils.computePreferredTileSize((int)masterWidth, (int)masterHeight, (int)1);
            this.sourceImage = sourceImage;
            this.scalings = scalings;
            this.renderingHints = renderingHints;
            this.noDataValue = noDataValue;
            this.interpolation = interpolation;
            this.masterWidth = masterWidth;
            this.masterHeight = masterHeight;
            this.masterMultiLevelModel = masterMultiLevelModel;
        }

        protected RenderedImage createImage(int targetLevel) {
            double targetScale = this.masterMultiLevelModel.getScale(targetLevel);
            ResolutionLevel resolutionLevel = ResolutionLevel.create((MultiLevelModel)this.getModel(), (int)targetLevel);
            ImageLayout imageLayout = ImageManager.createSingleBandedImageLayout((int)this.sourceImage.getSampleModel().getDataType(), null, (int)this.masterWidth, (int)this.masterHeight, (Dimension)this.tileSize, (ResolutionLevel)resolutionLevel);
            int levelMasterWidth = imageLayout.getWidth(null);
            int levelMasterHeight = imageLayout.getHeight(null);
            MultiLevelModel sourceModel = this.sourceImage.getModel();
            int sourceLevel = this.findBestSourceLevel(targetScale, sourceModel, this.scalings);
            double sourceScale = sourceModel.getScale(sourceLevel);
            RenderedImage image = this.sourceImage.getImage(sourceLevel);
            float scaleRatio = (float)(sourceScale / targetScale);
            RenderedImage renderedImage = image;
            float xScale = this.scalings[0] * scaleRatio;
            float yScale = this.scalings[1] * scaleRatio;
            AffineTransform sourceTransform = sourceModel.getImageToModelTransform(sourceLevel);
            AffineTransform referenceTransform = this.masterMultiLevelModel.getImageToModelTransform(targetLevel);
            float offsetX = (float)(sourceTransform.getTranslateX() / sourceTransform.getScaleX()) - (float)(referenceTransform.getTranslateX() / sourceTransform.getScaleX());
            float offsetY = (float)(sourceTransform.getTranslateY() / sourceTransform.getScaleY()) - (float)(referenceTransform.getTranslateY() / sourceTransform.getScaleY());
            if (Precision.compareTo((double)offsetX, (double)0.0, (double)EPSILON) != 0 || Precision.compareTo((double)offsetY, (double)0.0, (double)EPSILON) != 0) {
                renderedImage = TranslateDescriptor.create((RenderedImage)renderedImage, (Float)Float.valueOf(offsetX), (Float)Float.valueOf(offsetY), null, (RenderingHints)this.renderingHints);
            }
            if (Precision.compareTo((double)xScale, (double)1.0, (double)EPSILON) != 0 || Precision.compareTo((double)yScale, (double)1.0, (double)EPSILON) != 0) {
                renderedImage = ScaleDescriptor.create((RenderedImage)renderedImage, (Float)Float.valueOf(xScale), (Float)Float.valueOf(yScale), (Float)Float.valueOf(0.5f), (Float)Float.valueOf(0.5f), (Interpolation)this.interpolation, (RenderingHints)this.renderingHints);
            }
            if (levelMasterWidth != renderedImage.getWidth() || levelMasterHeight != renderedImage.getHeight() || Precision.compareTo((double)offsetX, (double)0.0, (double)EPSILON) != 0 || Precision.compareTo((double)offsetY, (double)0.0, (double)EPSILON) != 0) {
                int leftPad = renderedImage.getMinX();
                int upperPad = renderedImage.getMinY();
                BorderExtenderConstant borderExtender = new BorderExtenderConstant(new double[]{this.noDataValue});
                int rightPad = Math.max(0, levelMasterWidth - leftPad - renderedImage.getWidth());
                int lowerPad = Math.max(0, levelMasterHeight - upperPad - renderedImage.getHeight());
                renderedImage = BorderDescriptor.create((RenderedImage)renderedImage, (Integer)leftPad, (Integer)rightPad, (Integer)upperPad, (Integer)lowerPad, (BorderExtender)borderExtender, (RenderingHints)this.renderingHints);
            }
            renderedImage = CropDescriptor.create((RenderedImage)renderedImage, (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(levelMasterWidth), (Float)Float.valueOf(levelMasterHeight), (RenderingHints)this.renderingHints);
            return renderedImage;
        }

        private int findBestSourceLevel(double targetScale, MultiLevelModel sourceModel, float[] scalings) {
            float optimizedScaling = 0.0f;
            int optimizedSourceLevel = 0;
            boolean initialized = false;
            for (int sourceLevel = 0; sourceLevel < sourceModel.getLevelCount(); ++sourceLevel) {
                double sourceScale = sourceModel.getScale(sourceLevel);
                float scaleRatio = (float)(sourceScale / targetScale);
                if (!initialized) {
                    optimizedScaling = scalings[0] * scaleRatio;
                    optimizedSourceLevel = sourceLevel;
                    initialized = true;
                    continue;
                }
                if (!(Math.abs(1.0f - scalings[0] * scaleRatio) < Math.abs(1.0f - optimizedScaling))) continue;
                optimizedScaling = scalings[0] * scaleRatio;
                optimizedSourceLevel = sourceLevel;
            }
            return optimizedSourceLevel;
        }
    }
}

