/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common.resample;

import java.util.ArrayList;
import java.util.Collections;
import javax.media.jai.RasterAccessor;
import org.esa.snap.core.gpf.common.resample.Aggregator;
import org.esa.snap.core.gpf.common.resample.DataAccessorFactory;
import org.esa.snap.core.gpf.common.resample.DoubleDataAccessor;

public abstract class DoubleDataAggregator
implements Aggregator {
    private DoubleDataAccessor accessor;

    @Override
    public void init(RasterAccessor srcAccessor, RasterAccessor dstAccessor, double noDataValue) {
        this.accessor = DataAccessorFactory.createDoubleDataAccessor(srcAccessor, dstAccessor, noDataValue);
    }

    protected double getSrcData(int index) {
        return this.accessor.getSrcData(index);
    }

    protected void setDstData(int index, double value) {
        this.accessor.setDstData(index, value);
    }

    protected double getNoDataValue() {
        return this.accessor.getNoDataValue();
    }

    protected int getSrcOffset() {
        return this.accessor.getSrcOffset();
    }

    static class First
    extends DoubleDataAggregator {
        First() {
        }

        @Override
        public void aggregate(int srcY0, int srcY1, int srcX0, int srcX1, int srcScanlineStride, double wx0, double wx1, double wy0, double wy1, int dstPos) {
            this.setDstData(dstPos, this.getSrcData(this.getSrcOffset() + srcY0 * srcScanlineStride + srcX0));
        }
    }

    static class Max
    extends DoubleDataAggregator {
        Max() {
        }

        @Override
        public void aggregate(int srcY0, int srcY1, int srcX0, int srcX1, int srcScanlineStride, double wx0, double wx1, double wy0, double wy1, int dstPos) {
            double maxValue = Double.NEGATIVE_INFINITY;
            int srcIndexY = this.getSrcOffset() + srcY0 * srcScanlineStride;
            for (int srcY = srcY0; srcY <= srcY1; ++srcY) {
                for (int srcX = srcX0; srcX <= srcX1; ++srcX) {
                    double v = this.getSrcData(srcIndexY + srcX);
                    if (Double.isNaN(v) || !Double.isNaN(this.getNoDataValue()) && !(Math.abs(v - this.getNoDataValue()) > 1.0E-8) || !(v > maxValue)) continue;
                    maxValue = v;
                }
                srcIndexY += srcScanlineStride;
            }
            this.setDstData(dstPos, maxValue);
        }
    }

    static class Min
    extends DoubleDataAggregator {
        Min() {
        }

        @Override
        public void aggregate(int srcY0, int srcY1, int srcX0, int srcX1, int srcScanlineStride, double wx0, double wx1, double wy0, double wy1, int dstPos) {
            double minValue = Double.POSITIVE_INFINITY;
            int srcIndexY = this.getSrcOffset() + srcY0 * srcScanlineStride;
            for (int srcY = srcY0; srcY <= srcY1; ++srcY) {
                for (int srcX = srcX0; srcX <= srcX1; ++srcX) {
                    double v = this.getSrcData(srcIndexY + srcX);
                    if (Double.isNaN(v) || !Double.isNaN(this.getNoDataValue()) && !(Math.abs(v - this.getNoDataValue()) > 1.0E-8) || !(v < minValue)) continue;
                    minValue = v;
                }
                srcIndexY += srcScanlineStride;
            }
            this.setDstData(dstPos, minValue);
        }
    }

    static class Median
    extends DoubleDataAggregator {
        Median() {
        }

        @Override
        public void aggregate(int srcY0, int srcY1, int srcX0, int srcX1, int srcScanlineStride, double wx0, double wx1, double wy0, double wy1, int dstPos) {
            ArrayList<Double> validValues = new ArrayList<Double>();
            int srcIndexY = this.getSrcOffset() + srcY0 * srcScanlineStride;
            for (int srcY = srcY0; srcY <= srcY1; ++srcY) {
                for (int srcX = srcX0; srcX <= srcX1; ++srcX) {
                    double v = this.getSrcData(srcIndexY + srcX);
                    if (Double.isNaN(v) || !Double.isNaN(this.getNoDataValue()) && !(Math.abs(v - this.getNoDataValue()) > 1.0E-8)) continue;
                    validValues.add(v);
                }
                srcIndexY += srcScanlineStride;
            }
            int numValidValues = validValues.size();
            if (numValidValues == 0) {
                this.setDstData(dstPos, this.getNoDataValue());
            } else {
                Collections.sort(validValues);
                if (numValidValues % 2 == 1) {
                    this.setDstData(dstPos, (Double)validValues.get(numValidValues / 2));
                } else {
                    double median = ((Double)validValues.get(numValidValues / 2 - 1) + (Double)validValues.get(numValidValues / 2)) / 2.0;
                    this.setDstData(dstPos, median);
                }
            }
        }
    }

    static class Mean
    extends DoubleDataAggregator {
        Mean() {
        }

        @Override
        public void aggregate(int srcY0, int srcY1, int srcX0, int srcX1, int srcScanlineStride, double wx0, double wx1, double wy0, double wy1, int dstPos) {
            double vSum = 0.0;
            double wSum = 0.0;
            int srcIndexY = this.getSrcOffset() + srcY0 * srcScanlineStride;
            for (int srcY = srcY0; srcY <= srcY1; ++srcY) {
                double wy = srcY == srcY0 ? wy0 : (srcY == srcY1 ? wy1 : 1.0);
                for (int srcX = srcX0; srcX <= srcX1; ++srcX) {
                    double wx = srcX == srcX0 ? wx0 : (srcX == srcX1 ? wx1 : 1.0);
                    double v = this.getSrcData(srcIndexY + srcX);
                    if (Double.isNaN(v) || !Double.isNaN(this.getNoDataValue()) && !(Math.abs(v - this.getNoDataValue()) > 1.0E-8)) continue;
                    double w = wx * wy;
                    vSum += w * v;
                    wSum += w;
                }
                srcIndexY += srcScanlineStride;
            }
            if (Double.isNaN(vSum) || wSum == 0.0) {
                this.setDstData(dstPos, this.getNoDataValue());
            } else {
                this.setDstData(dstPos, vSum / wSum);
            }
        }
    }
}

