/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.annotations;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import com.bc.ceres.binding.ConverterRegistry;
import com.bc.ceres.binding.DefaultPropertySetDescriptor;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertyDescriptorFactory;
import com.bc.ceres.binding.PropertySetDescriptor;
import com.bc.ceres.binding.Validator;
import com.bc.ceres.binding.ValueRange;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.binding.dom.DomConverter;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.OperatorSpiRegistry;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.descriptor.AnnotationParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.OperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.ParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.PropertySetDescriptorFactory;
import org.esa.snap.core.gpf.internal.RasterDataNodeValues;
import org.esa.snap.core.util.StringUtils;

public class ParameterDescriptorFactory
implements PropertyDescriptorFactory {
    private Map<String, Product> sourceProductMap;

    public static PropertyContainer createMapBackedOperatorPropertyContainer(String operatorName) {
        return ParameterDescriptorFactory.createMapBackedOperatorPropertyContainer(operatorName, new HashMap<String, Object>());
    }

    public static PropertyContainer createMapBackedOperatorPropertyContainer(String operatorName, Map<String, Object> operatorParameters) {
        return ParameterDescriptorFactory.createMapBackedOperatorPropertyContainer(operatorName, operatorParameters, null);
    }

    public static PropertyContainer createMapBackedOperatorPropertyContainer(String operatorName, Map<String, Object> operatorParameters, Map<String, Product> sourceProductMap) {
        PropertySetDescriptor propertySetDescriptor;
        OperatorSpi opSpi = ParameterDescriptorFactory.getOpSpi(operatorName);
        OperatorDescriptor operatorDescriptor = opSpi.getOperatorDescriptor();
        try {
            propertySetDescriptor = PropertySetDescriptorFactory.createForOperator(operatorDescriptor, sourceProductMap);
        }
        catch (ConversionException e) {
            throw new OperatorException("Could not create property container for operator '" + operatorName + "'");
        }
        return PropertyContainer.createMapBacked(operatorParameters, (PropertySetDescriptor)propertySetDescriptor);
    }

    public ParameterDescriptorFactory() {
    }

    public ParameterDescriptorFactory(Map<String, Product> sourceProductMap) {
        this.sourceProductMap = sourceProductMap;
    }

    public Map<String, Product> getSourceProductMap() {
        return this.sourceProductMap;
    }

    public static PropertyDescriptor convert(ParameterDescriptor parameterDescriptor, Map<String, Product> sourceProductMap) throws ConversionException {
        Class rasterDataNodeType;
        Converter converter;
        Class<? extends Converter> converterClass;
        Class<? extends DomConverter> domConverterClass;
        PropertyDescriptor propertyDescriptor = new PropertyDescriptor(parameterDescriptor.getName(), parameterDescriptor.getDataType());
        Class<? extends Validator> validatorClass = parameterDescriptor.getValidatorClass();
        if (validatorClass != null) {
            Validator validator;
            try {
                validator = validatorClass.newInstance();
            }
            catch (Throwable t) {
                throw new ConversionException("Failed to create validator.", t);
            }
            propertyDescriptor.setValidator(validator);
        }
        if ((domConverterClass = parameterDescriptor.getDomConverterClass()) != null) {
            DomConverter domConverter;
            try {
                domConverter = domConverterClass.newInstance();
            }
            catch (Throwable t) {
                throw new ConversionException("Failed to create DOM converter.", t);
            }
            propertyDescriptor.setDomConverter(domConverter);
        }
        if ((converterClass = parameterDescriptor.getConverterClass()) != null) {
            try {
                converter = converterClass.newInstance();
            }
            catch (Throwable t) {
                throw new ConversionException("Failed to create converter.", t);
            }
            propertyDescriptor.setConverter(converter);
        }
        if (StringUtils.isNotNullAndNotEmpty((String)parameterDescriptor.getLabel())) {
            propertyDescriptor.setDisplayName(parameterDescriptor.getLabel());
        }
        if (StringUtils.isNotNullAndNotEmpty((String)parameterDescriptor.getAlias())) {
            propertyDescriptor.setAlias(parameterDescriptor.getAlias());
        }
        if (StringUtils.isNotNullAndNotEmpty((String)parameterDescriptor.getItemAlias())) {
            propertyDescriptor.setItemAlias(parameterDescriptor.getItemAlias());
        }
        if (propertyDescriptor.getConverter() == null) {
            propertyDescriptor.setDefaultConverter();
        }
        if (StringUtils.isNotNullAndNotEmpty((String)parameterDescriptor.getUnit())) {
            propertyDescriptor.setUnit(parameterDescriptor.getUnit());
        }
        if (StringUtils.isNotNullAndNotEmpty((String)parameterDescriptor.getDescription())) {
            propertyDescriptor.setDescription(parameterDescriptor.getDescription());
        }
        propertyDescriptor.setNotNull(parameterDescriptor.isNotNull());
        propertyDescriptor.setNotEmpty(parameterDescriptor.isNotEmpty());
        propertyDescriptor.setDeprecated(parameterDescriptor.isDeprecated());
        if (StringUtils.isNotNullAndNotEmpty((String)parameterDescriptor.getPattern())) {
            Pattern pattern = Pattern.compile(parameterDescriptor.getPattern());
            propertyDescriptor.setPattern(pattern);
        }
        if (StringUtils.isNotNullAndNotEmpty((String)parameterDescriptor.getInterval())) {
            ValueRange valueRange = ValueRange.parseValueRange((String)parameterDescriptor.getInterval());
            propertyDescriptor.setValueRange(valueRange);
        }
        if (StringUtils.isNotNullAndNotEmpty((String)parameterDescriptor.getFormat())) {
            propertyDescriptor.setFormat(parameterDescriptor.getFormat());
        }
        if (parameterDescriptor.getValueSet().length > 0) {
            if (propertyDescriptor.getType().isArray()) {
                Class<?> componentType = propertyDescriptor.getType().getComponentType();
                converter = ConverterRegistry.getInstance().getConverter(componentType);
            } else {
                converter = propertyDescriptor.getConverter();
            }
            ValueSet valueSet = ValueSet.parseValueSet((String[])parameterDescriptor.getValueSet(), (Converter)converter);
            propertyDescriptor.setValueSet(valueSet);
        }
        if (StringUtils.isNotNullAndNotEmpty((String)parameterDescriptor.getDefaultValue())) {
            converter = propertyDescriptor.getConverter();
            propertyDescriptor.setDefaultValue(converter.parse(parameterDescriptor.getDefaultValue()));
        }
        if (parameterDescriptor.getRasterDataNodeClass() != null) {
            rasterDataNodeType = parameterDescriptor.getRasterDataNodeClass();
            propertyDescriptor.setAttribute("rasterDataNodeType", rasterDataNodeType);
        }
        if (propertyDescriptor.getAttribute("rasterDataNodeType") != null) {
            Product firstProduct;
            rasterDataNodeType = (Class)propertyDescriptor.getAttribute("rasterDataNodeType");
            Object[] values = new String[]{};
            if (sourceProductMap != null && sourceProductMap.size() > 0 && (firstProduct = sourceProductMap.values().iterator().next()) != null) {
                boolean includeEmptyValue = !propertyDescriptor.isNotNull() && !propertyDescriptor.getType().isArray();
                values = RasterDataNodeValues.getNames(firstProduct, rasterDataNodeType, includeEmptyValue);
            }
            propertyDescriptor.setValueSet(new ValueSet(values));
        }
        if (parameterDescriptor.isStructure() && !ParameterDescriptorFactory.hasConverterOrDomConverter(parameterDescriptor)) {
            ParameterDescriptor[] structureMemberDescriptors = parameterDescriptor.getStructureMemberDescriptors();
            DefaultPropertySetDescriptor propertySetDescriptor = new DefaultPropertySetDescriptor();
            for (ParameterDescriptor structureMemberDescriptor : structureMemberDescriptors) {
                propertySetDescriptor.addPropertyDescriptor(ParameterDescriptorFactory.convert(structureMemberDescriptor, sourceProductMap));
            }
            propertyDescriptor.setPropertySetDescriptor((PropertySetDescriptor)propertySetDescriptor);
        }
        return propertyDescriptor;
    }

    private static boolean hasConverterOrDomConverter(ParameterDescriptor parameterDescriptor) {
        return parameterDescriptor.getDomConverterClass() != null || parameterDescriptor.getConverterClass() != null;
    }

    public PropertyDescriptor createValueDescriptor(Field field) {
        try {
            return this.createValueDescriptorImpl(field);
        }
        catch (ConversionException e) {
            String message = String.format("field [%s]", field.getName());
            throw new IllegalArgumentException(message, e);
        }
    }

    private PropertyDescriptor createValueDescriptorImpl(Field field) throws ConversionException {
        boolean isDeprecated;
        boolean operatorDetected = Operator.class.isAssignableFrom(field.getDeclaringClass());
        Parameter parameterAnnotation = field.getAnnotation(Parameter.class);
        if (operatorDetected && parameterAnnotation == null) {
            return null;
        }
        boolean bl = isDeprecated = field.getAnnotation(Deprecated.class) != null;
        if (parameterAnnotation == null) {
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(field.getName(), field.getType());
            propertyDescriptor.setDeprecated(isDeprecated);
            return propertyDescriptor;
        }
        return ParameterDescriptorFactory.convert(new AnnotationParameterDescriptor(field.getName(), field.getType(), isDeprecated, parameterAnnotation), this.sourceProductMap);
    }

    private static OperatorSpi getOpSpi(String operatorName) {
        OperatorSpiRegistry registry = GPF.getDefaultInstance().getOperatorSpiRegistry();
        registry.loadOperatorSpis();
        OperatorSpi operatorSpi = registry.getOperatorSpi(operatorName);
        if (operatorSpi == null) {
            throw new IllegalStateException("Operator SPI not found for operator [" + operatorName + "]");
        }
        return operatorSpi;
    }
}

