/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.aatsr.sst;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.image.Raster;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.media.jai.OpImage;
import org.esa.beam.aatsr.sst.SstCoefficientLoader;
import org.esa.beam.aatsr.sst.SstCoefficientSet;
import org.esa.beam.aatsr.sst.SstCoefficients;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.framework.gpf.pointop.PixelOperator;
import org.esa.beam.framework.gpf.pointop.ProductConfigurer;
import org.esa.beam.framework.gpf.pointop.Sample;
import org.esa.beam.framework.gpf.pointop.SampleConfigurer;
import org.esa.beam.framework.gpf.pointop.WritableSample;
import org.esa.beam.jai.ResolutionLevel;
import org.esa.beam.jai.VirtualBandOpImage;
import org.esa.beam.util.ResourceInstaller;
import org.esa.beam.util.SystemUtils;

@OperatorMetadata(alias="Aatsr.SST", category="Optical Processing/Thematic Water Processing", authors="Tom Block, Ralf Quast", copyright="Brockmann Consult GmbH", version="2.0", description="Computes sea surface temperature (SST) from (A)ATSR products.")
public class AatsrSstOp
extends PixelOperator {
    private static final float COEFF_0_SCALE = 1.0f;
    private static final String SST_AUXDATA_DIR_PROPERTY = "sst.auxdata.dir";
    private static final String NADIR_SST_BAND_NAME = "nadir_sst";
    private static final String DUAL_SST_BAND_NAME = "dual_sst";
    @SourceProduct(alias="source", description="The path of the (A)ATSR source product", label="(A)ATSR source product", bands={"btemp_nadir_0370", "btemp_nadir_1100", "btemp_nadir_1200"})
    private Product sourceProduct;
    @Parameter(defaultValue="true", label="Generate dual-view SST", description="Enables/disables generation of the dual-view SST")
    private boolean dual;
    @Parameter(defaultValue="AVERAGE_POLAR_DUAL_VIEW", label="Dual-view coefficient file", description="Coefficient file for the dual-view SST", valueSet={"AVERAGE_POLAR_DUAL_VIEW", "AVERAGE_TEMPERATE_DUAL_VIEW", "AVERAGE_TROPICAL_DUAL_VIEW", "GRIDDED_POLAR_DUAL_VIEW", "GRIDDED_TEMPERATE_DUAL_VIEW", "GRIDDED_TROPICAL_DUAL_VIEW", "GRIDDED_DUAL_VIEW_IPF"})
    private Files dualCoefficientsFile;
    @Parameter(defaultValue="!cloud_flags_nadir.LAND and !cloud_flags_nadir.CLOUDY and !cloud_flags_nadir.SUN_GLINT and !cloud_flags_fward.LAND and !cloud_flags_fward.CLOUDY and !cloud_flags_fward.SUN_GLINT", label="Dual-view mask", description="ROI-mask used for the dual-view SST")
    private String dualMaskExpression;
    @Parameter(defaultValue="true", label="Generate nadir-view SST", description="Enables/disables generation of the nadir-view SST")
    private boolean nadir;
    @Parameter(defaultValue="AVERAGE_POLAR_SINGLE_VIEW", label="Nadir-view coefficient file", description="Coefficient file for the nadir-view SST", valueSet={"AVERAGE_POLAR_SINGLE_VIEW", "AVERAGE_TEMPERATE_SINGLE_VIEW", "AVERAGE_TROPICAL_SINGLE_VIEW", "GRIDDED_POLAR_SINGLE_VIEW", "GRIDDED_TEMPERATE_SINGLE_VIEW", "GRIDDED_TROPICAL_SINGLE_VIEW"})
    private Files nadirCoefficientsFile;
    @Parameter(defaultValue="!cloud_flags_nadir.LAND and !cloud_flags_nadir.CLOUDY and !cloud_flags_nadir.SUN_GLINT", label="Nadir-view mask", description="ROI-mask used for the nadir-view SST")
    private String nadirMaskExpression;
    @Parameter(defaultValue="-999.0f", label="Invalid SST value", description="Value used to fill invalid SST pixels")
    private float invalidSstValue;
    private transient float[] a0;
    private transient float[] a1;
    private transient float[] a2;
    private transient float[] b0;
    private transient float[] b1;
    private transient float[] b2;
    private transient float[] b3;
    private transient float[] c0;
    private transient float[] c1;
    private transient float[] c2;
    private transient float[] c3;
    private transient float[] c4;
    private transient float[] d0;
    private transient float[] d1;
    private transient float[] d2;
    private transient float[] d3;
    private transient float[] d4;
    private transient float[] d5;
    private transient float[] d6;
    private transient int[] nadirCoefficientIndexes;
    private transient int[] dualCoefficientIndexes;
    private transient OpImage nadirMaskOpImage;
    private transient OpImage dualMaskOpImage;
    private transient int currentPixel = 0;

    public void dispose() {
        super.dispose();
        if (this.nadirMaskOpImage != null) {
            this.nadirMaskOpImage.dispose();
        }
        if (this.dualMaskOpImage != null) {
            this.dualMaskOpImage.dispose();
        }
    }

    protected void computePixel(int x, int y, Sample[] sourceSamples, WritableSample[] targetSamples) {
        this.checkCancellation();
        if (this.nadir) {
            if (AatsrSstOp.isMasked(this.nadirMaskOpImage, x, y)) {
                float ir37 = sourceSamples[0].getFloat();
                float ir11 = sourceSamples[1].getFloat();
                float ir12 = sourceSamples[2].getFloat();
                float sea = sourceSamples[3].getFloat();
                int i = this.nadirCoefficientIndexes[x];
                float nadirSst = this.computeNadirSst(i, ir37, ir11, ir12, sea);
                targetSamples[0].set(nadirSst);
            } else {
                targetSamples[0].set(this.invalidSstValue);
            }
        }
        if (this.dual) {
            if (AatsrSstOp.isMasked(this.dualMaskOpImage, x, y)) {
                float ir37N = sourceSamples[0].getFloat();
                float ir11N = sourceSamples[1].getFloat();
                float ir12N = sourceSamples[2].getFloat();
                float ir37F = sourceSamples[4].getFloat();
                float ir11F = sourceSamples[5].getFloat();
                float ir12F = sourceSamples[6].getFloat();
                float seaN = sourceSamples[3].getFloat();
                float seaF = sourceSamples[7].getFloat();
                int i = this.dualCoefficientIndexes[x];
                float dualSst = this.computeDualSst(i, ir37N, ir11N, ir12N, ir37F, ir11F, ir12F, seaN, seaF);
                targetSamples[1].set(dualSst);
            } else {
                targetSamples[1].set(this.invalidSstValue);
            }
        }
    }

    private void checkCancellation() {
        if (this.currentPixel % 1000 == 0) {
            this.checkForCancellation();
            this.currentPixel = 0;
        }
        ++this.currentPixel;
    }

    private float computeNadirSst(int i, float ir37, float ir11, float ir12, float sea) {
        if (sea < 0.0f && ir37 > 0.0f) {
            return this.b0[i] + this.b1[i] * ir11 + this.b2[i] * ir12 + this.b3[i] * ir37;
        }
        return this.a0[i] + this.a1[i] * ir11 + this.a2[i] * ir12;
    }

    private float computeDualSst(int i, float ir37N, float ir11N, float ir12N, float ir37F, float ir11F, float ir12F, float seaN, float seaF) {
        if (seaN < 0.0f && seaF < 0.0f && ir37N > 0.0f && ir37F > 0.0f) {
            return this.d0[i] + this.d1[i] * ir11N + this.d2[i] * ir12N + this.d3[i] * ir37N + this.d4[i] * ir11F + this.d5[i] * ir12F + this.d6[i] * ir37F;
        }
        return this.c0[i] + this.c1[i] * ir11N + this.c2[i] * ir12N + this.c3[i] * ir11F + this.c4[i] * ir12F;
    }

    protected void configureSourceSamples(SampleConfigurer sampleConfigurer) throws OperatorException {
        sampleConfigurer.defineSample(0, "btemp_nadir_0370");
        sampleConfigurer.defineSample(1, "btemp_nadir_1100");
        sampleConfigurer.defineSample(2, "btemp_nadir_1200");
        sampleConfigurer.defineSample(3, "sun_elev_nadir");
        if (this.dual) {
            sampleConfigurer.defineSample(4, "btemp_fward_0370");
            sampleConfigurer.defineSample(5, "btemp_fward_1100");
            sampleConfigurer.defineSample(6, "btemp_fward_1200");
            sampleConfigurer.defineSample(7, "sun_elev_fward");
        }
    }

    protected void configureTargetSamples(SampleConfigurer sampleConfigurer) throws OperatorException {
        if (this.nadir) {
            sampleConfigurer.defineSample(0, NADIR_SST_BAND_NAME);
        }
        if (this.dual) {
            sampleConfigurer.defineSample(1, DUAL_SST_BAND_NAME);
        }
    }

    protected void configureTargetProduct(ProductConfigurer productConfigurer) {
        super.configureTargetProduct(productConfigurer);
        if (this.nadir) {
            Band nadirSstBand = productConfigurer.addBand(NADIR_SST_BAND_NAME, 30);
            nadirSstBand.setUnit("K");
            nadirSstBand.setDescription("Nadir-view sea surface temperature");
            nadirSstBand.setGeophysicalNoDataValue((double)this.invalidSstValue);
            nadirSstBand.setNoDataValueUsed(true);
        }
        if (this.dual) {
            Band dualSstBand = productConfigurer.addBand(DUAL_SST_BAND_NAME, 30);
            dualSstBand.setUnit("K");
            dualSstBand.setDescription("Combined view sea surface temperature");
            dualSstBand.setGeophysicalNoDataValue((double)this.invalidSstValue);
            dualSstBand.setNoDataValueUsed(true);
        }
    }

    protected void prepareInputs() throws OperatorException {
        super.prepareInputs();
        File auxdataDir = this.installAuxiliaryData();
        if (this.nadir) {
            this.initNadirCoefficients(auxdataDir);
            if (this.nadirMaskExpression != null && !this.nadirMaskExpression.isEmpty()) {
                this.nadirMaskOpImage = VirtualBandOpImage.createMask((String)this.nadirMaskExpression, (Product)this.sourceProduct, (ResolutionLevel)ResolutionLevel.MAXRES);
            }
        }
        if (this.dual) {
            this.initDualCoefficients(auxdataDir);
            if (this.dualMaskExpression != null && !this.dualMaskExpression.isEmpty()) {
                this.dualMaskOpImage = VirtualBandOpImage.createMask((String)this.dualMaskExpression, (Product)this.sourceProduct, (ResolutionLevel)ResolutionLevel.MAXRES);
            }
        }
    }

    private void initNadirCoefficients(File auxdataDir) throws OperatorException {
        int i;
        SstCoefficientSet coefficientSet;
        SstCoefficientLoader loader = new SstCoefficientLoader();
        try {
            coefficientSet = loader.load(this.nadirCoefficientsFile.getURL(auxdataDir));
        }
        catch (IOException e) {
            throw new OperatorException((Throwable)e);
        }
        int numCoeffs = coefficientSet.getNumCoefficients();
        int maxIndex = 0;
        for (i = 0; i < numCoeffs; ++i) {
            int endIndex = coefficientSet.getCoefficientsAt(i).getEnd();
            if (endIndex <= maxIndex) continue;
            maxIndex = endIndex;
        }
        this.nadirCoefficientIndexes = new int[maxIndex + 1];
        this.a0 = new float[numCoeffs];
        this.a1 = new float[numCoeffs];
        this.a2 = new float[numCoeffs];
        this.b0 = new float[numCoeffs];
        this.b1 = new float[numCoeffs];
        this.b2 = new float[numCoeffs];
        this.b3 = new float[numCoeffs];
        for (i = 0; i < numCoeffs; ++i) {
            SstCoefficients coefficients = coefficientSet.getCoefficientsAt(i);
            for (int k = coefficients.getStart(); k <= coefficients.getEnd(); ++k) {
                this.nadirCoefficientIndexes[k] = i;
            }
            float[] aCoefficients = coefficients.get_A_Coeffs();
            if (aCoefficients == null) {
                throw new OperatorException("Invalid coefficient file: no nadir view \"a\" coefficients set");
            }
            this.a0[i] = aCoefficients[0] * 1.0f;
            this.a1[i] = aCoefficients[1];
            this.a2[i] = aCoefficients[2];
            float[] bCoefficients = coefficients.get_B_Coeffs();
            if (bCoefficients == null) {
                throw new OperatorException("Invalid coefficient file: no nadir view \"b\" coefficients set");
            }
            this.b0[i] = bCoefficients[0] * 1.0f;
            this.b1[i] = bCoefficients[1];
            this.b2[i] = bCoefficients[2];
            this.b3[i] = bCoefficients[3];
        }
    }

    private void initDualCoefficients(File auxdataDir) throws OperatorException {
        int i;
        SstCoefficientSet coefficientSet;
        SstCoefficientLoader loader = new SstCoefficientLoader();
        try {
            coefficientSet = loader.load(this.dualCoefficientsFile.getURL(auxdataDir));
        }
        catch (IOException e) {
            throw new OperatorException((Throwable)e);
        }
        int n = coefficientSet.getNumCoefficients();
        int maxIndex = 0;
        for (i = 0; i < n; ++i) {
            int endIndex = coefficientSet.getCoefficientsAt(i).getEnd();
            if (endIndex <= maxIndex) continue;
            maxIndex = endIndex;
        }
        this.dualCoefficientIndexes = new int[maxIndex + 1];
        this.c0 = new float[n];
        this.c1 = new float[n];
        this.c2 = new float[n];
        this.c3 = new float[n];
        this.c4 = new float[n];
        this.d0 = new float[n];
        this.d1 = new float[n];
        this.d2 = new float[n];
        this.d3 = new float[n];
        this.d4 = new float[n];
        this.d5 = new float[n];
        this.d6 = new float[n];
        for (i = 0; i < n; ++i) {
            SstCoefficients coefficients = coefficientSet.getCoefficientsAt(i);
            for (int k = coefficients.getStart(); k <= coefficients.getEnd(); ++k) {
                this.dualCoefficientIndexes[k] = i;
            }
            float[] cCoefficients = coefficients.get_C_Coeffs();
            if (cCoefficients == null) {
                throw new OperatorException("Invalid coefficient file: no dual view \"c\" coefficients set");
            }
            this.c0[i] = cCoefficients[0] * 1.0f;
            this.c1[i] = cCoefficients[1];
            this.c2[i] = cCoefficients[2];
            this.c3[i] = cCoefficients[3];
            this.c4[i] = cCoefficients[4];
            float[] dCoefficients = coefficients.get_D_Coeffs();
            if (dCoefficients == null) {
                throw new OperatorException("Invalid coefficient file: no dual view \"d\" coefficients set");
            }
            this.d0[i] = dCoefficients[0] * 1.0f;
            this.d1[i] = dCoefficients[1];
            this.d2[i] = dCoefficients[2];
            this.d3[i] = dCoefficients[3];
            this.d4[i] = dCoefficients[4];
            this.d5[i] = dCoefficients[5];
            this.d6[i] = dCoefficients[6];
        }
    }

    private File installAuxiliaryData() {
        File defaultTargetDir = new File(SystemUtils.getApplicationDataDir(), "beam-aatsr-sst/auxdata/aatsr/sst");
        String targetPath = System.getProperty(SST_AUXDATA_DIR_PROPERTY, defaultTargetDir.getAbsolutePath());
        File targetDir = new File(targetPath);
        URL url = ResourceInstaller.getSourceUrl(((Object)((Object)this)).getClass());
        ResourceInstaller installer = new ResourceInstaller(url, "auxdata/aatsr/sst", targetDir);
        try {
            installer.install(".*", ProgressMonitor.NULL);
        }
        catch (IOException e) {
            throw new OperatorException((Throwable)e);
        }
        return targetDir;
    }

    private static boolean isMasked(OpImage maskOpImage, int x, int y) {
        int tileY;
        if (maskOpImage == null) {
            return true;
        }
        int tileX = maskOpImage.XToTileX(x);
        Raster tile = maskOpImage.getTile(tileX, tileY = maskOpImage.YToTileY(y));
        return tile.getSample(x, y, 0) != 0;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(AatsrSstOp.class);
        }
    }

    private static enum Files {
        AVERAGE_POLAR_DUAL_VIEW("Average polar dual view", "AV_POL_DUAL.coef"),
        AVERAGE_TEMPERATE_DUAL_VIEW("Average temperate dual view", "AV_TEM_DUAL.coef"),
        AVERAGE_TROPICAL_DUAL_VIEW("Average tropical dual view", "AV_TRO_DUAL.coef"),
        GRIDDED_POLAR_DUAL_VIEW("Gridded polar dual view", "GR_POL_DUAL.coef"),
        GRIDDED_TEMPERATE_DUAL_VIEW("Gridded temperate dual view", "GR_TEM_DUAL.coef"),
        GRIDDED_TROPICAL_DUAL_VIEW("Gridded tropical dual view", "GR_TRO_DUAL.coef"),
        AVERAGE_POLAR_SINGLE_VIEW("Average polar single view", "AV_POL_SING.coef"),
        AVERAGE_TEMPERATE_SINGLE_VIEW("Average temperate single view", "AV_TEM_SING.coef"),
        AVERAGE_TROPICAL_SINGLE_VIEW("Average tropical single view", "AV_TRO_SING.coef"),
        GRIDDED_POLAR_SINGLE_VIEW("Gridded polar single view", "GR_POL_SING.coef"),
        GRIDDED_TEMPERATE_SINGLE_VIEW("Gridded temperate single view", "GR_TEM_SING.coef"),
        GRIDDED_TROPICAL_SINGLE_VIEW("Gridded tropical single view", "GR_TRO_SING.coef"),
        GRIDDED_DUAL_VIEW_IPF("Gridded dual view (IPF)", "GR_IPF_DUAL.coef");

        private final String label;
        private final String filename;

        private Files(String label, String filename) {
            this.label = label;
            this.filename = filename;
        }

        public String toString() {
            return this.label;
        }

        private URL getURL(File dir) throws MalformedURLException {
            return new File(dir, this.filename).toURI().toURL();
        }
    }
}

