/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.seadas.dataio;

import gov.nasa.gsfc.seadas.dataio.Bundle;
import gov.nasa.gsfc.seadas.dataio.SeabassReader;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.EventListener;
import javax.swing.Action;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.PlacemarkDescriptor;
import org.esa.snap.core.datamodel.PlacemarkDescriptorRegistry;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.rcp.actions.AbstractSnapAction;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.product.ProductSceneView;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class ImportSeabassAction
extends AbstractSnapAction
implements ContextAwareAction,
LookupListener {
    private final Lookup lkp;

    public ImportSeabassAction() {
        this(Utilities.actionsGlobalContext());
    }

    public ImportSeabassAction(Lookup lkp) {
        this.lkp = lkp;
        Lookup.Result lkpContext = lkp.lookupResult(ProductNode.class);
        lkpContext.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), (Object)lkpContext));
        this.setEnableState();
        this.putValue("Name", Bundle.CTL_ImportSeabassActionText());
        this.putValue("ShortDescription", Bundle.CTL_ImportSeabassDescription());
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new ImportSeabassAction(actionContext);
    }

    public void resultChanged(LookupEvent ev) {
        this.setEnableState();
    }

    public void actionPerformed(ActionEvent event) {
        FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection;
        File file = Dialogs.requestFileForOpen((String)Bundle.CTL_ImportSeabassDialogTitle(), (boolean)false, null, (String)"importSeabass.lastDir");
        if (file == null) {
            return;
        }
        Product product = this.getAppContext().getSelectedProduct();
        try {
            featureCollection = ImportSeabassAction.readTrack(file, product.getSceneGeoCoding());
        }
        catch (Exception e) {
            Dialogs.showError((String)Bundle.CTL_ImportSeabassDialogTitle(), (String)("Failed to load SeaBASS file:\n" + e.getMessage()));
            return;
        }
        if (featureCollection.isEmpty()) {
            Dialogs.showError((String)Bundle.CTL_ImportSeabassDialogTitle(), (String)"No records found.");
            return;
        }
        String name = file.getName();
        PlacemarkDescriptor placemarkDescriptor = PlacemarkDescriptorRegistry.getInstance().getPlacemarkDescriptor((SimpleFeatureType)featureCollection.getSchema());
        placemarkDescriptor.setUserDataOf((SimpleFeatureType)featureCollection.getSchema());
        VectorDataNode vectorDataNode = new VectorDataNode(name, featureCollection, placemarkDescriptor);
        product.getVectorDataGroup().add((ProductNode)vectorDataNode);
        ProductSceneView view = this.getAppContext().getSelectedProductSceneView();
        if (view != null) {
            view.setLayersVisible(new VectorDataNode[]{vectorDataNode});
        }
    }

    public void setEnableState() {
        boolean state = false;
        ProductNode productNode = (ProductNode)this.lkp.lookup(ProductNode.class);
        if (productNode != null) {
            Product product = productNode.getProduct();
            state = product != null && product.getSceneGeoCoding() != null;
        }
        this.setEnabled(state);
    }

    private static FeatureCollection<SimpleFeatureType, SimpleFeature> readTrack(File file, GeoCoding geoCoding) throws IOException {
        try (FileReader reader = new FileReader(file);){
            FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection = ImportSeabassAction.readTrack(reader, geoCoding);
            return featureCollection;
        }
    }

    static FeatureCollection<SimpleFeatureType, SimpleFeature> readTrack(Reader reader, GeoCoding geoCoding) throws IOException {
        SeabassReader seabassReader = new SeabassReader(reader, geoCoding);
        return seabassReader.createFeatureCollection();
    }
}

