/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.selection;

import com.bc.ceres.swing.selection.AbstractSelectionContext;
import com.bc.ceres.swing.selection.Selection;
import com.bc.ceres.swing.selection.TracingSelectionChangeListener;
import com.bc.ceres.swing.selection.support.DefaultSelection;
import java.awt.datatransfer.StringSelection;
import junit.framework.TestCase;

public class AbstractSelectionContextTest
extends TestCase {
    public void testDefaultOperations() {
        MySelectionContext context = new MySelectionContext();
        AbstractSelectionContextTest.assertEquals((boolean)false, (boolean)context.canInsert(null));
        try {
            context.insert(new StringSelection("X"));
            AbstractSelectionContextTest.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        AbstractSelectionContextTest.assertEquals((boolean)false, (boolean)context.canDeleteSelection());
        try {
            context.deleteSelection();
            AbstractSelectionContextTest.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
        AbstractSelectionContextTest.assertEquals((boolean)false, (boolean)context.canSelectAll());
        try {
            context.selectAll();
            AbstractSelectionContextTest.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testSelectionChangeSupport() {
        MySelectionContext context = new MySelectionContext();
        AbstractSelectionContextTest.assertNotNull((Object)context.getSelectionChangeListeners());
        AbstractSelectionContextTest.assertEquals((int)0, (int)context.getSelectionChangeListeners().length);
        TracingSelectionChangeListener listener1 = new TracingSelectionChangeListener();
        context.addSelectionChangeListener(listener1);
        AbstractSelectionContextTest.assertNotNull((Object)context.getSelectionChangeListeners());
        AbstractSelectionContextTest.assertEquals((int)1, (int)context.getSelectionChangeListeners().length);
        AbstractSelectionContextTest.assertSame((Object)listener1, (Object)context.getSelectionChangeListeners()[0]);
        TracingSelectionChangeListener listener2 = new TracingSelectionChangeListener();
        context.addSelectionChangeListener(listener2);
        AbstractSelectionContextTest.assertNotNull((Object)context.getSelectionChangeListeners());
        AbstractSelectionContextTest.assertEquals((int)2, (int)context.getSelectionChangeListeners().length);
        AbstractSelectionContextTest.assertSame((Object)listener1, (Object)context.getSelectionChangeListeners()[0]);
        AbstractSelectionContextTest.assertSame((Object)listener2, (Object)context.getSelectionChangeListeners()[1]);
        context.removeSelectionChangeListener(listener2);
        context.removeSelectionChangeListener(listener1);
        AbstractSelectionContextTest.assertNotNull((Object)context.getSelectionChangeListeners());
        AbstractSelectionContextTest.assertEquals((int)0, (int)context.getSelectionChangeListeners().length);
        context.addSelectionChangeListener(listener1);
        context.fireSelectionChange((Selection)new DefaultSelection(new Object[]{"A"}));
        AbstractSelectionContextTest.assertEquals((String)"sc(A);", (String)listener1.trace);
        context.fireSelectionChange((Selection)new DefaultSelection(new Object[]{"B"}));
        AbstractSelectionContextTest.assertEquals((String)"sc(A);sc(B);", (String)listener1.trace);
        context.fireSelectionChange(Selection.EMPTY);
        AbstractSelectionContextTest.assertEquals((String)"sc(A);sc(B);sc();", (String)listener1.trace);
    }

    private static class MySelectionContext
    extends AbstractSelectionContext {
        private MySelectionContext() {
        }

        public void setSelection(Selection selection) {
        }

        public Selection getSelection() {
            return null;
        }

        public void fireSelectionChange(Selection selection) {
            super.fireSelectionChange(selection);
        }
    }
}

