/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure.support;

import com.bc.ceres.swing.figure.Figure;
import com.bc.ceres.swing.figure.FigureStyle;
import com.bc.ceres.swing.figure.TestFigure;
import com.bc.ceres.swing.figure.support.DefaultFigureSelection;
import com.bc.ceres.swing.figure.support.DefaultFigureStyle;
import com.bc.ceres.swing.figure.support.DefaultShapeFigure;
import java.awt.Rectangle;
import java.awt.Shape;
import org.junit.Assert;
import org.junit.Test;

public class DefaultFigureSelectionTest {
    @Test
    public void testThatFigureSelectionCannotBeSelected() {
        DefaultFigureSelection figureSelection = new DefaultFigureSelection();
        Assert.assertEquals((Object)false, (Object)figureSelection.isSelectable());
        Assert.assertEquals((Object)false, (Object)figureSelection.isSelected());
        figureSelection.setSelected(true);
        Assert.assertEquals((Object)false, (Object)figureSelection.isSelected());
    }

    @Test
    public void testThatNonSelectableFiguresAreNotSelected() {
        DefaultFigureSelection figureSelection = new DefaultFigureSelection();
        TestFigure f1 = new TestFigure(true);
        TestFigure f2 = new TestFigure(false);
        TestFigure f3 = new TestFigure(false);
        TestFigure f4 = new TestFigure(true);
        Assert.assertSame((Object)true, (Object)f1.isSelectable());
        Assert.assertSame((Object)false, (Object)f2.isSelectable());
        Assert.assertSame((Object)false, (Object)f3.isSelectable());
        Assert.assertSame((Object)true, (Object)f4.isSelectable());
        Assert.assertSame((Object)false, (Object)f1.isSelected());
        Assert.assertSame((Object)false, (Object)f2.isSelected());
        Assert.assertSame((Object)false, (Object)f3.isSelected());
        Assert.assertSame((Object)false, (Object)f4.isSelected());
        figureSelection.addFigures(new Figure[]{f1, f2, f3, f4});
        Assert.assertEquals((long)2L, (long)figureSelection.getFigureCount());
        Assert.assertSame((Object)((Object)f1), (Object)figureSelection.getFigure(0));
        Assert.assertSame((Object)((Object)f4), (Object)figureSelection.getFigure(1));
        Assert.assertSame((Object)true, (Object)f1.isSelected());
        Assert.assertSame((Object)false, (Object)f2.isSelected());
        Assert.assertSame((Object)false, (Object)f3.isSelected());
        Assert.assertSame((Object)true, (Object)f4.isSelected());
        figureSelection.removeAllFigures();
        Assert.assertEquals((long)0L, (long)figureSelection.getFigureCount());
        Assert.assertSame((Object)false, (Object)f1.isSelected());
        Assert.assertSame((Object)false, (Object)f2.isSelected());
        Assert.assertSame((Object)false, (Object)f3.isSelected());
        Assert.assertSame((Object)false, (Object)f4.isSelected());
    }

    @Test
    public void testPropagateSelectionState() {
        DefaultShapeFigure figure = new DefaultShapeFigure((Shape)new Rectangle(0, 0, 10, 10), Figure.Rank.AREA, (FigureStyle)new DefaultFigureStyle());
        DefaultFigureSelection figureSelection = new DefaultFigureSelection();
        Assert.assertEquals((Object)false, (Object)figureSelection.isSelected());
        Assert.assertEquals((Object)false, (Object)figure.isSelected());
        figureSelection.addFigure((Figure)figure);
        Assert.assertEquals((Object)false, (Object)figureSelection.isSelected());
        Assert.assertEquals((Object)true, (Object)figure.isSelected());
        figureSelection.removeFigure((Figure)figure);
        Assert.assertEquals((Object)false, (Object)figureSelection.isSelected());
        Assert.assertEquals((Object)false, (Object)figure.isSelected());
    }
}

