/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure.support;

import com.bc.ceres.swing.figure.Figure;
import com.bc.ceres.swing.figure.FigureChangeEvent;
import com.bc.ceres.swing.figure.FigureChangeListener;
import com.bc.ceres.swing.figure.support.DefaultFigureCollection;
import java.awt.geom.Rectangle2D;
import junit.framework.TestCase;

public class DefaultFigureCollectionTest
extends TestCase {
    public void testDefaultProperties() {
        DefaultFigureCollection fc = new DefaultFigureCollection();
        DefaultFigureCollectionTest.assertEquals((boolean)true, (boolean)fc.isSelectable());
        DefaultFigureCollectionTest.assertEquals((boolean)true, (boolean)fc.isCollection());
        DefaultFigureCollectionTest.assertEquals((Object)Figure.Rank.NOT_SPECIFIED, (Object)fc.getRank());
        DefaultFigureCollectionTest.assertEquals((Object)new Rectangle2D.Double(), (Object)fc.getBounds());
        DefaultFigureCollectionTest.assertEquals((int)1, (int)fc.getMaxSelectionStage());
        DefaultFigureCollectionTest.assertEquals((int)0, (int)fc.getFigureCount());
    }

    public void testThatChildChangesArePropagated() {
        DefaultFigureCollection fc = new DefaultFigureCollection();
        DefaultFigureCollection f1 = new DefaultFigureCollection();
        DefaultFigureCollection f2 = new DefaultFigureCollection();
        fc.addFigure((Figure)f1);
        fc.addFigure((Figure)f2);
        MyFigureListener listener = new MyFigureListener();
        fc.addChangeListener((FigureChangeListener)listener);
        f1.addFigure((Figure)new DefaultFigureCollection());
        DefaultFigureCollectionTest.assertNotNull((Object)listener.lastEvent);
        DefaultFigureCollectionTest.assertEquals((Object)FigureChangeEvent.FIGURES_ADDED, (Object)listener.lastEvent.getType());
        DefaultFigureCollectionTest.assertEquals((Object)f1, (Object)listener.lastEvent.getSourceFigure());
        f2.addFigure((Figure)new DefaultFigureCollection());
        DefaultFigureCollectionTest.assertNotNull((Object)listener.lastEvent);
        DefaultFigureCollectionTest.assertEquals((Object)FigureChangeEvent.FIGURES_ADDED, (Object)listener.lastEvent.getType());
        DefaultFigureCollectionTest.assertEquals((Object)f2, (Object)listener.lastEvent.getSourceFigure());
    }

    public void testAddingAndRemovingChildren() {
        DefaultFigureCollection fc = new DefaultFigureCollection();
        DefaultFigureCollectionTest.assertEquals((int)0, (int)fc.getFigureCount());
        DefaultFigureCollectionTest.assertNotNull((Object)fc.getFigures());
        DefaultFigureCollectionTest.assertEquals((int)0, (int)fc.getFigures().length);
        DefaultFigureCollection f1 = new DefaultFigureCollection();
        DefaultFigureCollection f2 = new DefaultFigureCollection();
        fc.addFigure((Figure)f1);
        fc.addFigure((Figure)f2);
        DefaultFigureCollectionTest.assertEquals((int)2, (int)fc.getFigureCount());
        DefaultFigureCollectionTest.assertNotNull((Object)fc.getFigures());
        DefaultFigureCollectionTest.assertEquals((int)2, (int)fc.getFigures().length);
        DefaultFigureCollectionTest.assertSame((Object)f1, (Object)fc.getFigures()[0]);
        DefaultFigureCollectionTest.assertSame((Object)f2, (Object)fc.getFigures()[1]);
        fc.addFigure((Figure)f2);
        DefaultFigureCollectionTest.assertEquals((int)2, (int)fc.getFigureCount());
        DefaultFigureCollectionTest.assertNotNull((Object)fc.getFigures());
        DefaultFigureCollectionTest.assertEquals((int)2, (int)fc.getFigures().length);
        DefaultFigureCollectionTest.assertSame((Object)f1, (Object)fc.getFigures()[0]);
        DefaultFigureCollectionTest.assertSame((Object)f2, (Object)fc.getFigures()[1]);
        fc.removeFigure((Figure)f1);
        DefaultFigureCollectionTest.assertEquals((int)1, (int)fc.getFigureCount());
        DefaultFigureCollectionTest.assertNotNull((Object)fc.getFigures());
        DefaultFigureCollectionTest.assertEquals((int)1, (int)fc.getFigures().length);
        DefaultFigureCollectionTest.assertSame((Object)f2, (Object)fc.getFigures()[0]);
        fc.removeAllFigures();
        DefaultFigureCollectionTest.assertEquals((int)0, (int)fc.getFigureCount());
    }

    public void testListener() {
        DefaultFigureCollection fc = new DefaultFigureCollection();
        MyFigureListener listener = new MyFigureListener();
        fc.addChangeListener((FigureChangeListener)listener);
        DefaultFigureCollection f1 = new DefaultFigureCollection();
        fc.addFigure((Figure)f1);
        DefaultFigureCollectionTest.assertEquals((Object)FigureChangeEvent.FIGURES_ADDED, (Object)listener.lastEvent.getType());
        DefaultFigureCollectionTest.assertSame((Object)fc, (Object)listener.lastEvent.getSourceFigure());
        DefaultFigureCollectionTest.assertNotNull((Object)listener.lastEvent.getFigures());
        DefaultFigureCollectionTest.assertEquals((int)1, (int)listener.lastEvent.getFigures().length);
        DefaultFigureCollectionTest.assertSame((Object)f1, (Object)listener.lastEvent.getFigures()[0]);
        f1.setSelectable(true);
        DefaultFigureCollectionTest.assertEquals((Object)FigureChangeEvent.FIGURE_CHANGED, (Object)listener.lastEvent.getType());
        DefaultFigureCollectionTest.assertSame((Object)f1, (Object)listener.lastEvent.getSourceFigure());
        DefaultFigureCollectionTest.assertNull((Object)listener.lastEvent.getFigures());
        DefaultFigureCollection f2 = new DefaultFigureCollection();
        fc.addFigure((Figure)f2);
        DefaultFigureCollectionTest.assertEquals((Object)FigureChangeEvent.FIGURES_ADDED, (Object)listener.lastEvent.getType());
        DefaultFigureCollectionTest.assertSame((Object)fc, (Object)listener.lastEvent.getSourceFigure());
        DefaultFigureCollectionTest.assertNotNull((Object)listener.lastEvent.getFigures());
        DefaultFigureCollectionTest.assertEquals((int)1, (int)listener.lastEvent.getFigures().length);
        DefaultFigureCollectionTest.assertSame((Object)f2, (Object)listener.lastEvent.getFigures()[0]);
        fc.removeAllFigures();
        DefaultFigureCollectionTest.assertEquals((Object)FigureChangeEvent.FIGURES_REMOVED, (Object)listener.lastEvent.getType());
        DefaultFigureCollectionTest.assertSame((Object)fc, (Object)listener.lastEvent.getSourceFigure());
        DefaultFigureCollectionTest.assertNotNull((Object)listener.lastEvent.getFigures());
        DefaultFigureCollectionTest.assertEquals((int)2, (int)listener.lastEvent.getFigures().length);
        DefaultFigureCollectionTest.assertSame((Object)f1, (Object)listener.lastEvent.getFigures()[0]);
        DefaultFigureCollectionTest.assertSame((Object)f2, (Object)listener.lastEvent.getFigures()[1]);
    }

    private static class MyFigureListener
    implements FigureChangeListener {
        FigureChangeEvent lastEvent;

        private MyFigureListener() {
        }

        public void figureChanged(FigureChangeEvent event) {
            this.lastEvent = event;
        }
    }
}

