/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.binding.internal;

import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.internal.TextFieldEditor;
import javax.swing.JComponent;
import javax.swing.JTextField;
import junit.framework.TestCase;

public class TextFieldEditorTest
extends TestCase {
    public void testIsApplicable() throws Exception {
        TextFieldEditor textEditor = new TextFieldEditor();
        PropertyDescriptor textDescriptor = new PropertyDescriptor("test", String.class);
        TextFieldEditorTest.assertFalse((boolean)textEditor.isValidFor(textDescriptor));
        PropertyDescriptor booleanDescriptor = new PropertyDescriptor("test", Boolean.TYPE);
        TextFieldEditorTest.assertFalse((boolean)textEditor.isValidFor(booleanDescriptor));
    }

    public void testCreateEditorComponent() throws Exception {
        TextFieldEditor textEditor = new TextFieldEditor();
        PropertyContainer propertyContainer = PropertyContainer.createValueBacked(V.class);
        BindingContext bindingContext = new BindingContext((PropertySet)propertyContainer);
        PropertyDescriptor propertyDescriptor = propertyContainer.getDescriptor("value");
        TextFieldEditorTest.assertSame(String.class, (Object)propertyDescriptor.getType());
        JComponent editorComponent = textEditor.createEditorComponent(propertyDescriptor, bindingContext);
        TextFieldEditorTest.assertNotNull((Object)editorComponent);
        TextFieldEditorTest.assertSame(JTextField.class, editorComponent.getClass());
        JComponent[] components = bindingContext.getBinding("value").getComponents();
        TextFieldEditorTest.assertEquals((int)1, (int)components.length);
        TextFieldEditorTest.assertSame(JTextField.class, components[0].getClass());
    }

    private static class V {
        String value;

        private V() {
        }
    }
}

