/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.binding.internal;

import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.internal.MultiSelectionEditor;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import junit.framework.TestCase;

public class MultiSelectionEditorTest
extends TestCase {
    public void testIsApplicable() throws Exception {
        MultiSelectionEditor multiSelEditor = new MultiSelectionEditor();
        ValueSet valueSet = new ValueSet((Object[])new Double[]{42.0, 84.0});
        PropertyDescriptor doubleArrayDescriptor = new PropertyDescriptor("test", Double[].class);
        doubleArrayDescriptor.setValueSet(valueSet);
        MultiSelectionEditorTest.assertTrue((boolean)multiSelEditor.isValidFor(doubleArrayDescriptor));
        doubleArrayDescriptor = new PropertyDescriptor("test", Double.class);
        doubleArrayDescriptor.setValueSet(valueSet);
        MultiSelectionEditorTest.assertFalse((boolean)multiSelEditor.isValidFor(doubleArrayDescriptor));
        doubleArrayDescriptor = new PropertyDescriptor("test", Double[].class);
        MultiSelectionEditorTest.assertFalse((boolean)multiSelEditor.isValidFor(doubleArrayDescriptor));
        PropertyDescriptor doubleDescriptor = new PropertyDescriptor("test", Double.TYPE);
        MultiSelectionEditorTest.assertFalse((boolean)multiSelEditor.isValidFor(doubleDescriptor));
    }

    public void testCreateEditorComponent() throws Exception {
        MultiSelectionEditor multiSelEditor = new MultiSelectionEditor();
        PropertyContainer propertyContainer = PropertyContainer.createValueBacked(V.class);
        BindingContext bindingContext = new BindingContext((PropertySet)propertyContainer);
        PropertyDescriptor propertyDescriptor = propertyContainer.getDescriptor("value");
        ValueSet valueSet = new ValueSet((Object[])new Double[]{42.0, 84.0});
        propertyDescriptor.setValueSet(valueSet);
        MultiSelectionEditorTest.assertSame(Double[].class, (Object)propertyDescriptor.getType());
        MultiSelectionEditorTest.assertTrue((boolean)multiSelEditor.isValidFor(propertyDescriptor));
        JComponent editorComponent = multiSelEditor.createEditorComponent(propertyDescriptor, bindingContext);
        MultiSelectionEditorTest.assertNotNull((Object)editorComponent);
        MultiSelectionEditorTest.assertSame(JScrollPane.class, editorComponent.getClass());
        JComponent[] components = bindingContext.getBinding("value").getComponents();
        MultiSelectionEditorTest.assertEquals((int)1, (int)components.length);
        MultiSelectionEditorTest.assertSame(JList.class, components[0].getClass());
    }

    private static class V {
        Double[] value;

        private V() {
        }
    }
}

